/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.bnd;

import aQute.bnd.osgi.Annotation;
import java.util.Arrays;
import java.util.Set;
import org.apache.felix.dm.annotation.plugin.bnd.AnnotationCollector;
import org.apache.felix.dm.annotation.plugin.bnd.EntryParam;
import org.apache.felix.dm.annotation.plugin.bnd.EntryType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EntryWriter {
    private static final String TYPE = "type";
    private JSONObject m_json;
    private EntryType m_type;

    public EntryWriter(EntryType type) {
        this.m_type = type;
        this.m_json = new JSONObject();
        try {
            this.m_json.put(TYPE, type.toString());
        }
        catch (JSONException e) {
            throw new RuntimeException("could not initialize json object", e);
        }
    }

    EntryType getEntryType() {
        return this.m_type;
    }

    public String toString() {
        return this.m_json.toString();
    }

    public void put(EntryParam param, String value) {
        this.checkType(param.toString());
        try {
            this.m_json.put(param.toString(), value);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("could not add param " + (Object)((Object)param) + ":" + value, e);
        }
    }

    public void put(EntryParam param, String[] array) {
        this.checkType(param.toString());
        try {
            this.m_json.put(param.toString(), new JSONArray(Arrays.asList(array)));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("could not add param " + (Object)((Object)param) + ":" + Arrays.toString(array), e);
        }
    }

    public void putJsonObject(EntryParam param, JSONObject jsonObject) throws JSONException {
        this.m_json.put(param.toString(), jsonObject);
    }

    public String putString(Annotation annotation, EntryParam param, String def) {
        this.checkType(param.toString());
        Object value = annotation.get(param.toString());
        if (value == null && def != null) {
            value = def;
        }
        if (value != null) {
            this.put(param, value.toString());
        }
        return value == null ? null : value.toString();
    }

    public void putStringArray(Annotation annotation, EntryParam param, String[] def) {
        this.checkType(param.toString());
        String[] value = annotation.get(param.toString());
        if (value == null && def != null) {
            value = def;
        }
        if (value != null) {
            for (Object v : (Object[])value) {
                try {
                    this.m_json.append(param.toString(), v.toString());
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException("Could not add param " + (Object)((Object)param) + ":" + value.toString(), e);
                }
            }
        }
    }

    public void putClass(Annotation annotation, EntryParam param) {
        this.checkType(param.toString());
        String value = AnnotationCollector.parseClassAttrValue(annotation.get(param.toString()));
        if (value != null) {
            this.put(param, value);
        }
    }

    public int putClassArray(Annotation annotation, EntryParam param, Object def, Set<String> collect) {
        this.checkType(param.toString());
        boolean usingDefault = false;
        Object value = annotation.get(param.toString());
        if (value == null && def != null) {
            value = def;
            usingDefault = true;
        }
        if (value != null) {
            if (!(value instanceof Object[])) {
                throw new IllegalArgumentException("annotation parameter " + (Object)((Object)param) + " has not a class array type");
            }
            for (Object v : (Object[])value) {
                if (!usingDefault) {
                    v = AnnotationCollector.parseClassAttrValue(v);
                }
                try {
                    this.m_json.append(param.toString(), v.toString());
                    collect.add(v.toString());
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException("Could not add param " + (Object)((Object)param) + ":" + value.toString(), e);
                }
            }
            return ((Object[])value).length;
        }
        return 0;
    }

    private void checkType(String key) {
        if (TYPE.equals(key)) {
            throw new IllegalArgumentException("\"type\" parameter can't be overriden");
        }
    }
}

