/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.util.Dictionary;
import java.util.List;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.ComponentInstanceImpl;
import org.apache.felix.dm.runtime.Log;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.api.ComponentException;
import org.apache.felix.dm.runtime.api.ComponentFactory;
import org.apache.felix.dm.runtime.api.ComponentInstance;
import org.osgi.framework.Bundle;

public class ComponentFactoryImpl
implements ComponentFactory {
    private MetaData m_srvMeta;
    private List<MetaData> m_depsMeta;
    private DependencyManager m_dm;
    private volatile boolean m_active;
    private final Bundle m_bundle;

    public ComponentFactoryImpl(Bundle b, MetaData srvMeta, List<MetaData> depsMeta) {
        this.m_bundle = b;
        this.m_srvMeta = srvMeta;
        this.m_depsMeta = depsMeta;
    }

    public void start(Component c) {
        this.m_active = true;
        this.m_dm = c.getDependencyManager();
    }

    public void stop() {
        this.m_active = false;
    }

    @Override
    public ComponentInstance newInstance(Dictionary<String, ?> conf) {
        if (conf == null) {
            throw new NullPointerException("configuration parameter can't be null");
        }
        this.checkServiceAvailable();
        try {
            ComponentInstanceImpl instance = new ComponentInstanceImpl(this.m_dm, this.m_bundle, this.m_srvMeta, this.m_depsMeta, conf);
            return instance;
        }
        catch (Throwable t) {
            Log.instance().error("ServiceFactory: could not instantiate service %s", t, this.m_srvMeta);
            throw new ComponentException("could not instantiate factory component", t);
        }
    }

    private void checkServiceAvailable() {
        if (!this.m_active) {
            throw new IllegalStateException("Service not available");
        }
    }
}

