/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.AdapterServiceBuilder;
import org.apache.felix.dm.runtime.AspectServiceBuilder;
import org.apache.felix.dm.runtime.BundleAdapterServiceBuilder;
import org.apache.felix.dm.runtime.ComponentBuilder;
import org.apache.felix.dm.runtime.DescriptorParser;
import org.apache.felix.dm.runtime.FactoryConfigurationAdapterServiceBuilder;
import org.apache.felix.dm.runtime.Log;
import org.apache.felix.dm.runtime.ResourceAdapterServiceBuilder;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.PackageAdmin;

public class DependencyManagerRuntime {
    private final Map<Bundle, DependencyManager> m_managers = new HashMap<Bundle, DependencyManager>();
    private final DescriptorParser m_parser = new DescriptorParser();
    private volatile PackageAdmin m_packageAdmin;

    public DependencyManagerRuntime() {
        this.m_parser.addBuilder(new ComponentBuilder());
        this.m_parser.addBuilder(new AspectServiceBuilder());
        this.m_parser.addBuilder(new AdapterServiceBuilder());
        this.m_parser.addBuilder(new BundleAdapterServiceBuilder());
        this.m_parser.addBuilder(new FactoryConfigurationAdapterServiceBuilder());
        this.m_parser.addBuilder(new ResourceAdapterServiceBuilder());
    }

    protected Object[] getComposition() {
        return new Object[]{this, Log.instance()};
    }

    protected void start() {
        Log.instance().info("Starting Dependency Manager annotation runtime", new Object[0]);
    }

    protected void stop() {
        Log.instance().info("Runtime: stopping services", new Object[0]);
        for (DependencyManager dm : this.m_managers.values()) {
            ArrayList services = new ArrayList(dm.getComponents());
            for (Component service : services) {
                dm.remove(service);
            }
        }
        this.m_managers.clear();
    }

    protected void bundleStarted(Bundle bundle) {
        Log.instance().info("Scanning started bundle %s", bundle.getSymbolicName());
        ArrayList<URL> descriptorURLs = new ArrayList<URL>();
        this.collectDescriptors(bundle, descriptorURLs);
        Bundle[] fragments = this.m_packageAdmin.getFragments(bundle);
        if (fragments != null) {
            Bundle[] bundleArray = fragments;
            int n = fragments.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle fragment = bundleArray[n2];
                this.collectDescriptors(fragment, descriptorURLs);
                ++n2;
            }
        }
        for (URL descriptorURL : descriptorURLs) {
            this.loadDescriptor(bundle, descriptorURL);
        }
    }

    protected void bundleStopped(Bundle b) {
        Log.instance().info("Runtime: Removing services from stopping bundle: %s", b.getSymbolicName());
        DependencyManager dm = this.m_managers.remove(b);
        if (dm != null) {
            ArrayList services = new ArrayList(dm.getComponents());
            for (Component service : services) {
                Log.instance().info("Runtime: Removing service: %s", service);
                dm.remove(service);
            }
        }
    }

    private void collectDescriptors(Bundle bundle, List<URL> out) {
        String descriptorPaths = (String)bundle.getHeaders().get("DependencyManager-Component");
        if (descriptorPaths == null) {
            return;
        }
        String[] stringArray = descriptorPaths.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String descriptorPath = stringArray[n2];
            URL descriptorURL = bundle.getEntry(descriptorPath);
            if (descriptorURL == null) {
                Log.instance().error("Runtime: DependencyManager component descriptor not found: %s", descriptorPath);
            } else {
                out.add(descriptorURL);
            }
            ++n2;
        }
    }

    private void loadDescriptor(Bundle b, URL descriptorURL) {
        block13: {
            Log.instance().debug("Parsing descriptor %s from bundle %s", descriptorURL, b.getSymbolicName());
            BufferedReader in = null;
            try {
                try {
                    in = new BufferedReader(new InputStreamReader(descriptorURL.openStream()));
                    DependencyManager dm = this.m_managers.get(b);
                    if (dm == null) {
                        dm = new DependencyManager(b.getBundleContext());
                        this.m_managers.put(b, dm);
                    }
                    this.m_parser.parse(in, b, dm);
                }
                catch (Throwable t) {
                    Log.instance().error("Runtime: Error while parsing descriptor %s from bundle %s", t, descriptorURL, b.getSymbolicName());
                    if (in == null) break block13;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

