/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.AbstractBuilder;
import org.apache.felix.dm.runtime.JSONMetaData;
import org.apache.felix.dm.runtime.Log;
import org.apache.felix.dm.runtime.MetaData;
import org.json.JSONObject;
import org.osgi.framework.Bundle;

public class DescriptorParser {
    private Map<String, AbstractBuilder> m_builders = new HashMap<String, AbstractBuilder>();

    public void addBuilder(AbstractBuilder sb) {
        this.m_builders.put(sb.getType(), sb);
    }

    public void parse(BufferedReader reader, Bundle b, DependencyManager dm) throws Exception {
        String line = reader.readLine();
        Log.instance().debug("DescriptorParser: parsing service %s", line);
        JSONObject json = new JSONObject(line);
        JSONMetaData serviceMetaData = new JSONMetaData(json);
        String type = (String)json.get("type");
        if (type == null) {
            throw new IllegalArgumentException("Invalid descriptor: no \"type\" parameter found in first line");
        }
        AbstractBuilder builder = this.m_builders.get(type);
        if (builder == null) {
            throw new IllegalArgumentException("Invalid descriptor: invalid \"type\" parameter found in first line");
        }
        ArrayList<MetaData> serviceDependencies = new ArrayList<MetaData>();
        while ((line = reader.readLine()) != null) {
            Log.instance().debug("Parsing dependency %s", line);
            JSONObject dep = new JSONObject(line);
            serviceDependencies.add(new JSONMetaData(dep));
        }
        builder.build(serviceMetaData, serviceDependencies, b, dm);
    }
}

