/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class InvocationUtil {
    public static Object invokeCallbackMethod(Object instance, String methodName, Class<?>[][] signatures, Object[][] parameters) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> currentClazz = instance.getClass();
        while (currentClazz != null) {
            try {
                return InvocationUtil.invokeMethod(instance, currentClazz, methodName, signatures, parameters, false);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                currentClazz = currentClazz.getSuperclass();
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public static Object invokeMethod(Object object, Class<?> clazz, String name, Class<?>[][] signatures, Object[][] parameters, boolean isSuper) throws NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        if (object == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (Proxy.isProxyClass(clazz)) {
            object = Proxy.getInvocationHandler(object);
            clazz = object.getClass();
        }
        int i = 0;
        while (i < signatures.length) {
            Class<?>[] signature = signatures[i];
            try {
                final Method m = clazz.getDeclaredMethod(name, signature);
                if (!isSuper || !Modifier.isPrivate(m.getModifiers())) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            m.setAccessible(true);
                            return null;
                        }
                    });
                    return m.invoke(object, parameters[i]);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            ++i;
        }
        throw new NoSuchMethodException(name);
    }
}

