/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.DependencyBuilder;
import org.apache.felix.dm.runtime.InvocationUtil;
import org.apache.felix.dm.runtime.Log;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.apache.felix.dm.runtime.ToggleServiceDependency;
import org.osgi.framework.Bundle;

public class ServiceLifecycleHandler {
    private final String m_init;
    private final String m_start;
    private final String m_stop;
    private final String m_destroy;
    private final MetaData m_srvMeta;
    private final List<MetaData> m_depsMeta;
    private final Bundle m_bundle;
    private static final Object SYNC = new Object();

    public ServiceLifecycleHandler(Component srv, Bundle srvBundle, DependencyManager dm, MetaData srvMeta, List<MetaData> depMeta) {
        this.m_srvMeta = srvMeta;
        this.m_init = srvMeta.getString(Params.init, null);
        this.m_start = srvMeta.getString(Params.start, null);
        this.m_stop = srvMeta.getString(Params.stop, null);
        this.m_destroy = srvMeta.getString(Params.destroy, null);
        this.m_bundle = srvBundle;
        this.m_depsMeta = depMeta;
    }

    public void init(Component c) throws Exception {
        Object[] composites;
        Object serviceInstance = c.getInstances()[0];
        DependencyManager dm = c.getDependencyManager();
        String starter = this.m_srvMeta.getString(Params.starter, null);
        String stopper = this.m_srvMeta.getString(Params.stopper, null);
        ArrayList<ToggleServiceDependency> instanceBoundDeps = new ArrayList<ToggleServiceDependency>();
        if (starter != null) {
            Log.instance().debug("Setting up a lifecycle controller for service %s", serviceInstance);
            String componentName = serviceInstance.getClass().getName();
            ToggleServiceDependency toggle = new ToggleServiceDependency();
            AtomicBoolean startFlag = new AtomicBoolean(false);
            instanceBoundDeps.add(toggle);
            this.setField(serviceInstance, starter, Runnable.class, new ComponentStarter(componentName, toggle, startFlag));
            if (stopper != null) {
                this.setField(serviceInstance, stopper, Runnable.class, new ComponentStopper(componentName, toggle, startFlag));
            }
        }
        ToggleServiceDependency initToggle = null;
        if (this.m_init != null) {
            initToggle = new ToggleServiceDependency();
            c.add(new Dependency[]{initToggle});
        }
        HashMap customization = new HashMap();
        Object[] objectArray = composites = c.getInstances();
        int n = composites.length;
        int n2 = 0;
        while (n2 < n) {
            Object composite = objectArray[n2];
            Object o = this.invokeMethod(composite, this.m_init, dm, c);
            if (o != null && Map.class.isAssignableFrom(o.getClass())) {
                customization.putAll((Map)o);
            }
            ++n2;
        }
        Log.instance().debug("ServiceLifecycleHandler.init: invoked init method from service %s , returned map: %s", serviceInstance, customization);
        for (MetaData dependency : this.m_depsMeta) {
            String name = dependency.getString(Params.name, null);
            if (name == null) continue;
            String filter = (String)customization.get(String.valueOf(name) + ".filter");
            String required = (String)customization.get(String.valueOf(name) + ".required");
            String pid = (String)customization.get(String.valueOf(name) + ".pid");
            String propagate = (String)customization.get(String.valueOf(name) + ".propagate");
            if (filter != null || required != null || pid != null || propagate != null) {
                dependency = (MetaData)dependency.clone();
                if (filter != null) {
                    dependency.setString(Params.filter, filter);
                }
                if (required != null) {
                    dependency.setString(Params.required, required);
                }
                if (pid != null) {
                    dependency.setString(Params.pid, pid);
                }
                if (propagate != null) {
                    dependency.setString(Params.propagate, propagate);
                }
            }
            DependencyBuilder depBuilder = new DependencyBuilder(dependency);
            Log.instance().info("ServiceLifecycleHandler.init: adding dependency %s into service %s", dependency, this.m_srvMeta);
            Dependency d = depBuilder.build(this.m_bundle, dm);
            instanceBoundDeps.add((ToggleServiceDependency)d);
        }
        if (instanceBoundDeps.size() > 0) {
            Log.instance().info("ServiceLifecycleHandler.init: adding extra/named dependencies %s", instanceBoundDeps);
            c.add(instanceBoundDeps.toArray(new Dependency[instanceBoundDeps.size()]));
        }
        if (initToggle != null) {
            c.remove((Dependency)initToggle);
        }
    }

    public void start(Component service) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] composites;
        DependencyManager dm = service.getDependencyManager();
        HashMap extraProperties = new HashMap();
        Object[] objectArray = composites = service.getInstances();
        int n = composites.length;
        int n2 = 0;
        while (n2 < n) {
            Object composite = objectArray[n2];
            Object o = this.invokeMethod(composite, this.m_start, dm, service);
            if (o != null && Map.class.isAssignableFrom(o.getClass())) {
                extraProperties.putAll((Map)o);
            }
            ++n2;
        }
        if (extraProperties.size() > 0) {
            Dictionary existingProperties = service.getServiceProperties();
            if (existingProperties != null) {
                Hashtable props = new Hashtable();
                Enumeration e = existingProperties.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    props.put(key, existingProperties.get(key));
                }
                props.putAll(extraProperties);
                service.setServiceProperties(props);
            } else {
                service.setServiceProperties(new Hashtable(extraProperties));
            }
        }
    }

    public void stop(Component service) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.callbackComposites(service, this.m_stop);
    }

    public void destroy(Component service) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.callbackComposites(service, this.m_destroy);
    }

    private void callbackComposites(Component service, String callback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] composites;
        Object[] objectArray = composites = service.getInstances();
        int n = composites.length;
        int n2 = 0;
        while (n2 < n) {
            Object composite = objectArray[n2];
            this.invokeMethod(composite, callback, service.getDependencyManager(), service);
            ++n2;
        }
    }

    private Object invokeMethod(Object serviceInstance, String method, DependencyManager dm, Component c) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (method != null) {
            try {
                return InvocationUtil.invokeCallbackMethod(serviceInstance, method, new Class[][]{{Component.class}, new Class[0]}, new Object[][]{{c}, new Object[0]});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setField(Object instance, String fieldName, Class<?> fieldClass, Object fieldValue) {
        Object serviceInstance = instance;
        Class<?> serviceClazz = serviceInstance.getClass();
        if (Proxy.isProxyClass(serviceClazz)) {
            serviceInstance = Proxy.getInvocationHandler(serviceInstance);
            serviceClazz = serviceInstance.getClass();
        }
        while (serviceClazz != null) {
            Field[] fields = serviceClazz.getDeclaredFields();
            int j = 0;
            while (j < fields.length) {
                Field field = fields[j];
                Class<?> type = field.getType();
                if (field.getName().equals(fieldName) && type.isAssignableFrom(fieldClass)) {
                    try {
                        field.setAccessible(true);
                        Object object = SYNC;
                        synchronized (object) {
                            field.set(serviceInstance, fieldValue);
                        }
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("Could not set field " + field, e);
                    }
                }
                ++j;
            }
            serviceClazz = serviceClazz.getSuperclass();
        }
    }

    private static class ComponentStarter
    implements Runnable {
        private final String m_componentName;
        private final ToggleServiceDependency m_toggle;
        private final AtomicBoolean m_startFlag;

        public ComponentStarter(String name, ToggleServiceDependency toggle, AtomicBoolean startFlag) {
            this.m_componentName = name;
            this.m_toggle = toggle;
            this.m_startFlag = startFlag;
        }

        @Override
        public void run() {
            if (this.m_startFlag.compareAndSet(false, true)) {
                Log.instance().debug("Lifecycle controller is activating the component %s", this.m_componentName);
                this.m_toggle.activate(true);
            }
        }
    }

    private static class ComponentStopper
    implements Runnable {
        private final Object m_componentName;
        private final ToggleServiceDependency m_toggle;
        private final AtomicBoolean m_startFlag;

        public ComponentStopper(String componentName, ToggleServiceDependency toggle, AtomicBoolean startFlag) {
            this.m_componentName = componentName;
            this.m_toggle = toggle;
            this.m_startFlag = startFlag;
        }

        @Override
        public void run() {
            if (this.m_startFlag.compareAndSet(true, false)) {
                Log.instance().debug("Lifecycle controller is deactivating the component %s", this.m_componentName);
                this.m_toggle.activate(false);
            }
        }
    }
}

