/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.felix.dm.Logger;

public class SerialExecutor
implements Executor {
    protected final ConcurrentLinkedQueue<Runnable> m_tasks = new ConcurrentLinkedQueue();
    protected final AtomicReference<Thread> m_runningThread = new AtomicReference();
    private final Logger m_logger;

    public SerialExecutor(Logger logger) {
        this.m_logger = logger;
    }

    public void schedule(Runnable task) {
        this.m_tasks.add(task);
    }

    public void execute() {
        Thread currentThread = Thread.currentThread();
        if (this.m_runningThread.compareAndSet(null, currentThread)) {
            this.runTasks(currentThread);
        }
    }

    @Override
    public void execute(Runnable task) {
        Thread currentThread = Thread.currentThread();
        if (this.m_runningThread.get() == currentThread) {
            this.runTask(task);
        } else {
            this.schedule(task);
            this.execute();
        }
    }

    private void runTasks(Thread currentRunninghread) {
        do {
            try {
                Runnable task;
                ConcurrentLinkedQueue<Runnable> tasks = this.m_tasks;
                while ((task = tasks.poll()) != null) {
                    this.runTask(task);
                }
            }
            finally {
                this.m_runningThread.set(null);
            }
        } while (!this.m_tasks.isEmpty() && this.m_runningThread.compareAndSet(null, currentRunninghread));
    }

    void runTask(Runnable command) {
        try {
            command.run();
        }
        catch (Throwable t) {
            if (this.m_logger != null) {
                this.m_logger.log(1, "Error processing tasks", t);
            }
            t.printStackTrace();
        }
    }

    public String toString() {
        return "[Executor: queue size: " + this.m_tasks.size() + "]";
    }
}

