/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda;

import java.util.Dictionary;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.lambda.BundleDependencyBuilder;
import org.apache.felix.dm.lambda.ConfigurationDependencyBuilder;
import org.apache.felix.dm.lambda.FluentProperty;
import org.apache.felix.dm.lambda.FutureDependencyBuilder;
import org.apache.felix.dm.lambda.ServiceDependencyBuilder;
import org.apache.felix.dm.lambda.callbacks.InstanceCb;
import org.apache.felix.dm.lambda.callbacks.InstanceCbComponent;

public interface ComponentBuilder<B extends ComponentBuilder<B>> {
    public B impl(Object var1);

    public B factory(Object var1, String var2);

    public B factory(Supplier<?> var1);

    public <U, V> B factory(Supplier<U> var1, Function<U, V> var2);

    public B factory(Supplier<?> var1, Supplier<Object[]> var2);

    public <U> B factory(Supplier<U> var1, Function<U, ?> var2, Function<U, Object[]> var3);

    public B provides(Class<?> var1);

    public B provides(Class<?> var1, String var2, Object var3, Object ... var4);

    public B provides(Class<?> var1, FluentProperty ... var2);

    public B provides(Class<?> var1, Dictionary<?, ?> var2);

    public B provides(Class<?>[] var1);

    public B provides(Class<?>[] var1, String var2, Object var3, Object ... var4);

    public B provides(Class<?>[] var1, FluentProperty ... var2);

    public B provides(Class<?>[] var1, Dictionary<?, ?> var2);

    public B provides(String var1);

    public B provides(String var1, String var2, Object var3, Object ... var4);

    public B provides(String var1, FluentProperty ... var2);

    public B provides(String var1, Dictionary<?, ?> var2);

    public B provides(String[] var1);

    public B provides(String[] var1, String var2, Object var3, Object ... var4);

    public B provides(String[] var1, FluentProperty ... var2);

    public B provides(String[] var1, Dictionary<?, ?> var2);

    public B properties(Dictionary<?, ?> var1);

    public B properties(String var1, Object var2, Object ... var3);

    public B properties(FluentProperty ... var1);

    public <U> B withSvc(Class<U> var1, Consumer<ServiceDependencyBuilder<U>> var2);

    default public B withSvc(Class<?> ... services) {
        Stream.of(services).forEach(s -> {
            B b = this.withSvc((Class)s, (ServiceDependencyBuilder<U> svc) -> {
                ServiceDependencyBuilder serviceDependencyBuilder = svc.autoConfig();
            });
        });
        return (B)this;
    }

    default public B withSvc(boolean required, Class<?> ... services) {
        Stream.of(services).forEach(s -> {
            B b = this.withSvc((Class)s, (ServiceDependencyBuilder<U> svc) -> {
                ServiceDependencyBuilder serviceDependencyBuilder = svc.required(required);
            });
        });
        return (B)this;
    }

    default public B withSvc(Class<?> service, boolean required) {
        this.withSvc(service, (ServiceDependencyBuilder<U> svc) -> {
            ServiceDependencyBuilder serviceDependencyBuilder = svc.required(required);
        });
        return (B)this;
    }

    default public <T> B withSvc(Class<T> service, String filter, boolean required) {
        return this.withSvc(service, (ServiceDependencyBuilder<U> svc) -> {
            ServiceDependencyBuilder serviceDependencyBuilder = svc.filter(filter).required(required);
        });
    }

    default public <T> B withSvc(Class<T> service, String filter, String field, boolean required) {
        return this.withSvc(service, (ServiceDependencyBuilder<U> svc) -> {
            ServiceDependencyBuilder serviceDependencyBuilder = svc.filter(filter).autoConfig(field).required(required);
        });
    }

    public B withCnf(Consumer<ConfigurationDependencyBuilder> var1);

    default public B withCnf(String ... pids) {
        Stream.of(pids).forEach(pid -> {
            B b = this.withCnf((ConfigurationDependencyBuilder cnf) -> {
                ConfigurationDependencyBuilder configurationDependencyBuilder = cnf.pid((String)pid);
            });
        });
        return (B)this;
    }

    default public B withCnf(Class<?> configType) {
        return this.withCnf((ConfigurationDependencyBuilder cnf) -> {
            ConfigurationDependencyBuilder configurationDependencyBuilder = cnf.update(configType, "updated");
        });
    }

    public B withBundle(Consumer<BundleDependencyBuilder> var1);

    public <U> B withFuture(CompletableFuture<U> var1, Consumer<FutureDependencyBuilder<U>> var2);

    public B init(String var1);

    public B init(Object var1, String var2);

    public B init(InstanceCb var1);

    public B init(InstanceCbComponent var1);

    public B start(String var1);

    public B start(Object var1, String var2);

    public B start(InstanceCb var1);

    public B start(InstanceCbComponent var1);

    public B stop(String var1);

    public B stop(Object var1, String var2);

    public B stop(InstanceCb var1);

    public B stop(InstanceCbComponent var1);

    public B destroy(String var1);

    public B destroy(Object var1, String var2);

    public B destroy(InstanceCb var1);

    public B destroy(InstanceCbComponent var1);

    public B autoConfig(Class<?> var1, boolean var2);

    public B autoConfig(Class<?> var1, String var2);

    public B debug(String var1);

    public B autoAdd(boolean var1);

    public B composition(String var1);

    public B composition(Object var1, String var2);

    public B composition(Supplier<Object[]> var1);

    public Component build();
}

