/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.lambda.BundleAdapterBuilder;
import org.apache.felix.dm.lambda.BundleDependencyBuilder;
import org.apache.felix.dm.lambda.ComponentBuilder;
import org.apache.felix.dm.lambda.ConfigurationDependencyBuilder;
import org.apache.felix.dm.lambda.FactoryPidAdapterBuilder;
import org.apache.felix.dm.lambda.FutureDependencyBuilder;
import org.apache.felix.dm.lambda.ServiceAdapterBuilder;
import org.apache.felix.dm.lambda.ServiceAspectBuilder;
import org.apache.felix.dm.lambda.ServiceDependencyBuilder;
import org.apache.felix.dm.lambda.impl.BundleAdapterBuilderImpl;
import org.apache.felix.dm.lambda.impl.BundleDependencyBuilderImpl;
import org.apache.felix.dm.lambda.impl.CompletableFutureDependencyImpl;
import org.apache.felix.dm.lambda.impl.ComponentBuilderImpl;
import org.apache.felix.dm.lambda.impl.ConfigurationDependencyBuilderImpl;
import org.apache.felix.dm.lambda.impl.FactoryPidAdapterBuilderImpl;
import org.apache.felix.dm.lambda.impl.ServiceAdapterBuilderImpl;
import org.apache.felix.dm.lambda.impl.ServiceAspectBuilderImpl;
import org.apache.felix.dm.lambda.impl.ServiceDependencyBuilderImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public abstract class DependencyManagerActivator
implements BundleActivator {
    private DependencyManager m_manager;

    public void start(BundleContext context) throws Exception {
        this.m_manager = new DependencyManager(context);
        this.init(context, this.m_manager);
    }

    public void stop(BundleContext context) throws Exception {
        this.destroy();
    }

    protected abstract void init(BundleContext var1, DependencyManager var2) throws Exception;

    protected void destroy() throws Exception {
    }

    public DependencyManager getDM() {
        return this.m_manager;
    }

    public BundleContext getBC() {
        return this.m_manager.getBundleContext();
    }

    protected ComponentBuilder<?> component() {
        return new ComponentBuilderImpl(this.m_manager);
    }

    protected <T> ServiceAspectBuilder<T> aspect(Class<T> aspectType) {
        ServiceAspectBuilderImpl<T> aspectBuilder = new ServiceAspectBuilderImpl<T>(this.m_manager, aspectType);
        return aspectBuilder;
    }

    protected <T> ServiceAdapterBuilder<T> adapter(Class<T> adaptee) {
        ServiceAdapterBuilderImpl<T> adapterBuilder = new ServiceAdapterBuilderImpl<T>(this.m_manager, adaptee);
        return adapterBuilder;
    }

    protected Component component(Consumer<ComponentBuilder<?>> consumer) {
        return DependencyManagerActivator.component(this.m_manager, consumer);
    }

    protected <T> Component aspect(Class<T> aspect, Consumer<ServiceAspectBuilder<T>> consumer) {
        return DependencyManagerActivator.aspect(this.m_manager, aspect, consumer);
    }

    protected <T> Component adapter(Class<T> adaptee, Consumer<ServiceAdapterBuilder<T>> consumer) {
        return DependencyManagerActivator.adapter(this.m_manager, adaptee, consumer);
    }

    protected Component factoryPidAdapter(Consumer<FactoryPidAdapterBuilder> consumer) {
        return DependencyManagerActivator.factoryPidAdapter(this.m_manager, consumer);
    }

    protected Component bundleAdapter(Consumer<BundleAdapterBuilder> consumer) {
        return DependencyManagerActivator.bundleAdapter(this.m_manager, consumer);
    }

    public static ComponentBuilder<?> component(DependencyManager dm) {
        return new ComponentBuilderImpl(dm);
    }

    public static <T> ServiceAspectBuilder<T> aspect(DependencyManager dm, Class<T> aspect) {
        ServiceAspectBuilderImpl<T> aspectBuilder = new ServiceAspectBuilderImpl<T>(dm, aspect);
        return aspectBuilder;
    }

    public static <T> ServiceAdapterBuilder<T> adapter(DependencyManager dm, Class<T> adaptee) {
        ServiceAdapterBuilderImpl<T> adapterBuilder = new ServiceAdapterBuilderImpl<T>(dm, adaptee);
        return adapterBuilder;
    }

    public static FactoryPidAdapterBuilder factoryPidAdapter(DependencyManager dm) {
        return new FactoryPidAdapterBuilderImpl(dm);
    }

    public static BundleAdapterBuilder bundleAdapter(DependencyManager dm) {
        return new BundleAdapterBuilderImpl(dm);
    }

    public static <T> ServiceDependencyBuilder<T> serviceDependency(Component component, Class<T> service) {
        return new ServiceDependencyBuilderImpl<T>(component, service);
    }

    public static ConfigurationDependencyBuilder confDependency(Component component) {
        return new ConfigurationDependencyBuilderImpl(component);
    }

    public static BundleDependencyBuilder bundleDependency(Component component) {
        return new BundleDependencyBuilderImpl(component);
    }

    public static <F> FutureDependencyBuilder<F> futureDependency(Component component, CompletableFuture<F> future) {
        return new CompletableFutureDependencyImpl<F>(component, future);
    }

    public static Component component(DependencyManager dm, Consumer<ComponentBuilder<?>> consumer) {
        ComponentBuilderImpl componentBuilder = new ComponentBuilderImpl(dm);
        consumer.accept(componentBuilder);
        Component comp = componentBuilder.build();
        if (componentBuilder.isAutoAdd()) {
            dm.add(comp);
        }
        return comp;
    }

    public static void component(Component comp, Consumer<ComponentBuilder<?>> consumer) {
        ComponentBuilderImpl componentBuilder = new ComponentBuilderImpl(comp, true);
        consumer.accept(componentBuilder);
        componentBuilder.build();
    }

    public static <T> Component aspect(DependencyManager dm, Class<T> aspect, Consumer<ServiceAspectBuilder<T>> consumer) {
        ServiceAspectBuilderImpl<T> aspectBuilder = new ServiceAspectBuilderImpl<T>(dm, aspect);
        consumer.accept(aspectBuilder);
        Component comp = aspectBuilder.build();
        if (aspectBuilder.isAutoAdd()) {
            dm.add(comp);
        }
        return comp;
    }

    public static <T> Component adapter(DependencyManager dm, Class<T> adaptee, Consumer<ServiceAdapterBuilder<T>> consumer) {
        ServiceAdapterBuilderImpl<T> adapterBuilder = new ServiceAdapterBuilderImpl<T>(dm, adaptee);
        consumer.accept(adapterBuilder);
        Component comp = adapterBuilder.build();
        if (adapterBuilder.isAutoAdd()) {
            dm.add(comp);
        }
        return comp;
    }

    public static Component bundleAdapter(DependencyManager dm, Consumer<BundleAdapterBuilder> consumer) {
        BundleAdapterBuilderImpl adapterBuilder = new BundleAdapterBuilderImpl(dm);
        consumer.accept(adapterBuilder);
        Component comp = adapterBuilder.build();
        if (adapterBuilder.isAutoAdd()) {
            dm.add(comp);
        }
        return comp;
    }

    public static Component factoryPidAdapter(DependencyManager dm, Consumer<FactoryPidAdapterBuilder> consumer) {
        FactoryPidAdapterBuilderImpl factoryPidAdapter = new FactoryPidAdapterBuilderImpl(dm);
        consumer.accept(factoryPidAdapter);
        Component comp = factoryPidAdapter.build();
        if (factoryPidAdapter.isAutoAdd()) {
            dm.add(comp);
        }
        return comp;
    }
}

