/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.lambda.BundleAdapterBuilder;
import org.apache.felix.dm.lambda.ComponentBuilder;
import org.apache.felix.dm.lambda.callbacks.CbBundle;
import org.apache.felix.dm.lambda.callbacks.CbBundleComponent;
import org.apache.felix.dm.lambda.callbacks.InstanceCbBundle;
import org.apache.felix.dm.lambda.callbacks.InstanceCbBundleComponent;
import org.apache.felix.dm.lambda.impl.AdapterBase;
import org.apache.felix.dm.lambda.impl.ComponentBuilderImpl;
import org.apache.felix.dm.lambda.impl.Helpers;
import org.osgi.framework.Bundle;

public class BundleAdapterBuilderImpl
implements AdapterBase<BundleAdapterBuilder>,
BundleAdapterBuilder {
    private Consumer<ComponentBuilder<?>> m_compBuilder = compBuilder -> {};
    protected final Map<Cb, List<MethodRef<Object>>> m_refs = new HashMap<Cb, List<MethodRef<Object>>>();
    private DependencyManager m_dm;
    private boolean m_autoAdd;
    private String m_added;
    private String m_changed;
    private String m_removed;
    private String m_filter;
    private int m_stateMask = -1;
    private boolean m_propagate;
    private Object m_callbackInstance;
    private String m_add;
    private String m_change;
    private String m_remove;

    public BundleAdapterBuilderImpl(DependencyManager dm) {
        this.m_dm = dm;
    }

    @Override
    public void andThenBuild(Consumer<ComponentBuilder<?>> builder) {
        this.m_compBuilder = this.m_compBuilder.andThen(builder);
    }

    @Override
    public BundleAdapterBuilderImpl autoAdd(boolean autoAdd) {
        this.m_autoAdd = autoAdd;
        return this;
    }

    public boolean isAutoAdd() {
        return this.m_autoAdd;
    }

    @Override
    public BundleAdapterBuilder mask(int mask) {
        this.m_stateMask = mask;
        return this;
    }

    @Override
    public BundleAdapterBuilder filter(String filter) {
        this.m_filter = filter;
        return this;
    }

    @Override
    public BundleAdapterBuilder propagate(boolean propagate) {
        this.m_propagate = propagate;
        return this;
    }

    @Override
    public BundleAdapterBuilder propagate() {
        this.m_propagate = true;
        return this;
    }

    @Override
    public BundleAdapterBuilder add(String callback) {
        return this.callbacks(callback, null, null);
    }

    @Override
    public BundleAdapterBuilder change(String callback) {
        return this.callbacks(null, callback, null);
    }

    @Override
    public BundleAdapterBuilder remove(String callback) {
        return this.callbacks(null, null, callback);
    }

    @Override
    public BundleAdapterBuilder callbackInstance(Object callbackInstance) {
        this.m_callbackInstance = callbackInstance;
        return this;
    }

    private BundleAdapterBuilder callbacks(String add, String change, String remove) {
        this.checkHasNoMethodRefs();
        this.m_add = add != null ? add : this.m_add;
        this.m_change = change != null ? change : this.m_change;
        this.m_remove = remove != null ? remove : this.m_remove;
        return this;
    }

    @Override
    public <T> BundleAdapterBuilder add(CbBundle<T> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public <T> BundleAdapterBuilder change(CbBundle<T> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public <T> BundleAdapterBuilder remove(CbBundle<T> remove) {
        return this.callbacks(null, null, remove);
    }

    private <T> BundleAdapterBuilder callbacks(CbBundle<T> add, CbBundle<T> change, CbBundle<T> remove) {
        Class type;
        if (add != null) {
            type = Helpers.getLambdaArgType(add, 0);
            this.setComponentCallbackRef(Cb.ADD, type, (instance, component, bundle) -> add.accept(instance, bundle));
        }
        if (change != null) {
            type = Helpers.getLambdaArgType(change, 0);
            this.setComponentCallbackRef(Cb.CHG, type, (instance, component, bundle) -> change.accept(instance, bundle));
        }
        if (remove != null) {
            type = Helpers.getLambdaArgType(remove, 0);
            this.setComponentCallbackRef(Cb.REM, type, (instance, component, bundle) -> remove.accept(instance, bundle));
        }
        return this;
    }

    @Override
    public BundleAdapterBuilder add(InstanceCbBundle add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public BundleAdapterBuilder change(InstanceCbBundle change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public BundleAdapterBuilder remove(InstanceCbBundle remove) {
        return this.callbacks(null, null, remove);
    }

    public BundleAdapterBuilder callbacks(InstanceCbBundle add, InstanceCbBundle change, InstanceCbBundle remove) {
        if (add != null) {
            this.setInstanceCallbackRef(Cb.ADD, (instance, component, bundle) -> add.accept(bundle));
        }
        if (change != null) {
            this.setInstanceCallbackRef(Cb.CHG, (instance, component, bundle) -> change.accept(bundle));
        }
        if (remove != null) {
            this.setInstanceCallbackRef(Cb.REM, (instance, component, bundle) -> remove.accept(bundle));
        }
        return this;
    }

    @Override
    public <T> BundleAdapterBuilder add(CbBundleComponent<T> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public <T> BundleAdapterBuilder change(CbBundleComponent<T> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public <T> BundleAdapterBuilder remove(CbBundleComponent<T> remove) {
        return this.callbacks(null, null, remove);
    }

    public <T> BundleAdapterBuilder callbacks(CbBundleComponent<T> add, CbBundleComponent<T> change, CbBundleComponent<T> remove) {
        if (add != null) {
            Class type = Helpers.getLambdaArgType(add, 0);
            return this.setComponentCallbackRef(Cb.ADD, type, (instance, component, bundle) -> add.accept(instance, bundle, component));
        }
        if (change != null) {
            Class type = Helpers.getLambdaArgType(change, 0);
            return this.setComponentCallbackRef(Cb.CHG, type, (instance, component, bundle) -> change.accept(instance, bundle, component));
        }
        if (remove != null) {
            Class type = Helpers.getLambdaArgType(remove, 0);
            return this.setComponentCallbackRef(Cb.ADD, type, (instance, component, bundle) -> remove.accept(instance, bundle, component));
        }
        return this;
    }

    @Override
    public BundleAdapterBuilder add(InstanceCbBundleComponent add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public BundleAdapterBuilder change(InstanceCbBundleComponent change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public BundleAdapterBuilder remove(InstanceCbBundleComponent remove) {
        return this.callbacks(null, null, remove);
    }

    public BundleAdapterBuilder callbacks(InstanceCbBundleComponent add, InstanceCbBundleComponent change, InstanceCbBundleComponent remove) {
        if (add != null) {
            this.setInstanceCallbackRef(Cb.ADD, (instance, component, bundle) -> add.accept(bundle, component));
        }
        if (change != null) {
            this.setInstanceCallbackRef(Cb.CHG, (instance, component, bundle) -> change.accept(bundle, component));
        }
        if (remove != null) {
            this.setInstanceCallbackRef(Cb.REM, (instance, component, bundle) -> remove.accept(bundle, component));
        }
        return this;
    }

    @Override
    public Component build() {
        Component c = null;
        if (this.m_refs.size() > 0) {
            Object wrapCallback = new Object(){

                public void add(Component comp, Bundle bundle) {
                    BundleAdapterBuilderImpl.this.invokeMethodRefs(Cb.ADD, comp, bundle);
                }

                public void change(Component comp, Bundle bundle) {
                    BundleAdapterBuilderImpl.this.invokeMethodRefs(Cb.CHG, comp, bundle);
                }

                public void remove(Component comp, Bundle bundle) {
                    BundleAdapterBuilderImpl.this.invokeMethodRefs(Cb.REM, comp, bundle);
                }
            };
            c = this.m_dm.createBundleAdapterService(this.m_stateMask, this.m_filter, this.m_propagate, wrapCallback, "add", "change", "remove");
        } else {
            c = this.m_dm.createBundleAdapterService(this.m_stateMask, this.m_filter, this.m_propagate, this.m_callbackInstance, this.m_add, this.m_change, this.m_remove);
        }
        ComponentBuilderImpl cb = new ComponentBuilderImpl(c, false);
        this.m_compBuilder.accept(cb);
        return cb.build();
    }

    private <U> BundleAdapterBuilder setInstanceCallbackRef(Cb cbType, MethodRef<U> ref) {
        this.checkHasNoReflectionCallbacks();
        List list = this.m_refs.computeIfAbsent(cbType, l -> new ArrayList());
        list.add((instance, component, bundle) -> ref.accept(null, component, bundle));
        return this;
    }

    private <U> BundleAdapterBuilder setComponentCallbackRef(Cb cbType, Class<U> type, MethodRef<U> ref) {
        this.checkHasNoReflectionCallbacks();
        List list = this.m_refs.computeIfAbsent(cbType, l -> new ArrayList());
        list.add((instance, component, bundle) -> {
            Object componentImpl = Stream.of(component.getInstances()).filter((? super T impl) -> Helpers.getClass(impl).equals(type)).findFirst().orElseThrow(() -> new IllegalStateException("The method reference " + ref + " does not match any available component impl classes."));
            ref.accept(componentImpl, component, bundle);
        });
        return this;
    }

    private void invokeMethodRefs(Cb cbType, Component comp, Bundle bundle) {
        this.m_refs.computeIfPresent(cbType, (k, mrefs) -> {
            mrefs.forEach(mref -> mref.accept(null, comp, bundle));
            return mrefs;
        });
    }

    private void checkHasNoMethodRefs() {
        if (this.m_refs.size() > 0) {
            throw new IllegalStateException("Can't mix method references with reflection based callbacks");
        }
    }

    private void checkHasNoReflectionCallbacks() {
        if (this.m_added != null || this.m_changed != null || this.m_removed != null) {
            throw new IllegalStateException("Can't mix method references with reflection based callbacks");
        }
    }

    static enum Cb {
        ADD,
        CHG,
        REM;

    }

    @FunctionalInterface
    static interface MethodRef<I> {
        public void accept(I var1, Component var2, Bundle var3);
    }
}

