/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.felix.dm.BundleDependency;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.lambda.BundleDependencyBuilder;
import org.apache.felix.dm.lambda.callbacks.CbBundle;
import org.apache.felix.dm.lambda.callbacks.CbBundleComponent;
import org.apache.felix.dm.lambda.callbacks.InstanceCbBundle;
import org.apache.felix.dm.lambda.callbacks.InstanceCbBundleComponent;
import org.apache.felix.dm.lambda.impl.Helpers;
import org.osgi.framework.Bundle;

public class BundleDependencyBuilderImpl
implements BundleDependencyBuilder {
    private String m_added;
    private String m_changed;
    private String m_removed;
    private Object m_instance;
    private boolean m_autoConfig = true;
    private boolean m_autoConfigInvoked = false;
    private boolean m_required;
    private Bundle m_bundle;
    private String m_filter;
    private int m_stateMask = -1;
    private boolean m_propagate;
    private Object m_propagateInstance;
    private String m_propagateMethod;
    private Function<Bundle, Dictionary<?, ?>> m_propagateCallback;
    private final Component m_component;
    private boolean m_requiredSet;
    private final Map<Cb, List<MethodRef<Object>>> m_refs = new HashMap<Cb, List<MethodRef<Object>>>();

    public BundleDependencyBuilderImpl(Component component) {
        this.m_component = component;
    }

    @Override
    public BundleDependencyBuilder autoConfig(boolean autoConfig) {
        this.m_autoConfig = autoConfig;
        this.m_autoConfigInvoked = true;
        return this;
    }

    @Override
    public BundleDependencyBuilder autoConfig() {
        this.autoConfig(true);
        return this;
    }

    @Override
    public BundleDependencyBuilder required(boolean required) {
        this.m_required = required;
        this.m_requiredSet = true;
        return this;
    }

    @Override
    public BundleDependencyBuilder optional() {
        return this.required(false);
    }

    @Override
    public BundleDependencyBuilder required() {
        this.required(true);
        return this;
    }

    @Override
    public BundleDependencyBuilder bundle(Bundle bundle) {
        this.m_bundle = bundle;
        return this;
    }

    @Override
    public BundleDependencyBuilder filter(String filter) throws IllegalArgumentException {
        this.m_filter = filter;
        return this;
    }

    @Override
    public BundleDependencyBuilder mask(int mask) {
        this.m_stateMask = mask;
        return this;
    }

    @Override
    public BundleDependencyBuilder propagate(boolean propagate) {
        this.m_propagate = propagate;
        return this;
    }

    @Override
    public BundleDependencyBuilder propagate() {
        this.propagate(true);
        return this;
    }

    @Override
    public BundleDependencyBuilder propagate(Object instance, String method) {
        if (this.m_propagateCallback != null || this.m_propagate) {
            throw new IllegalStateException("Propagate callback already set.");
        }
        Objects.nonNull(method);
        Objects.nonNull(instance);
        this.m_propagateInstance = instance;
        this.m_propagateMethod = method;
        return this;
    }

    @Override
    public BundleDependencyBuilder propagate(Function<Bundle, Dictionary<?, ?>> instance) {
        if (this.m_propagateInstance != null || this.m_propagate) {
            throw new IllegalStateException("Propagate callback already set.");
        }
        this.m_propagateCallback = instance;
        return this;
    }

    @Override
    public BundleDependencyBuilder callbackInstance(Object callbackInstance) {
        this.m_instance = callbackInstance;
        return this;
    }

    @Override
    public BundleDependencyBuilder add(String add) {
        this.callbacks(add, null, null);
        return this;
    }

    @Override
    public BundleDependencyBuilder change(String change) {
        this.callbacks(null, change, null);
        return this;
    }

    @Override
    public BundleDependencyBuilder remove(String remove) {
        this.callbacks(null, null, remove);
        return this;
    }

    private BundleDependencyBuilder callbacks(String added, String changed, String removed) {
        this.requiresNoMethodRefs();
        this.m_added = added != null ? added : this.m_added;
        this.m_changed = changed != null ? changed : this.m_changed;
        String string = this.m_removed = removed != null ? removed : this.m_removed;
        if (!this.m_autoConfigInvoked) {
            this.m_autoConfig = false;
        }
        return this;
    }

    @Override
    public <T> BundleDependencyBuilder add(CbBundle<T> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public <T> BundleDependencyBuilder change(CbBundle<T> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public <T> BundleDependencyBuilder remove(CbBundle<T> remove) {
        return this.callbacks(null, null, remove);
    }

    private <T> BundleDependencyBuilder callbacks(CbBundle<T> add, CbBundle<T> change, CbBundle<T> remove) {
        if (add != null) {
            this.setComponentCallbackRef(Cb.ADD, Helpers.getLambdaArgType(add, 0), (inst, component, bundle) -> add.accept(inst, bundle));
        }
        if (change != null) {
            this.setComponentCallbackRef(Cb.CHG, Helpers.getLambdaArgType(change, 0), (inst, component, bundle) -> change.accept(inst, bundle));
        }
        if (remove != null) {
            this.setComponentCallbackRef(Cb.REM, Helpers.getLambdaArgType(remove, 0), (inst, component, bundle) -> remove.accept(inst, bundle));
        }
        return this;
    }

    @Override
    public <T> BundleDependencyBuilder add(CbBundleComponent<T> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public <T> BundleDependencyBuilder change(CbBundleComponent<T> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public <T> BundleDependencyBuilder remove(CbBundleComponent<T> remove) {
        return this.callbacks(null, null, remove);
    }

    private <T> BundleDependencyBuilder callbacks(CbBundleComponent<T> add, CbBundleComponent<T> change, CbBundleComponent<T> remove) {
        if (add != null) {
            this.setComponentCallbackRef(Cb.ADD, Helpers.getLambdaArgType(add, 0), (inst, component, bundle) -> add.accept(inst, bundle, component));
        }
        if (change != null) {
            this.setComponentCallbackRef(Cb.CHG, Helpers.getLambdaArgType(change, 0), (inst, component, bundle) -> change.accept(inst, bundle, component));
        }
        if (remove != null) {
            this.setComponentCallbackRef(Cb.REM, Helpers.getLambdaArgType(remove, 0), (inst, component, bundle) -> remove.accept(inst, bundle, component));
        }
        return this;
    }

    @Override
    public BundleDependencyBuilder add(InstanceCbBundle add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public BundleDependencyBuilder change(InstanceCbBundle change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public BundleDependencyBuilder remove(InstanceCbBundle remove) {
        return this.callbacks(null, null, remove);
    }

    private BundleDependencyBuilder callbacks(InstanceCbBundle add, InstanceCbBundle change, InstanceCbBundle remove) {
        if (add != null) {
            this.setInstanceCallbackRef(Cb.ADD, (inst, component, bundle) -> add.accept(bundle));
        }
        if (change != null) {
            this.setInstanceCallbackRef(Cb.CHG, (inst, component, bundle) -> change.accept(bundle));
        }
        if (remove != null) {
            this.setInstanceCallbackRef(Cb.REM, (inst, component, bundle) -> remove.accept(bundle));
        }
        return this;
    }

    @Override
    public BundleDependencyBuilder add(InstanceCbBundleComponent add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public BundleDependencyBuilder change(InstanceCbBundleComponent add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public BundleDependencyBuilder remove(InstanceCbBundleComponent remove) {
        return this.callbacks(null, null, remove);
    }

    private BundleDependencyBuilder callbacks(InstanceCbBundleComponent add, InstanceCbBundleComponent change, InstanceCbBundleComponent remove) {
        if (add != null) {
            this.setInstanceCallbackRef(Cb.ADD, (inst, component, bundle) -> add.accept(bundle, component));
        }
        if (change != null) {
            this.setInstanceCallbackRef(Cb.CHG, (inst, component, bundle) -> change.accept(bundle, component));
        }
        if (remove != null) {
            this.setInstanceCallbackRef(Cb.REM, (inst, component, bundle) -> remove.accept(bundle, component));
        }
        return this;
    }

    @Override
    public BundleDependency build() {
        DependencyManager dm = this.m_component.getDependencyManager();
        BundleDependency dep = dm.createBundleDependency();
        if (!this.m_requiredSet) {
            this.m_required = Helpers.isDependencyRequiredByDefault(this.m_component);
        }
        dep.setRequired(this.m_required);
        if (this.m_filter != null) {
            dep.setFilter(this.m_filter);
        }
        if (this.m_bundle != null) {
            dep.setBundle(this.m_bundle);
        }
        if (this.m_stateMask != -1) {
            dep.setStateMask(this.m_stateMask);
        }
        if (this.m_propagate) {
            dep.setPropagate(true);
        } else if (this.m_propagateInstance != null) {
            dep.setPropagate(this.m_propagateInstance, this.m_propagateMethod);
        } else if (this.m_propagateCallback != null) {
            dep.setPropagate((Object)new Propagate(), "propagate");
        }
        if (this.m_added != null || this.m_changed != null || this.m_removed != null) {
            dep.setCallbacks(this.m_instance, this.m_added, this.m_changed, this.m_removed);
        } else if (this.m_refs.size() > 0) {
            Object cb = this.createCallbackInstance();
            dep.setCallbacks(cb, "add", "change", "remove");
        }
        dep.setAutoConfig(this.m_autoConfig);
        return dep;
    }

    private <T> BundleDependencyBuilder setInstanceCallbackRef(Cb cbType, MethodRef<T> ref) {
        this.requiresNoStringCallbacks();
        if (!this.m_autoConfigInvoked) {
            this.m_autoConfig = false;
        }
        List list = this.m_refs.computeIfAbsent(cbType, l -> new ArrayList());
        list.add((instance, component, bundle) -> ref.accept(null, component, bundle));
        return this;
    }

    private <T> BundleDependencyBuilder setComponentCallbackRef(Cb cbType, Class<T> type, MethodRef<T> ref) {
        this.requiresNoStringCallbacks();
        if (!this.m_autoConfigInvoked) {
            this.m_autoConfig = false;
        }
        List list = this.m_refs.computeIfAbsent(cbType, l -> new ArrayList());
        list.add((instance, component, bundle) -> {
            Object componentImpl = Stream.of(component.getInstances()).filter((? super T impl) -> Helpers.getClass(impl).equals(type)).findFirst().orElseThrow(() -> new IllegalStateException("The method reference " + ref + " does not match any available component impl classes."));
            ref.accept(componentImpl, component, bundle);
        });
        return this;
    }

    private Object createCallbackInstance() {
        Object cb = null;
        cb = new Object(){

            void add(Component c, Bundle bundle) {
                BundleDependencyBuilderImpl.this.invokeMethodRefs(Cb.ADD, c, bundle);
            }

            void change(Component c, Bundle bundle) {
                BundleDependencyBuilderImpl.this.invokeMethodRefs(Cb.CHG, c, bundle);
            }

            void remove(Component c, Bundle bundle) {
                BundleDependencyBuilderImpl.this.invokeMethodRefs(Cb.REM, c, bundle);
            }
        };
        return cb;
    }

    private void invokeMethodRefs(Cb cbType, Component c, Bundle bundle) {
        this.m_refs.computeIfPresent(cbType, (k, mrefs) -> {
            mrefs.forEach(mref -> mref.accept(null, c, bundle));
            return mrefs;
        });
    }

    private void requiresNoStringCallbacks() {
        if (this.m_added != null || this.m_changed != null || this.m_removed != null) {
            throw new IllegalStateException("can't mix method references and string callbacks.");
        }
    }

    private void requiresNoMethodRefs() {
        if (this.m_refs.size() > 0) {
            throw new IllegalStateException("can't mix method references and string callbacks.");
        }
    }

    static enum Cb {
        ADD,
        CHG,
        REM;

    }

    @FunctionalInterface
    static interface MethodRef<I> {
        public void accept(I var1, Component var2, Bundle var3);
    }

    private class Propagate {
        private Propagate() {
        }

        Dictionary<?, ?> propagate(Bundle bundle) {
            return (Dictionary)BundleDependencyBuilderImpl.this.m_propagateCallback.apply(bundle);
        }
    }
}

