/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda.impl;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.context.AbstractDependency;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.context.Event;
import org.apache.felix.dm.context.EventType;
import org.apache.felix.dm.lambda.FutureDependencyBuilder;
import org.apache.felix.dm.lambda.callbacks.CbFuture;
import org.apache.felix.dm.lambda.callbacks.InstanceCbFuture;
import org.apache.felix.dm.lambda.impl.Helpers;

public class CompletableFutureDependencyImpl<F>
extends AbstractDependency<CompletableFutureDependencyImpl<F>>
implements FutureDependencyBuilder<F> {
    private final CompletableFuture<F> m_future;
    private Component m_comp;
    private boolean m_async;
    private Executor m_exec;
    private InstanceCbFuture<F> m_accept;
    private CbFuture<Object, F> m_accept2;
    private Class<?> m_accept2Type;

    public CompletableFutureDependencyImpl(Component c, CompletableFuture<F> future2) {
        this.m_accept = future -> {};
        super.setRequired(true);
        this.m_future = future2;
        this.m_comp = c;
    }

    public CompletableFutureDependencyImpl(Component component, CompletableFutureDependencyImpl<F> prototype) {
        super(prototype);
        this.m_accept = future -> {};
        this.m_future = prototype.m_future;
        this.m_comp = component;
    }

    @Override
    public Dependency build() {
        return this;
    }

    @Override
    public FutureDependencyBuilder<F> complete(String callback) {
        return this.complete(null, callback);
    }

    @Override
    public FutureDependencyBuilder<F> complete(Object callbackInstance, String callback) {
        super.setCallbacks(callbackInstance, callback, null);
        return this;
    }

    @Override
    public <T> FutureDependencyBuilder<F> complete(CbFuture<T, ? super F> consumer) {
        return this.complete(consumer, false);
    }

    @Override
    public <T> FutureDependencyBuilder<F> complete(CbFuture<T, ? super F> consumer, boolean async) {
        this.m_accept2Type = Helpers.getLambdaArgType(consumer, 0);
        this.m_accept2 = (instance, result) -> consumer.accept(instance, result);
        this.m_async = async;
        return this;
    }

    @Override
    public <T> FutureDependencyBuilder<F> complete(CbFuture<T, ? super F> consumer, Executor executor) {
        this.complete(consumer, true);
        this.m_exec = executor;
        return this;
    }

    @Override
    public FutureDependencyBuilder<F> complete(InstanceCbFuture<? super F> consumer) {
        this.complete(consumer, false);
        return this;
    }

    @Override
    public FutureDependencyBuilder<F> complete(InstanceCbFuture<? super F> consumer, boolean async) {
        this.m_accept = this.m_accept.andThen(future -> consumer.accept(future));
        this.m_async = async;
        return this;
    }

    @Override
    public FutureDependencyBuilder<F> complete(InstanceCbFuture<? super F> consumer, Executor executor) {
        this.complete(consumer, true);
        this.m_exec = executor;
        return this;
    }

    public void start() {
        try {
            if (this.m_async) {
                if (this.m_exec != null) {
                    this.m_future.whenCompleteAsync((result, error) -> this.completed((F)result, (Throwable)error), this.m_exec);
                } else {
                    this.m_future.whenCompleteAsync((result, error) -> this.completed((F)result, (Throwable)error));
                }
            } else {
                this.m_future.whenComplete((result, error) -> this.completed((F)result, (Throwable)error));
            }
        }
        catch (Throwable error2) {
            super.getComponentContext().getLogger().log(1, "completable future failed", error2);
        }
        super.start();
    }

    public DependencyContext createCopy() {
        return new CompletableFutureDependencyImpl<F>(this.m_comp, this);
    }

    public Class<?> getAutoConfigType() {
        return null;
    }

    public String getSimpleName() {
        return this.m_future.toString();
    }

    public String getType() {
        return "future";
    }

    public void invokeCallback(EventType type, Event ... events) {
        try {
            switch (type) {
                case ADDED: {
                    if (this.m_add != null) {
                        this.injectByReflection(events[0].getEvent());
                        return;
                    }
                    Object result = events[0].getEvent();
                    if (this.m_accept2 != null) {
                        if (this.m_accept2Type != null) {
                            Object componentInstance = Stream.of(this.getComponentContext().getInstances()).filter(instance -> Helpers.getClass(instance).equals(this.m_accept2Type)).findFirst().orElseThrow(() -> new IllegalArgumentException("accept callback is not on one of the component instances: " + this.m_accept2 + " (type=" + this.m_accept2Type + ")"));
                            this.m_accept2.accept(componentInstance, result);
                            break;
                        }
                        this.m_accept2.accept(this.getComponentContext().getInstance(), result);
                        break;
                    }
                    this.m_accept.accept(result);
                    break;
                }
            }
        }
        catch (Throwable exc) {
            super.getComponentContext().getLogger().log(1, "completable future failed", exc);
        }
    }

    private void completed(F result, Throwable error) {
        if (error != null) {
            super.getComponentContext().getLogger().log(1, "completable future failed", error);
        } else {
            this.m_component.handleEvent((DependencyContext)this, EventType.ADDED, new Event[]{new Event(result)});
        }
    }

    private void injectByReflection(Object result) {
        ArrayList types = new ArrayList();
        Class<?> currentClazz = result.getClass();
        while (currentClazz != null && currentClazz != Object.class) {
            types.add(currentClazz);
            Stream.of(currentClazz.getInterfaces()).forEach(types::add);
            currentClazz = currentClazz.getSuperclass();
        }
        Class[][] classes = new Class[types.size() + 1][1];
        Object[][] results = new Object[types.size() + 1][1];
        int i = 0;
        while (i < types.size()) {
            classes[i] = new Class[]{(Class)types.get(i)};
            results[i] = new Object[]{result};
            ++i;
        }
        classes[types.size()] = new Class[0];
        results[types.size()] = new Object[0];
        this.m_component.invokeCallbackMethod(this.getInstances(), this.m_add, classes, results);
    }
}

