/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.context.ComponentContext;
import org.apache.felix.dm.lambda.BundleDependencyBuilder;
import org.apache.felix.dm.lambda.ComponentBuilder;
import org.apache.felix.dm.lambda.ConfigurationDependencyBuilder;
import org.apache.felix.dm.lambda.DependencyBuilder;
import org.apache.felix.dm.lambda.FluentProperty;
import org.apache.felix.dm.lambda.FutureDependencyBuilder;
import org.apache.felix.dm.lambda.ServiceDependencyBuilder;
import org.apache.felix.dm.lambda.callbacks.InstanceCb;
import org.apache.felix.dm.lambda.callbacks.InstanceCbComponent;
import org.apache.felix.dm.lambda.impl.BundleDependencyBuilderImpl;
import org.apache.felix.dm.lambda.impl.CompletableFutureDependencyImpl;
import org.apache.felix.dm.lambda.impl.ConfigurationDependencyBuilderImpl;
import org.apache.felix.dm.lambda.impl.Helpers;
import org.apache.felix.dm.lambda.impl.ServiceDependencyBuilderImpl;

public class ComponentBuilderImpl
implements ComponentBuilder<ComponentBuilderImpl> {
    private final List<DependencyBuilder<?>> m_dependencyBuilders = new ArrayList();
    private final Component m_component;
    private final boolean m_componentUpdated;
    private String[] m_serviceNames;
    private Dictionary<Object, Object> m_properties;
    private Object m_impl;
    private Object m_factory;
    private boolean m_factoryHasComposite;
    private boolean m_autoAdd = true;
    protected final Map<ComponentCallback, MethodRef> m_refs = new HashMap<ComponentCallback, MethodRef>();
    private Object m_compositionInstance;
    private String m_compositionMethod;
    private String m_init;
    private String m_start;
    private String m_stop;
    private String m_destroy;
    private String m_factoryCreateMethod;
    private boolean m_hasFactoryRef;
    private boolean m_hasFactory;
    private Object m_initCallbackInstance;
    private Object m_startCallbackInstance;
    private Object m_stopCallbackInstance;
    private Object m_destroyCallbackInstance;

    public ComponentBuilderImpl(DependencyManager dm) {
        this.m_component = dm.createComponent();
        this.m_componentUpdated = false;
    }

    public ComponentBuilderImpl(Component component, boolean update) {
        this.m_component = component;
        this.m_componentUpdated = update;
    }

    @Override
    public ComponentBuilderImpl autoConfig(Class<?> clazz, boolean autoConfig) {
        this.m_component.setAutoConfig(clazz, autoConfig);
        return this;
    }

    @Override
    public ComponentBuilderImpl autoConfig(Class<?> clazz, String instanceName) {
        this.m_component.setAutoConfig(clazz, instanceName);
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(Class<?> iface) {
        this.m_serviceNames = new String[]{iface.getName()};
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(Class<?> iface, String name, Object value, Object ... rest) {
        this.provides((Class)iface);
        this.properties(name, value, rest);
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(Class<?> iface, FluentProperty ... properties) {
        this.provides((Class)iface);
        this.properties(properties);
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(Class<?> iface, Dictionary<?, ?> properties) {
        this.provides((Class)iface);
        this.properties((Dictionary)properties);
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(Class<?>[] ifaces) {
        this.m_serviceNames = (String[])Stream.of(ifaces).map(c -> c.getName()).toArray(String[]::new);
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(Class<?>[] ifaces, String name, Object value, Object ... rest) {
        this.provides((Class[])ifaces);
        this.properties(name, value, rest);
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(Class<?>[] ifaces, FluentProperty ... properties) {
        this.provides((Class[])ifaces);
        this.properties(properties);
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(Class<?>[] ifaces, Dictionary<?, ?> properties) {
        this.provides((Class[])ifaces);
        this.properties((Dictionary)properties);
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(String iface) {
        this.m_serviceNames = new String[]{iface};
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(String iface, String name, Object value, Object ... rest) {
        this.provides(iface);
        this.properties(name, value, rest);
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(String iface, FluentProperty ... properties) {
        this.provides(iface);
        this.properties(properties);
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(String iface, Dictionary<?, ?> properties) {
        this.provides(iface);
        this.properties((Dictionary)properties);
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(String[] ifaces) {
        this.m_serviceNames = ifaces;
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(String[] ifaces, String name, Object value, Object ... rest) {
        this.provides(ifaces);
        this.properties(name, value, rest);
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(String[] ifaces, FluentProperty ... properties) {
        this.provides(ifaces);
        this.properties(properties);
        return this;
    }

    @Override
    public ComponentBuilderImpl provides(String[] ifaces, Dictionary<?, ?> properties) {
        this.provides(ifaces);
        this.properties((Dictionary)properties);
        return this;
    }

    @Override
    public ComponentBuilderImpl properties(Dictionary<?, ?> properties) {
        this.m_properties = properties;
        return this;
    }

    @Override
    public ComponentBuilderImpl properties(String name, Object value, Object ... rest) {
        Objects.nonNull(name);
        Objects.nonNull(value);
        Properties props = new Properties();
        props.put(name, value);
        if ((rest.length & 1) != 0) {
            throw new IllegalArgumentException("Invalid number of specified properties (number of arguments must be even).");
        }
        int i = 0;
        while (i < rest.length - 1) {
            String k = rest[i].toString().trim();
            Object v = rest[i + 1];
            props.put(k, v);
            i += 2;
        }
        this.m_properties = props;
        return this;
    }

    @Override
    public ComponentBuilderImpl properties(FluentProperty ... properties) {
        Hashtable<Object, Object> props = new Hashtable<Object, Object>();
        Stream.of(properties).forEach(property -> {
            String name = Helpers.getLambdaParameterName(property, 0);
            if (name.equals("arg0")) {
                throw new IllegalArgumentException("arg0 property name not supported");
            }
            Object value = property.apply(name);
            props.put(name, value);
        });
        this.m_properties = props;
        return this;
    }

    @Override
    public ComponentBuilderImpl debug(String label) {
        this.m_component.setDebug(label);
        return this;
    }

    @Override
    public ComponentBuilderImpl autoAdd(boolean autoAdd) {
        this.m_autoAdd = autoAdd;
        return this;
    }

    public ComponentBuilderImpl autoAdd() {
        this.m_autoAdd = true;
        return this;
    }

    public boolean isAutoAdd() {
        return this.m_autoAdd;
    }

    @Override
    public ComponentBuilderImpl impl(Object instance) {
        this.m_impl = instance;
        return this;
    }

    @Override
    public ComponentBuilderImpl factory(Object factory, String createMethod) {
        this.m_factory = factory;
        this.m_factoryCreateMethod = createMethod;
        this.ensureHasNoFactoryRef();
        this.m_hasFactory = true;
        return this;
    }

    @Override
    public ComponentBuilderImpl factory(final Supplier<?> create) {
        Objects.nonNull(create);
        this.ensureHasNoFactory();
        this.m_hasFactoryRef = true;
        this.m_factory = new Object(){

            public Object create() {
                return create.get();
            }

            public String toString() {
                return String.valueOf(create.getClass().getName()) + " (Factory)";
            }
        };
        return this;
    }

    @Override
    public <U, V> ComponentBuilderImpl factory(final Supplier<U> supplier, final Function<U, V> create) {
        Objects.nonNull(supplier);
        Objects.nonNull(create);
        this.ensureHasNoFactory();
        this.m_hasFactoryRef = true;
        this.m_factory = new Object(){

            public Object create() {
                Object factoryImpl = supplier.get();
                return create.apply(factoryImpl);
            }

            public String toString() {
                return String.valueOf(supplier.getClass().getName()) + " (Factory)";
            }
        };
        return this;
    }

    @Override
    public ComponentBuilderImpl factory(final Supplier<?> create, final Supplier<Object[]> getComposite) {
        Objects.nonNull(create);
        Objects.nonNull(getComposite);
        this.ensureHasNoFactory();
        this.m_hasFactoryRef = true;
        this.m_factory = new Object(){

            public Object create() {
                return create.get();
            }

            public Object[] getComposite() {
                return (Object[])getComposite.get();
            }

            public String toString() {
                return String.valueOf(create.getClass().getName()) + " (Factory)";
            }
        };
        this.m_factoryHasComposite = true;
        return this;
    }

    @Override
    public <U> ComponentBuilderImpl factory(final Supplier<U> factorySupplier, final Function<U, ?> factoryCreate, final Function<U, Object[]> factoryGetComposite) {
        Objects.nonNull(factorySupplier);
        Objects.nonNull(factoryCreate);
        Objects.nonNull(factoryGetComposite);
        this.ensureHasNoFactory();
        this.m_hasFactoryRef = true;
        this.m_factory = new Object(){
            U m_factoryInstance;

            public Object create() {
                this.m_factoryInstance = factorySupplier.get();
                return factoryCreate.apply(this.m_factoryInstance);
            }

            public Object[] getComposite() {
                return (Object[])factoryGetComposite.apply(this.m_factoryInstance);
            }

            public String toString() {
                return String.valueOf(factorySupplier.getClass().getName()) + " (Factory)";
            }
        };
        this.m_factoryHasComposite = true;
        return this;
    }

    @Override
    public ComponentBuilderImpl composition(String getCompositionMethod) {
        return this.composition(null, getCompositionMethod);
    }

    @Override
    public ComponentBuilderImpl composition(Object instance, String getCompositionMethod) {
        this.m_compositionInstance = instance;
        this.m_compositionMethod = getCompositionMethod;
        return this;
    }

    @Override
    public ComponentBuilderImpl composition(final Supplier<Object[]> getCompositionMethod) {
        this.m_compositionInstance = new Object(){

            public Object[] getComposition() {
                return (Object[])getCompositionMethod.get();
            }
        };
        this.m_compositionMethod = "getComposition";
        return this;
    }

    @Override
    public <U> ComponentBuilderImpl withSvc(Class<U> service, Consumer<ServiceDependencyBuilder<U>> consumer) {
        ServiceDependencyBuilderImpl<U> dep = new ServiceDependencyBuilderImpl<U>(this.m_component, service);
        consumer.accept(dep);
        this.m_dependencyBuilders.add(dep);
        return this;
    }

    @Override
    public ComponentBuilderImpl withCnf(Consumer<ConfigurationDependencyBuilder> consumer) {
        ConfigurationDependencyBuilderImpl dep = new ConfigurationDependencyBuilderImpl(this.m_component);
        consumer.accept(dep);
        this.m_dependencyBuilders.add(dep);
        return this;
    }

    @Override
    public ComponentBuilderImpl withBundle(Consumer<BundleDependencyBuilder> consumer) {
        BundleDependencyBuilderImpl dep = new BundleDependencyBuilderImpl(this.m_component);
        consumer.accept(dep);
        this.m_dependencyBuilders.add(dep);
        return this;
    }

    @Override
    public <V> ComponentBuilderImpl withFuture(CompletableFuture<V> future, Consumer<FutureDependencyBuilder<V>> consumer) {
        CompletableFutureDependencyImpl<V> dep = new CompletableFutureDependencyImpl<V>(this.m_component, future);
        consumer.accept(dep);
        this.m_dependencyBuilders.add(dep);
        return this;
    }

    @Override
    public ComponentBuilderImpl init(String callback) {
        this.m_init = callback;
        return this;
    }

    @Override
    public ComponentBuilderImpl init(Object callbackInstance, String callback) {
        this.init(callback);
        this.m_initCallbackInstance = callbackInstance;
        return this;
    }

    @Override
    public ComponentBuilderImpl init(InstanceCb callback) {
        this.setCallbackMethodRef(ComponentCallback.INIT, component -> callback.callback());
        this.m_init = null;
        this.m_initCallbackInstance = null;
        return this;
    }

    @Override
    public ComponentBuilderImpl init(InstanceCbComponent callback) {
        this.setCallbackMethodRef(ComponentCallback.INIT, component -> callback.accept(component));
        this.m_init = null;
        this.m_initCallbackInstance = null;
        return this;
    }

    @Override
    public ComponentBuilderImpl start(String callback) {
        this.m_start = callback;
        return this;
    }

    @Override
    public ComponentBuilderImpl start(Object callbackInstance, String callback) {
        this.start(callback);
        this.m_startCallbackInstance = callbackInstance;
        return this;
    }

    @Override
    public ComponentBuilderImpl start(InstanceCb callback) {
        this.setCallbackMethodRef(ComponentCallback.START, component -> callback.callback());
        this.m_start = null;
        this.m_startCallbackInstance = null;
        return this;
    }

    @Override
    public ComponentBuilderImpl start(InstanceCbComponent callback) {
        this.setCallbackMethodRef(ComponentCallback.START, component -> callback.accept(component));
        this.m_start = null;
        this.m_startCallbackInstance = null;
        return this;
    }

    @Override
    public ComponentBuilderImpl stop(String callback) {
        this.m_stop = callback;
        return this;
    }

    @Override
    public ComponentBuilderImpl stop(Object callbackInstance, String callback) {
        this.stop(callback);
        this.m_stopCallbackInstance = callbackInstance;
        return this;
    }

    @Override
    public ComponentBuilderImpl stop(InstanceCb callback) {
        this.setCallbackMethodRef(ComponentCallback.STOP, component -> callback.callback());
        this.m_stop = null;
        this.m_stopCallbackInstance = null;
        return this;
    }

    @Override
    public ComponentBuilderImpl stop(InstanceCbComponent callback) {
        this.setCallbackMethodRef(ComponentCallback.STOP, component -> callback.accept(component));
        this.m_stop = null;
        this.m_stopCallbackInstance = null;
        return this;
    }

    @Override
    public ComponentBuilderImpl destroy(String callback) {
        this.m_destroy = callback;
        return this;
    }

    @Override
    public ComponentBuilderImpl destroy(Object callbackInstance, String callback) {
        this.destroy(callback);
        this.m_destroyCallbackInstance = callbackInstance;
        return this;
    }

    @Override
    public ComponentBuilderImpl destroy(InstanceCb callback) {
        this.setCallbackMethodRef(ComponentCallback.DESTROY, component -> callback.callback());
        this.m_destroy = null;
        this.m_destroyCallbackInstance = null;
        return this;
    }

    @Override
    public ComponentBuilderImpl destroy(InstanceCbComponent callback) {
        this.setCallbackMethodRef(ComponentCallback.DESTROY, component -> callback.accept(component));
        this.m_destroy = null;
        this.m_destroyCallbackInstance = null;
        return this;
    }

    @Override
    public Component build() {
        if (this.m_serviceNames != null) {
            this.m_component.setInterface(this.m_serviceNames, this.m_properties);
        }
        if (this.m_properties != null) {
            this.m_component.setServiceProperties(this.m_properties);
        }
        if (!this.m_componentUpdated) {
            if (this.m_impl != null) {
                this.m_component.setImplementation(this.m_impl);
                this.m_component.setComposition(this.m_compositionInstance, this.m_compositionMethod);
            } else {
                Objects.nonNull(this.m_factory);
                if (this.m_hasFactoryRef) {
                    this.m_component.setFactory(this.m_factory, "create");
                    if (this.m_factoryHasComposite) {
                        this.m_component.setComposition(this.m_factory, "getComposite");
                    }
                } else {
                    this.m_component.setFactory(this.m_factory, this.m_factoryCreateMethod);
                }
            }
            if (this.hasCallbacks()) {
                if (this.m_refs.get((Object)ComponentCallback.INIT) == null) {
                    this.setCallbackMethodRef(ComponentCallback.INIT, component -> this.invokeCallbacks(component, this.m_initCallbackInstance, this.m_init, "init"));
                }
                if (this.m_refs.get((Object)ComponentCallback.START) == null) {
                    this.setCallbackMethodRef(ComponentCallback.START, component -> this.invokeCallbacks(component, this.m_startCallbackInstance, this.m_start, "start"));
                }
                if (this.m_refs.get((Object)ComponentCallback.STOP) == null) {
                    this.setCallbackMethodRef(ComponentCallback.STOP, component -> this.invokeCallbacks(component, this.m_stopCallbackInstance, this.m_stop, "stop"));
                }
                if (this.m_refs.get((Object)ComponentCallback.DESTROY) == null) {
                    this.setCallbackMethodRef(ComponentCallback.DESTROY, component -> this.invokeCallbacks(component, this.m_destroyCallbackInstance, this.m_destroy, "destroy"));
                }
                this.setInternalCallbacks();
            }
        }
        if (this.m_dependencyBuilders.size() > 0) {
            this.m_component.add((Dependency[])this.m_dependencyBuilders.stream().map(builder -> builder.build()).toArray(Dependency[]::new));
        }
        return this.m_component;
    }

    private boolean hasCallbacks() {
        return this.m_refs.size() > 0 || this.m_init != null || this.m_start != null || this.m_stop != null || this.m_destroy != null;
    }

    private void invokeCallbacks(Component component, Object callbackInstance, String callback, String defaultCallback) {
        Object[] objectArray;
        boolean logIfNotFound = callback != null;
        callback = callback != null ? callback : defaultCallback;
        ComponentContext ctx = (ComponentContext)component;
        if (callbackInstance != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = callbackInstance;
        } else {
            objectArray = ctx.getInstances();
        }
        Object[] instances = objectArray;
        ctx.invokeCallbackMethod(instances, callback, (Class[][])new Class[][]{{Component.class}, new Class[0]}, (Object[][])new Object[][]{{component}, new Object[0]}, logIfNotFound);
    }

    private ComponentBuilderImpl setCallbackMethodRef(ComponentCallback cbType, MethodRef ref) {
        this.m_refs.put(cbType, ref);
        return this;
    }

    private void setInternalCallbacks() {
        Object cb = new Object(){

            void init(Component comp) {
                ComponentBuilderImpl.this.invokeLifecycleCallback(ComponentCallback.INIT, comp);
            }

            void start(Component comp) {
                ComponentBuilderImpl.this.invokeLifecycleCallback(ComponentCallback.START, comp);
            }

            void stop(Component comp) {
                ComponentBuilderImpl.this.invokeLifecycleCallback(ComponentCallback.STOP, comp);
            }

            void destroy(Component comp) {
                ComponentBuilderImpl.this.invokeLifecycleCallback(ComponentCallback.DESTROY, comp);
            }
        };
        this.m_component.setCallbacks(cb, "init", "start", "stop", "destroy");
    }

    private void invokeLifecycleCallback(ComponentCallback cbType, Component component) {
        this.m_refs.computeIfPresent(cbType, (k, mref) -> {
            mref.accept(component);
            return mref;
        });
    }

    private void ensureHasNoFactoryRef() {
        if (this.m_hasFactoryRef) {
            throw new IllegalStateException("Can't mix factory method name and factory method reference");
        }
    }

    private void ensureHasNoFactory() {
        if (this.m_hasFactory) {
            throw new IllegalStateException("Can't mix factory method name and factory method reference");
        }
    }

    static enum ComponentCallback {
        INIT,
        START,
        STOP,
        DESTROY;

    }

    @FunctionalInterface
    static interface MethodRef {
        public void accept(Component var1);
    }
}

