/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ConfigurationDependency;
import org.apache.felix.dm.context.ComponentContext;
import org.apache.felix.dm.lambda.ConfigurationDependencyBuilder;
import org.apache.felix.dm.lambda.callbacks.CbConfiguration;
import org.apache.felix.dm.lambda.callbacks.CbConfigurationComponent;
import org.apache.felix.dm.lambda.callbacks.CbDictionary;
import org.apache.felix.dm.lambda.callbacks.CbDictionaryComponent;
import org.apache.felix.dm.lambda.callbacks.InstanceCbConfiguration;
import org.apache.felix.dm.lambda.callbacks.InstanceCbConfigurationComponent;
import org.apache.felix.dm.lambda.callbacks.InstanceCbDictionary;
import org.apache.felix.dm.lambda.callbacks.InstanceCbDictionaryComponent;
import org.apache.felix.dm.lambda.impl.Helpers;

public class ConfigurationDependencyBuilderImpl
implements ConfigurationDependencyBuilder {
    private String m_pid;
    private boolean m_propagate;
    private final Component m_component;
    private String m_updateMethodName = "updated";
    private Object m_updateCallbackInstance;
    private boolean m_hasMethodRefs;
    private boolean m_hasReflectionCallback;
    private final List<MethodRef<Object>> m_refs = new ArrayList<MethodRef<Object>>();
    private boolean m_hasComponentCallbackRefs;
    private Class<?> m_configType;

    public ConfigurationDependencyBuilderImpl(Component component) {
        this.m_component = component;
    }

    @Override
    public ConfigurationDependencyBuilder pid(String pid) {
        this.m_pid = pid;
        return this;
    }

    @Override
    public ConfigurationDependencyBuilder propagate() {
        this.m_propagate = true;
        return this;
    }

    @Override
    public ConfigurationDependencyBuilder propagate(boolean propagate) {
        this.m_propagate = propagate;
        return this;
    }

    @Override
    public ConfigurationDependencyBuilder update(String update) {
        this.checkHasNoMethodRefs();
        this.m_hasReflectionCallback = true;
        this.m_updateMethodName = update;
        return this;
    }

    @Override
    public ConfigurationDependencyBuilder update(Class<?> configType, String updateMethod) {
        this.m_configType = configType;
        return this.update(updateMethod);
    }

    @Override
    public ConfigurationDependencyBuilder update(Object callbackInstance, String update) {
        this.m_updateCallbackInstance = callbackInstance;
        this.update(update);
        return this;
    }

    @Override
    public ConfigurationDependencyBuilder update(Class<?> configType, Object callbackInstance, String update) {
        this.m_updateCallbackInstance = callbackInstance;
        return this.update(callbackInstance, update);
    }

    @Override
    public <T> ConfigurationDependencyBuilder update(CbDictionary<T> callback) {
        Class componentType = Helpers.getLambdaArgType(callback, 0);
        return this.setComponentCallbackRef(componentType, (instance, component, props) -> callback.accept(instance, props));
    }

    @Override
    public <T> ConfigurationDependencyBuilder update(CbDictionaryComponent<T> callback) {
        Class componentType = Helpers.getLambdaArgType(callback, 0);
        return this.setComponentCallbackRef(componentType, (instance, component, props) -> callback.accept(instance, props, component));
    }

    @Override
    public <T, U> ConfigurationDependencyBuilder update(Class<U> configClass, CbConfiguration<T, U> callback) {
        Class componentType = Helpers.getLambdaArgType(callback, 0);
        this.m_pid = this.m_pid == null ? configClass.getName() : this.m_pid;
        return this.setComponentCallbackRef(componentType, (instance, component, props) -> {
            Object configProxy = ((ComponentContext)this.m_component).createConfigurationType(configClass, props);
            callback.accept(instance, configProxy);
        });
    }

    @Override
    public <T, U> ConfigurationDependencyBuilder update(Class<U> configClass, CbConfigurationComponent<T, U> callback) {
        Class componentType = Helpers.getLambdaArgType(callback, 0);
        this.m_pid = this.m_pid == null ? configClass.getName() : this.m_pid;
        return this.setComponentCallbackRef(componentType, (instance, component, props) -> {
            Object configProxy = ((ComponentContext)this.m_component).createConfigurationType(configClass, props);
            callback.accept(instance, configProxy, component);
        });
    }

    @Override
    public ConfigurationDependencyBuilder update(InstanceCbDictionary callback) {
        return this.setInstanceCallbackRef((instance, component, props) -> callback.accept(props));
    }

    @Override
    public ConfigurationDependencyBuilder update(InstanceCbDictionaryComponent callback) {
        return this.setInstanceCallbackRef((instance, component, props) -> callback.accept(props, component));
    }

    @Override
    public <T> ConfigurationDependencyBuilder update(Class<T> configClass, InstanceCbConfiguration<T> updated) {
        this.m_pid = this.m_pid == null ? configClass.getName() : this.m_pid;
        return this.setInstanceCallbackRef((instance, component, props) -> {
            Object configProxy = ((ComponentContext)this.m_component).createConfigurationType(configClass, props);
            updated.accept(configProxy);
        });
    }

    @Override
    public <T> ConfigurationDependencyBuilder update(Class<T> configClass, InstanceCbConfigurationComponent<T> updated) {
        this.m_pid = this.m_pid == null ? configClass.getName() : this.m_pid;
        return this.setInstanceCallbackRef((instance, component, props) -> {
            Object configProxy = ((ComponentContext)this.m_component).createConfigurationType(configClass, props);
            updated.accept(configProxy, component);
        });
    }

    @Override
    public ConfigurationDependency build() {
        String pid;
        String string = this.m_pid == null ? (this.m_configType != null ? this.m_configType.getName() : null) : (pid = this.m_pid);
        if (pid == null) {
            throw new IllegalStateException("Pid not specified");
        }
        ConfigurationDependency dep = this.m_component.getDependencyManager().createConfigurationDependency();
        Objects.nonNull(this.m_pid);
        dep.setPid(pid);
        dep.setPropagate(this.m_propagate);
        if (this.m_updateMethodName != null) {
            dep.setCallback(this.m_updateCallbackInstance, this.m_updateMethodName, this.m_configType);
        } else if (this.m_refs.size() > 0) {
            dep.setCallback(new Object(){

                void updated(Component comp, Dictionary<String, Object> props) {
                    ConfigurationDependencyBuilderImpl.this.m_refs.forEach(mref -> mref.accept(null, comp, props));
                }
            }, "updated", this.m_hasComponentCallbackRefs);
        }
        return dep;
    }

    private <T> ConfigurationDependencyBuilder setInstanceCallbackRef(MethodRef<T> ref) {
        this.checkHasNoReflectionCallbacks();
        this.m_hasMethodRefs = true;
        this.m_updateMethodName = null;
        this.m_refs.add((instance, component, props) -> ref.accept(null, component, props));
        return this;
    }

    private <T> ConfigurationDependencyBuilder setComponentCallbackRef(Class<T> type, MethodRef<T> ref) {
        this.checkHasNoReflectionCallbacks();
        this.m_updateMethodName = null;
        this.m_hasMethodRefs = true;
        this.m_hasComponentCallbackRefs = true;
        this.m_refs.add((instance, component, props) -> {
            Object componentImpl = Stream.of(component.getInstances()).filter(impl -> Helpers.getClass(impl).equals(type)).findFirst().orElseThrow(() -> new IllegalStateException("The method reference " + ref + " does not match any available component impl classes."));
            ref.accept(componentImpl, component, props);
        });
        return this;
    }

    private void checkHasNoMethodRefs() {
        if (this.m_hasMethodRefs) {
            throw new IllegalStateException("Can't mix method references with reflection based callbacks");
        }
    }

    private void checkHasNoReflectionCallbacks() {
        if (this.m_hasReflectionCallback) {
            throw new IllegalStateException("Can't mix method references with reflection based callbacks");
        }
    }

    @FunctionalInterface
    static interface MethodRef<I> {
        public void accept(I var1, Component var2, Dictionary<String, Object> var3);
    }
}

