/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.context.ComponentContext;
import org.apache.felix.dm.lambda.ComponentBuilder;
import org.apache.felix.dm.lambda.FactoryPidAdapterBuilder;
import org.apache.felix.dm.lambda.callbacks.CbConfiguration;
import org.apache.felix.dm.lambda.callbacks.CbConfigurationComponent;
import org.apache.felix.dm.lambda.callbacks.CbDictionary;
import org.apache.felix.dm.lambda.callbacks.CbDictionaryComponent;
import org.apache.felix.dm.lambda.callbacks.InstanceCbConfiguration;
import org.apache.felix.dm.lambda.callbacks.InstanceCbConfigurationComponent;
import org.apache.felix.dm.lambda.callbacks.InstanceCbDictionary;
import org.apache.felix.dm.lambda.callbacks.InstanceCbDictionaryComponent;
import org.apache.felix.dm.lambda.impl.AdapterBase;
import org.apache.felix.dm.lambda.impl.ComponentBuilderImpl;
import org.apache.felix.dm.lambda.impl.Helpers;

public class FactoryPidAdapterBuilderImpl
implements AdapterBase<FactoryPidAdapterBuilder>,
FactoryPidAdapterBuilder {
    private String m_factoryPid;
    private boolean m_propagate;
    private final DependencyManager m_dm;
    private boolean m_autoAdd = true;
    private String m_updateMethodName;
    private Object m_updateCallbackInstance;
    private boolean m_hasMethodRefs;
    private boolean m_hasReflectionCallback;
    private Consumer<ComponentBuilder<?>> m_compBuilder = componentBuilder -> {};
    private final List<MethodRef<Object>> m_refs = new ArrayList<MethodRef<Object>>();
    private Class<?> m_configType;

    public FactoryPidAdapterBuilderImpl(DependencyManager dm) {
        this.m_dm = dm;
    }

    @Override
    public void andThenBuild(Consumer<ComponentBuilder<?>> builder) {
        this.m_compBuilder = this.m_compBuilder.andThen(builder);
    }

    @Override
    public FactoryPidAdapterBuilderImpl autoAdd(boolean autoAdd) {
        this.m_autoAdd = autoAdd;
        return this;
    }

    public boolean isAutoAdd() {
        return this.m_autoAdd;
    }

    @Override
    public FactoryPidAdapterBuilder factoryPid(String pid) {
        this.m_factoryPid = pid;
        return this;
    }

    @Override
    public FactoryPidAdapterBuilder propagate() {
        this.m_propagate = true;
        return this;
    }

    @Override
    public FactoryPidAdapterBuilder propagate(boolean propagate) {
        this.m_propagate = propagate;
        return this;
    }

    @Override
    public FactoryPidAdapterBuilder update(String update) {
        this.checkHasNoMethodRefs();
        this.m_hasReflectionCallback = true;
        this.m_updateMethodName = update;
        return this;
    }

    @Override
    public FactoryPidAdapterBuilder update(Class<?> configType, String updateMethod) {
        this.update(updateMethod);
        this.m_configType = configType;
        return this;
    }

    @Override
    public FactoryPidAdapterBuilder update(Object callbackInstance, String update) {
        this.update(update);
        this.m_updateCallbackInstance = callbackInstance;
        return this;
    }

    @Override
    public FactoryPidAdapterBuilder update(Class<?> configType, Object callbackInstance, String updateMethod) {
        this.update(callbackInstance, updateMethod);
        this.m_configType = configType;
        return this;
    }

    @Override
    public <T> FactoryPidAdapterBuilder update(CbDictionary<T> callback) {
        Class type = Helpers.getLambdaArgType(callback, 0);
        return this.setComponentCallbackRef(type, (instance, component, props) -> callback.accept(instance, props));
    }

    @Override
    public <T, U> FactoryPidAdapterBuilder update(Class<U> configType, CbConfiguration<T, U> callback) {
        Class type = Helpers.getLambdaArgType(callback, 0);
        this.m_factoryPid = this.m_factoryPid == null ? configType.getName() : this.m_factoryPid;
        return this.setComponentCallbackRef(type, (instance, component, props) -> {
            Object configProxy = ((ComponentContext)component).createConfigurationType(configType, props);
            callback.accept(instance, configProxy);
        });
    }

    @Override
    public <T> FactoryPidAdapterBuilder update(CbDictionaryComponent<T> callback) {
        Class type = Helpers.getLambdaArgType(callback, 0);
        return this.setComponentCallbackRef(type, (instance, component, props) -> callback.accept(instance, props, component));
    }

    @Override
    public <T, U> FactoryPidAdapterBuilder update(Class<U> configType, CbConfigurationComponent<T, U> callback) {
        Class type = Helpers.getLambdaArgType(callback, 0);
        this.m_factoryPid = this.m_factoryPid == null ? configType.getName() : this.m_factoryPid;
        return this.setComponentCallbackRef(type, (instance, component, props) -> {
            Object configProxy = ((ComponentContext)component).createConfigurationType(configType, props);
            callback.accept(instance, configProxy, component);
        });
    }

    @Override
    public FactoryPidAdapterBuilder update(InstanceCbDictionary callback) {
        return this.setInstanceCallbackRef((instance, component, props) -> callback.accept(props));
    }

    @Override
    public <T> FactoryPidAdapterBuilder update(Class<T> configType, InstanceCbConfiguration<T> callback) {
        return this.setInstanceCallbackRef((instance, component, props) -> {
            Object configProxy = ((ComponentContext)component).createConfigurationType(configType, props);
            callback.accept(configProxy);
        });
    }

    @Override
    public FactoryPidAdapterBuilder update(InstanceCbDictionaryComponent callback) {
        return this.setInstanceCallbackRef((instance, component, props) -> callback.accept(props, component));
    }

    @Override
    public <T> FactoryPidAdapterBuilder update(Class<T> configType, InstanceCbConfigurationComponent<T> callback) {
        return this.setInstanceCallbackRef((instance, component, props) -> {
            Object configProxy = ((ComponentContext)component).createConfigurationType(configType, props);
            callback.accept(configProxy, component);
        });
    }

    @Override
    public Component build() {
        Objects.nonNull(this.m_factoryPid);
        Component c = null;
        if (this.m_hasMethodRefs) {
            Object wrapCallback = new Object(){

                public void updated(Component comp, Dictionary<String, Object> conf) {
                    FactoryPidAdapterBuilderImpl.this.m_refs.forEach(mref -> mref.accept(null, comp, conf));
                }
            };
            c = this.m_dm.createFactoryConfigurationAdapterService(this.m_factoryPid, "updated", this.m_propagate, wrapCallback);
        } else {
            c = this.m_dm.createFactoryConfigurationAdapterService(this.m_factoryPid, this.m_updateMethodName, this.m_propagate, this.m_updateCallbackInstance, this.m_configType);
        }
        ComponentBuilderImpl cb = new ComponentBuilderImpl(c, false);
        this.m_compBuilder.accept(cb);
        return cb.build();
    }

    private <T> FactoryPidAdapterBuilder setInstanceCallbackRef(MethodRef<T> ref) {
        this.checkHasNoReflectionCallbacks();
        this.m_hasMethodRefs = true;
        this.m_refs.add((instance, component, props) -> ref.accept(null, component, props));
        return this;
    }

    private <T> FactoryPidAdapterBuilder setComponentCallbackRef(Class<T> type, MethodRef<T> ref) {
        this.checkHasNoReflectionCallbacks();
        this.m_hasMethodRefs = true;
        this.m_refs.add((instance, component, props) -> {
            Object componentImpl = Stream.of(component.getInstances()).filter(impl -> Helpers.getClass(impl).equals(type)).findFirst().orElseThrow(() -> new IllegalStateException("The method reference " + ref + " does not match any available component impl classes."));
            ref.accept(componentImpl, component, props);
        });
        return this;
    }

    private void checkHasNoMethodRefs() {
        if (this.m_hasMethodRefs) {
            throw new IllegalStateException("Can't mix method references with reflection based callbacks");
        }
    }

    private void checkHasNoReflectionCallbacks() {
        if (this.m_hasReflectionCallback) {
            throw new IllegalStateException("Can't mix method references with reflection based callbacks");
        }
    }

    @FunctionalInterface
    static interface MethodRef<I> {
        public void accept(I var1, Component var2, Dictionary<String, Object> var3);
    }
}

