/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda.impl;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.context.ComponentContext;
import org.apache.felix.dm.lambda.callbacks.SerializableLambda;
import org.osgi.framework.BundleContext;

public class Helpers {
    private static final Pattern LAMBDA_INSTANCE_METHOD_TYPE = Pattern.compile("(L[^;]+)+");
    private static final String DEFAULT_REQUIRED_DEPENDENCY = "org.apache.felix.dependencymanager.lambda.defaultRequiredDependency";

    public static Class<?> getClass(Object obj) {
        Class<?> clazz = obj.getClass();
        if (Proxy.isProxyClass(clazz)) {
            return Proxy.getProxyClass(clazz.getClassLoader(), clazz);
        }
        return clazz;
    }

    public static <T> Class<T> getLambdaArgType(SerializableLambda lambda, int genericParamIndex) {
        Class<?> clazz;
        String[] lambdaParams = Helpers.getGenericTypeStrings(lambda);
        try {
            clazz = lambda.getClass().getClassLoader().loadClass(lambdaParams[genericParamIndex]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Can't load class " + lambdaParams[genericParamIndex]);
        }
        return clazz;
    }

    public static String getLambdaParameterName(SerializableLambda lambda, int index) {
        SerializedLambda serialized = Helpers.getSerializedLambda(lambda);
        Method m = Helpers.getLambdaMethod(serialized, lambda.getClass().getClassLoader());
        Parameter p = m.getParameters()[index];
        if (Objects.equals("arg0", p.getName())) {
            throw new IllegalStateException("Can'f find lambda method name (Please check you are using javac -parameters option).");
        }
        return p.getName();
    }

    private static SerializedLambda getSerializedLambda(SerializableLambda lambda) {
        if (lambda == null) {
            throw new IllegalArgumentException();
        }
        Class<?> clazz = lambda.getClass();
        while (clazz != null) {
            try {
                Method replaceMethod = clazz.getDeclaredMethod("writeReplace", new Class[0]);
                replaceMethod.setAccessible(true);
                Object serializedForm = replaceMethod.invoke((Object)lambda, new Object[0]);
                if (serializedForm instanceof SerializedLambda) {
                    return (SerializedLambda)serializedForm;
                }
            }
            catch (NoSuchMethodException replaceMethod) {
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while extracting serialized lambda", t);
            }
            clazz = clazz.getSuperclass();
        }
        throw new RuntimeException("writeReplace method not found");
    }

    public static <U> U findCompositeInstance(Component component, Class<U> type) {
        Object instance = Stream.of(component.getInstances()).filter(inst -> Objects.equals(Helpers.getClass(inst), type)).findFirst().orElseThrow(() -> new RuntimeException("Did not find a component instance matching type " + type));
        return (U)instance;
    }

    public static boolean isDependencyRequiredByDefault(Component c) {
        BundleContext ctx = ((ComponentContext)c).getBundleContext();
        String defaultRequiredDependency = ctx.getProperty(DEFAULT_REQUIRED_DEPENDENCY);
        if (defaultRequiredDependency != null) {
            defaultRequiredDependency = defaultRequiredDependency.trim();
            String componentName = c.getComponentDeclaration().getClassName();
            String[] stringArray = defaultRequiredDependency.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pkg = stringArray[n2];
                if (componentName.startsWith(pkg)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static String[] getGenericTypeStrings(SerializableLambda lambda) {
        SerializedLambda sl = Helpers.getSerializedLambda(lambda);
        String lambdaMethodType = sl.getInstantiatedMethodType();
        Matcher m = LAMBDA_INSTANCE_METHOD_TYPE.matcher(lambdaMethodType);
        ArrayList<String> results = new ArrayList<String>();
        while (m.find()) {
            results.add(m.group().substring(1).replace("/", "."));
        }
        return results.toArray(new String[0]);
    }

    private static Method getLambdaMethod(SerializedLambda lambda, ClassLoader loader) {
        Class<?> implClass;
        String implClassName = lambda.getImplClass().replace('/', '.');
        try {
            implClass = loader.loadClass(implClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Lambda Method not found (can not instantiate class " + implClassName);
        }
        return Stream.of(implClass.getDeclaredMethods()).filter(method -> Objects.equals(method.getName(), lambda.getImplMethodName())).findFirst().orElseThrow(() -> new RuntimeException("Lambda Method not found"));
    }
}

