/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.osgi.framework.ServiceReference;

public class SRefAsDictionary
extends Dictionary<String, Object> {
    private final ServiceReference<?> m_ref;
    private volatile int m_size = -1;

    public SRefAsDictionary(ServiceReference<?> ref) {
        this.m_ref = ref;
    }

    @Override
    public Object get(Object key) {
        return this.m_ref.getProperty(key.toString());
    }

    @Override
    public int size() {
        return this.m_size != -1 ? this.m_size : (this.m_size = this.m_ref.getPropertyKeys().length);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Enumeration<String> keys() {
        return Collections.enumeration(Arrays.asList(this.m_ref.getPropertyKeys()));
    }

    @Override
    public Enumeration<Object> elements() {
        final String[] keys = this.m_ref.getPropertyKeys();
        return new Enumeration<Object>(){
            int m_index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.m_index < keys.length;
            }

            @Override
            public Object nextElement() {
                if (this.m_index >= keys.length) {
                    throw new NoSuchElementException();
                }
                return SRefAsDictionary.this.m_ref.getProperty(keys[this.m_index++]);
            }
        };
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        int max = this.size() - 1;
        if (max == -1) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        String[] keys = this.m_ref.getPropertyKeys();
        sb.append('{');
        int i = 0;
        while (true) {
            String key = keys[i];
            Object value = this.m_ref.getProperty(key);
            sb.append(key);
            sb.append('=');
            sb.append(value == this ? "(this Dictionary)" : value.toString());
            if (i == max) {
                return sb.append('}').toString();
            }
            sb.append(", ");
            ++i;
        }
    }
}

