/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda.impl;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.lambda.ComponentBuilder;
import org.apache.felix.dm.lambda.ServiceAdapterBuilder;
import org.apache.felix.dm.lambda.impl.AdapterBase;
import org.apache.felix.dm.lambda.impl.ComponentBuilderImpl;
import org.apache.felix.dm.lambda.impl.ServiceCallbacksBuilderImpl;

public class ServiceAdapterBuilderImpl<T>
extends ServiceCallbacksBuilderImpl<T, ServiceAdapterBuilder<T>>
implements AdapterBase<ServiceAdapterBuilder<T>>,
ServiceAdapterBuilder<T> {
    private final Class<T> m_adapteeType;
    private String m_adapteeFilter;
    private boolean m_propagate = true;
    private final DependencyManager m_dm;
    private boolean m_autoAdd = true;
    private Consumer<ComponentBuilder<?>> m_compBuilder = componentBuilder -> {};

    public ServiceAdapterBuilderImpl(DependencyManager dm, Class<T> adapterType) {
        super(adapterType);
        this.m_dm = dm;
        this.m_adapteeType = adapterType;
    }

    @Override
    public void andThenBuild(Consumer<ComponentBuilder<?>> after) {
        this.m_compBuilder = this.m_compBuilder.andThen(after);
    }

    @Override
    public ServiceAdapterBuilderImpl<T> autoAdd(boolean autoAdd) {
        this.m_autoAdd = autoAdd;
        return this;
    }

    public ServiceAdapterBuilderImpl<T> autoAdd() {
        this.m_autoAdd = true;
        return this;
    }

    public boolean isAutoAdd() {
        return this.m_autoAdd;
    }

    @Override
    public ServiceAdapterBuilder<T> filter(String adapteeFilter) {
        this.m_adapteeFilter = adapteeFilter;
        return this;
    }

    @Override
    public ServiceAdapterBuilder<T> propagate(boolean propagate) {
        this.m_propagate = propagate;
        return this;
    }

    @Override
    public Component build() {
        Objects.nonNull(this.m_adapteeFilter);
        String add = this.getAdded();
        String change = this.getChanged();
        String remove = this.getRemoved();
        String swap = this.getSwapped();
        Object cbInstance = this.getCallbackInstance();
        if (this.hasRefs()) {
            cbInstance = this.createCallbackInstance();
            add = "add";
            change = "change";
            remove = "remove";
            swap = this.m_swapRefs.size() > 0 ? "swap" : null;
        }
        Component c = this.m_dm.createAdapterService(this.m_adapteeType, this.m_adapteeFilter, this.getAutoConfigField(), cbInstance, add, change, remove, swap, this.m_propagate);
        ComponentBuilderImpl cb = new ComponentBuilderImpl(c, false);
        this.m_compBuilder.accept(cb);
        return cb.build();
    }
}

