/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda.impl;

import java.util.Objects;
import java.util.function.Consumer;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.lambda.ComponentBuilder;
import org.apache.felix.dm.lambda.ServiceAspectBuilder;
import org.apache.felix.dm.lambda.impl.AdapterBase;
import org.apache.felix.dm.lambda.impl.ComponentBuilderImpl;
import org.apache.felix.dm.lambda.impl.ServiceCallbacksBuilderImpl;

public class ServiceAspectBuilderImpl<T>
extends ServiceCallbacksBuilderImpl<T, ServiceAspectBuilder<T>>
implements AdapterBase<ServiceAspectBuilder<T>>,
ServiceAspectBuilder<T> {
    private final DependencyManager m_dm;
    private final Class<T> m_aspectType;
    private String m_aspectFilter;
    private int m_aspectRanking;
    private boolean m_autoAdd = true;
    private Consumer<ComponentBuilder<?>> m_compBuilder = componentBuilder -> {};

    public ServiceAspectBuilderImpl(DependencyManager dm, Class<T> aspectType) {
        super(aspectType);
        this.m_dm = dm;
        this.m_aspectType = aspectType;
    }

    @Override
    public void andThenBuild(Consumer<ComponentBuilder<?>> after) {
        this.m_compBuilder = this.m_compBuilder.andThen(after);
    }

    @Override
    public ServiceAspectBuilderImpl<T> autoAdd(boolean autoAdd) {
        this.m_autoAdd = autoAdd;
        return this;
    }

    public boolean isAutoAdd() {
        return this.m_autoAdd;
    }

    @Override
    public ServiceAspectBuilder<T> filter(String aspectFilter) {
        this.m_aspectFilter = aspectFilter;
        return this;
    }

    @Override
    public ServiceAspectBuilder<T> rank(int ranking) {
        this.m_aspectRanking = ranking;
        return this;
    }

    @Override
    public Component build() {
        Objects.nonNull(this.m_aspectType);
        if (this.getAutoConfigField() != null && (this.hasRefs() || this.hasCallbacks())) {
            throw new IllegalStateException("Can't mix autoConfig fields and aspect callbacks.");
        }
        Component c = null;
        if (this.getAutoConfigField() != null) {
            c = this.m_dm.createAspectService(this.m_aspectType, this.m_aspectFilter, this.m_aspectRanking, this.getAutoConfigField());
        } else if (this.hasRefs()) {
            Object cbInstance = this.createCallbackInstance();
            String add = "add";
            String change = "change";
            String remove = "remove";
            String swap = this.m_swapRefs.size() > 0 ? "swap" : null;
            c = this.m_dm.createAspectService(this.m_aspectType, this.m_aspectFilter, this.m_aspectRanking, cbInstance, add, change, remove, swap);
        } else if (this.hasCallbacks()) {
            String add = this.getAdded();
            String change = this.getChanged();
            String remove = this.getRemoved();
            String swap = this.getSwapped();
            c = this.m_dm.createAspectService(this.m_aspectType, this.m_aspectFilter, this.m_aspectRanking, add, change, remove, swap);
        } else {
            c = this.m_dm.createAspectService(this.m_aspectType, this.m_aspectFilter, this.m_aspectRanking);
        }
        ComponentBuilderImpl cb = new ComponentBuilderImpl(c, false);
        this.m_compBuilder.accept(cb);
        return cb.build();
    }
}

