/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.lambda.ServiceCallbacksBuilder;
import org.apache.felix.dm.lambda.callbacks.CbRefServiceRefService;
import org.apache.felix.dm.lambda.callbacks.CbRefServiceRefServiceComponent;
import org.apache.felix.dm.lambda.callbacks.CbService;
import org.apache.felix.dm.lambda.callbacks.CbServiceComponent;
import org.apache.felix.dm.lambda.callbacks.CbServiceComponentRef;
import org.apache.felix.dm.lambda.callbacks.CbServiceDict;
import org.apache.felix.dm.lambda.callbacks.CbServiceMap;
import org.apache.felix.dm.lambda.callbacks.CbServiceRef;
import org.apache.felix.dm.lambda.callbacks.CbServiceService;
import org.apache.felix.dm.lambda.callbacks.CbServiceServiceComponent;
import org.apache.felix.dm.lambda.callbacks.InstanceCbRefServiceRefService;
import org.apache.felix.dm.lambda.callbacks.InstanceCbRefServiceRefServiceComponent;
import org.apache.felix.dm.lambda.callbacks.InstanceCbService;
import org.apache.felix.dm.lambda.callbacks.InstanceCbServiceComponent;
import org.apache.felix.dm.lambda.callbacks.InstanceCbServiceComponentRef;
import org.apache.felix.dm.lambda.callbacks.InstanceCbServiceDict;
import org.apache.felix.dm.lambda.callbacks.InstanceCbServiceMap;
import org.apache.felix.dm.lambda.callbacks.InstanceCbServiceRef;
import org.apache.felix.dm.lambda.callbacks.InstanceCbServiceService;
import org.apache.felix.dm.lambda.callbacks.InstanceCbServiceServiceComponent;
import org.apache.felix.dm.lambda.impl.Helpers;
import org.apache.felix.dm.lambda.impl.SRefAsDictionary;
import org.apache.felix.dm.lambda.impl.SRefAsMap;
import org.osgi.framework.ServiceReference;

public class ServiceCallbacksBuilderImpl<S, B extends ServiceCallbacksBuilder<S, B>>
implements ServiceCallbacksBuilder<S, B> {
    protected boolean m_autoConfig = true;
    protected boolean m_autoConfigInvoked = false;
    protected String m_autoConfigField;
    protected Object m_callbackInstance;
    protected String m_added;
    protected String m_changed;
    protected String m_removed;
    protected String m_swapped;
    protected final Class<S> m_serviceClass;
    protected final Map<Cb, List<MethodRef<Object, S>>> m_refs = new HashMap<Cb, List<MethodRef<Object, S>>>();
    protected final List<SwapMethodRef<?, S>> m_swapRefs = new ArrayList();

    public ServiceCallbacksBuilderImpl(Class<S> serviceClass) {
        this.m_serviceClass = serviceClass;
    }

    public B autoConfig() {
        this.autoConfig(true);
        return (B)this;
    }

    public B autoConfig(String field) {
        this.m_autoConfigField = field;
        this.m_autoConfigInvoked = true;
        return (B)this;
    }

    public B autoConfig(boolean autoConfig) {
        this.m_autoConfig = autoConfig;
        this.m_autoConfigInvoked = true;
        return (B)this;
    }

    @Override
    public B callbackInstance(Object callbackInstance) {
        this.m_callbackInstance = callbackInstance;
        return (B)this;
    }

    @Override
    public B add(String add) {
        return this.callbacks(add, null, null, null);
    }

    @Override
    public B change(String change) {
        return this.callbacks(null, change, null, null);
    }

    @Override
    public B remove(String remove) {
        return this.callbacks(null, null, remove, null);
    }

    @Override
    public B swap(String swap) {
        return this.callbacks(null, null, null, swap);
    }

    private B callbacks(String added, String changed, String removed, String swapped) {
        this.requiresNoMethodRefs();
        this.m_added = added != null ? added : this.m_added;
        this.m_changed = changed != null ? changed : this.m_changed;
        this.m_removed = removed != null ? removed : this.m_removed;
        String string = this.m_swapped = swapped != null ? swapped : this.m_swapped;
        if (!this.m_autoConfigInvoked) {
            this.m_autoConfig = false;
        }
        return (B)this;
    }

    @Override
    public <T> B add(CbService<T, S> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public <T> B change(CbService<T, S> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public <T> B remove(CbService<T, S> remove) {
        return this.callbacks(null, null, remove);
    }

    private <T> B callbacks(CbService<T, S> add, CbService<T, S> change, CbService<T, S> remove) {
        if (add != null) {
            this.setComponentCallbackRef(Cb.ADD, Helpers.getLambdaArgType(add, 0), (inst, comp, ref, srv) -> add.accept(inst, srv));
        }
        if (change != null) {
            this.setComponentCallbackRef(Cb.CHG, Helpers.getLambdaArgType(change, 0), (inst, comp, ref, srv) -> change.accept(inst, srv));
        }
        if (remove != null) {
            this.setComponentCallbackRef(Cb.REM, Helpers.getLambdaArgType(remove, 0), (inst, comp, ref, srv) -> remove.accept(inst, srv));
        }
        return (B)this;
    }

    @Override
    public B add(InstanceCbService<S> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public B change(InstanceCbService<S> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public B remove(InstanceCbService<S> remove) {
        return this.callbacks(null, null, remove);
    }

    public B callbacks(InstanceCbService<S> add, InstanceCbService<S> change, InstanceCbService<S> remove) {
        if (add != null) {
            this.setInstanceCallbackRef(Cb.ADD, (inst, comp, ref, srv) -> add.accept(srv));
        }
        if (change != null) {
            this.setInstanceCallbackRef(Cb.CHG, (inst, comp, ref, srv) -> change.accept(srv));
        }
        if (remove != null) {
            this.setInstanceCallbackRef(Cb.REM, (inst, comp, ref, srv) -> remove.accept(srv));
        }
        return (B)this;
    }

    @Override
    public <T> B add(CbServiceMap<T, S> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public <T> B change(CbServiceMap<T, S> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public <T> B remove(CbServiceMap<T, S> remove) {
        return this.callbacks(null, null, remove);
    }

    public <T> B callbacks(CbServiceMap<T, S> add, CbServiceMap<T, S> change, CbServiceMap<T, S> remove) {
        if (add != null) {
            this.setComponentCallbackRef(Cb.ADD, Helpers.getLambdaArgType(add, 0), (inst, comp, ref, srv) -> add.accept(inst, srv, new SRefAsMap(ref)));
        }
        if (change != null) {
            this.setComponentCallbackRef(Cb.CHG, Helpers.getLambdaArgType(change, 0), (inst, comp, ref, srv) -> change.accept(inst, srv, new SRefAsMap(ref)));
        }
        if (remove != null) {
            this.setComponentCallbackRef(Cb.REM, Helpers.getLambdaArgType(remove, 0), (inst, comp, ref, srv) -> remove.accept(inst, srv, new SRefAsMap(ref)));
        }
        return (B)this;
    }

    @Override
    public B add(InstanceCbServiceMap<S> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public B change(InstanceCbServiceMap<S> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public B remove(InstanceCbServiceMap<S> remove) {
        return this.callbacks(null, null, remove);
    }

    public B callbacks(InstanceCbServiceMap<S> add, InstanceCbServiceMap<S> change, InstanceCbServiceMap<S> remove) {
        if (add != null) {
            this.setInstanceCallbackRef(Cb.ADD, (inst, comp, ref, srv) -> add.accept(srv, new SRefAsMap(ref)));
        }
        if (change != null) {
            this.setInstanceCallbackRef(Cb.CHG, (inst, comp, ref, srv) -> change.accept(srv, new SRefAsMap(ref)));
        }
        if (remove != null) {
            this.setInstanceCallbackRef(Cb.REM, (inst, comp, ref, srv) -> remove.accept(srv, new SRefAsMap(ref)));
        }
        return (B)this;
    }

    @Override
    public <T> B add(CbServiceDict<T, S> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public <T> B change(CbServiceDict<T, S> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public <T> B remove(CbServiceDict<T, S> remove) {
        return this.callbacks(null, null, remove);
    }

    public <T> B callbacks(CbServiceDict<T, S> add, CbServiceDict<T, S> change, CbServiceDict<T, S> remove) {
        if (add != null) {
            this.setComponentCallbackRef(Cb.ADD, Helpers.getLambdaArgType(add, 0), (inst, comp, ref, srv) -> add.accept(inst, srv, new SRefAsDictionary(ref)));
        }
        if (change != null) {
            this.setComponentCallbackRef(Cb.CHG, Helpers.getLambdaArgType(change, 0), (inst, comp, ref, srv) -> change.accept(inst, srv, new SRefAsDictionary(ref)));
        }
        if (remove != null) {
            this.setComponentCallbackRef(Cb.REM, Helpers.getLambdaArgType(remove, 0), (inst, comp, ref, srv) -> remove.accept(inst, srv, new SRefAsDictionary(ref)));
        }
        return (B)this;
    }

    @Override
    public B add(InstanceCbServiceDict<S> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public B change(InstanceCbServiceDict<S> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public B remove(InstanceCbServiceDict<S> remove) {
        return this.callbacks(null, null, remove);
    }

    public B callbacks(InstanceCbServiceDict<S> add, InstanceCbServiceDict<S> change, InstanceCbServiceDict<S> remove) {
        if (add != null) {
            this.setInstanceCallbackRef(Cb.ADD, (inst, comp, ref, srv) -> add.accept(srv, new SRefAsDictionary(ref)));
        }
        if (change != null) {
            this.setInstanceCallbackRef(Cb.CHG, (inst, comp, ref, srv) -> change.accept(srv, new SRefAsDictionary(ref)));
        }
        if (remove != null) {
            this.setInstanceCallbackRef(Cb.REM, (inst, comp, ref, srv) -> remove.accept(srv, new SRefAsDictionary(ref)));
        }
        return (B)this;
    }

    @Override
    public <T> B add(CbServiceRef<T, S> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public <T> B change(CbServiceRef<T, S> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public <T> B remove(CbServiceRef<T, S> remove) {
        return this.callbacks(null, null, remove);
    }

    public <T> B callbacks(CbServiceRef<T, S> add, CbServiceRef<T, S> change, CbServiceRef<T, S> remove) {
        if (add != null) {
            this.setComponentCallbackRef(Cb.ADD, Helpers.getLambdaArgType(add, 0), (inst, comp, ref, srv) -> add.accept(inst, srv, ref));
        }
        if (change != null) {
            this.setComponentCallbackRef(Cb.CHG, Helpers.getLambdaArgType(change, 0), (inst, comp, ref, srv) -> change.accept(inst, srv, ref));
        }
        if (remove != null) {
            this.setComponentCallbackRef(Cb.REM, Helpers.getLambdaArgType(remove, 0), (inst, comp, ref, srv) -> remove.accept(inst, srv, ref));
        }
        return (B)this;
    }

    @Override
    public B add(InstanceCbServiceRef<S> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public B change(InstanceCbServiceRef<S> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public B remove(InstanceCbServiceRef<S> remove) {
        return this.callbacks(null, null, remove);
    }

    public B callbacks(InstanceCbServiceRef<S> add, InstanceCbServiceRef<S> change, InstanceCbServiceRef<S> remove) {
        if (add != null) {
            this.setInstanceCallbackRef(Cb.ADD, (inst, comp, ref, srv) -> add.accept(srv, ref));
        }
        if (change != null) {
            this.setInstanceCallbackRef(Cb.CHG, (inst, comp, ref, srv) -> change.accept(srv, ref));
        }
        if (remove != null) {
            this.setInstanceCallbackRef(Cb.REM, (inst, comp, ref, srv) -> remove.accept(srv, ref));
        }
        return (B)this;
    }

    @Override
    public <T> B add(CbServiceComponent<T, S> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public <T> B change(CbServiceComponent<T, S> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public <T> B remove(CbServiceComponent<T, S> remove) {
        return this.callbacks(null, null, remove);
    }

    private <T> B callbacks(CbServiceComponent<T, S> add, CbServiceComponent<T, S> change, CbServiceComponent<T, S> remove) {
        if (add != null) {
            this.setComponentCallbackRef(Cb.ADD, Helpers.getLambdaArgType(add, 0), (inst, comp, ref, srv) -> add.accept(inst, srv, comp));
        }
        if (change != null) {
            this.setComponentCallbackRef(Cb.CHG, Helpers.getLambdaArgType(change, 0), (inst, comp, ref, srv) -> change.accept(inst, srv, comp));
        }
        if (remove != null) {
            this.setComponentCallbackRef(Cb.REM, Helpers.getLambdaArgType(remove, 0), (inst, comp, ref, srv) -> remove.accept(inst, srv, comp));
        }
        return (B)this;
    }

    @Override
    public B add(InstanceCbServiceComponent<S> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public B change(InstanceCbServiceComponent<S> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public B remove(InstanceCbServiceComponent<S> remove) {
        return this.callbacks(null, null, remove);
    }

    public B callbacks(InstanceCbServiceComponent<S> add, InstanceCbServiceComponent<S> change, InstanceCbServiceComponent<S> remove) {
        if (add != null) {
            this.setInstanceCallbackRef(Cb.ADD, (inst, comp, ref, srv) -> add.accept(srv, comp));
        }
        if (change != null) {
            this.setInstanceCallbackRef(Cb.CHG, (inst, comp, ref, srv) -> change.accept(srv, comp));
        }
        if (remove != null) {
            this.setInstanceCallbackRef(Cb.REM, (inst, comp, ref, srv) -> remove.accept(srv, comp));
        }
        return (B)this;
    }

    @Override
    public <T> B add(CbServiceComponentRef<T, S> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public <T> B change(CbServiceComponentRef<T, S> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public <T> B remove(CbServiceComponentRef<T, S> remove) {
        return this.callbacks(null, null, remove);
    }

    private <T> B callbacks(CbServiceComponentRef<T, S> add, CbServiceComponentRef<T, S> change, CbServiceComponentRef<T, S> remove) {
        if (add != null) {
            this.setComponentCallbackRef(Cb.ADD, Helpers.getLambdaArgType(add, 0), (inst, comp, ref, srv) -> add.accept(inst, srv, comp, ref));
        }
        if (change != null) {
            this.setComponentCallbackRef(Cb.CHG, Helpers.getLambdaArgType(change, 0), (inst, comp, ref, srv) -> change.accept(inst, srv, comp, ref));
        }
        if (remove != null) {
            this.setComponentCallbackRef(Cb.REM, Helpers.getLambdaArgType(remove, 0), (inst, comp, ref, srv) -> remove.accept(inst, srv, comp, ref));
        }
        return (B)this;
    }

    @Override
    public B add(InstanceCbServiceComponentRef<S> add) {
        return this.callbacks(add, null, null);
    }

    @Override
    public B change(InstanceCbServiceComponentRef<S> change) {
        return this.callbacks(null, change, null);
    }

    @Override
    public B remove(InstanceCbServiceComponentRef<S> remove) {
        return this.callbacks(null, null, remove);
    }

    public B callbacks(InstanceCbServiceComponentRef<S> add, InstanceCbServiceComponentRef<S> change, InstanceCbServiceComponentRef<S> remove) {
        if (add != null) {
            this.setInstanceCallbackRef(Cb.ADD, (inst, comp, ref, srv) -> add.accept(srv, comp, ref));
        }
        if (change != null) {
            this.setInstanceCallbackRef(Cb.CHG, (inst, comp, ref, srv) -> change.accept(srv, comp, ref));
        }
        if (remove != null) {
            this.setInstanceCallbackRef(Cb.REM, (inst, comp, ref, srv) -> remove.accept(srv, comp, ref));
        }
        return (B)this;
    }

    @Override
    public <T> B swap(CbServiceService<T, S> swap) {
        Class type = Helpers.getLambdaArgType(swap, 0);
        return this.setComponentSwapCallbackRef(type, (inst, component, oref, oserv, nref, nserv) -> swap.accept(inst, oserv, nserv));
    }

    @Override
    public <T> B swap(CbServiceServiceComponent<T, S> swap) {
        Class type = Helpers.getLambdaArgType(swap, 0);
        return this.setComponentSwapCallbackRef(type, (inst, component, oref, oserv, nref, nserv) -> swap.accept(inst, oserv, nserv, component));
    }

    @Override
    public <T> B swap(CbRefServiceRefService<T, S> swap) {
        Class type = Helpers.getLambdaArgType(swap, 0);
        return this.setComponentSwapCallbackRef(type, (inst, component, oref, oserv, nref, nserv) -> swap.accept(inst, oref, oserv, nref, nserv));
    }

    @Override
    public <T> B swap(CbRefServiceRefServiceComponent<T, S> swap) {
        Class type = Helpers.getLambdaArgType(swap, 0);
        return this.setComponentSwapCallbackRef(type, (inst, component, oref, oserv, nref, nserv) -> swap.accept(inst, oref, oserv, nref, nserv, component));
    }

    @Override
    public B swap(InstanceCbServiceService<S> swap) {
        return this.setInstanceSwapCallbackRef((inst, component, oref, oserv, nref, nserv) -> swap.accept(oserv, nserv));
    }

    @Override
    public B swap(InstanceCbServiceServiceComponent<S> swap) {
        return this.setInstanceSwapCallbackRef((inst, component, oref, oserv, nref, nserv) -> swap.accept(oserv, nserv, component));
    }

    @Override
    public B swap(InstanceCbRefServiceRefService<S> swap) {
        return this.setInstanceSwapCallbackRef((inst, component, oref, oserv, nref, nserv) -> swap.accept(oref, oserv, nref, nserv));
    }

    @Override
    public B swap(InstanceCbRefServiceRefServiceComponent<S> swap) {
        return this.setInstanceSwapCallbackRef((inst, component, oref, oserv, nref, nserv) -> swap.accept(oref, oserv, nref, nserv, component));
    }

    protected <I> B setComponentCallbackRef(Cb cbType, Class<I> type, MethodRef<I, S> ref) {
        this.requiresNoCallbacks();
        if (!this.m_autoConfigInvoked) {
            this.m_autoConfig = false;
        }
        List list = this.m_refs.computeIfAbsent(cbType, l -> new ArrayList());
        list.add((instance, component, sref, service) -> {
            Object componentImpl = Stream.of(component.getInstances()).filter(impl -> Helpers.getClass(impl).equals(type)).findFirst().orElseThrow(() -> new IllegalStateException("The method reference " + ref + " does not match any available component impl classes."));
            ref.accept(componentImpl, component, sref, service);
        });
        return (B)this;
    }

    protected <T> B setInstanceCallbackRef(Cb cbType, MethodRef<T, S> ref) {
        this.requiresNoCallbacks();
        if (!this.m_autoConfigInvoked) {
            this.m_autoConfig = false;
        }
        List list = this.m_refs.computeIfAbsent(cbType, l -> new ArrayList());
        list.add((instance, component, sref, service) -> ref.accept(component.getInstance(), component, sref, service));
        return (B)this;
    }

    public <I> B setComponentSwapCallbackRef(Class<I> type, SwapMethodRef<I, S> ref) {
        this.requiresNoCallbacks();
        if (!this.m_autoConfigInvoked) {
            this.m_autoConfig = false;
        }
        this.m_swapRefs.add((instance, component, oref, oservice, nref, nservice) -> {
            Object componentImpl = Stream.of(component.getInstances()).filter(impl -> Helpers.getClass(impl).equals(type)).findFirst().orElseThrow(() -> new IllegalStateException("The method reference " + ref + " does not match any available component impl classes."));
            ref.accept(componentImpl, component, oref, oservice, nref, nservice);
        });
        return (B)this;
    }

    public <I> B setInstanceSwapCallbackRef(SwapMethodRef<I, S> ref) {
        this.requiresNoCallbacks();
        if (!this.m_autoConfigInvoked) {
            this.m_autoConfig = false;
        }
        this.m_swapRefs.add((instance, component, oref, oservice, nref, nservice) -> ref.accept(component.getInstance(), component, oref, oservice, nref, nservice));
        return (B)this;
    }

    Object createCallbackInstance() {
        Object cb = null;
        cb = new Object(){

            void add(Component c, ServiceReference<S> ref, Object service) {
                ServiceCallbacksBuilderImpl.this.invokeMethodRefs(Cb.ADD, c, ref, service);
            }

            void change(Component c, ServiceReference<S> ref, Object service) {
                ServiceCallbacksBuilderImpl.this.invokeMethodRefs(Cb.CHG, c, ref, service);
            }

            void remove(Component c, ServiceReference<S> ref, Object service) {
                ServiceCallbacksBuilderImpl.this.invokeMethodRefs(Cb.REM, c, ref, service);
            }

            void swap(Component c, ServiceReference<S> oldRef, Object oldSrv, ServiceReference<S> newRef, Object newSrv) {
                ServiceCallbacksBuilderImpl.this.invokeSwapMethodRefs(c, oldRef, oldSrv, newRef, newSrv);
            }
        };
        return cb;
    }

    boolean hasRefs() {
        return this.m_refs.size() > 0 || this.m_swapRefs.size() > 0;
    }

    boolean hasCallbacks() {
        return this.m_callbackInstance != null || this.m_added != null || this.m_changed != null || this.m_removed != null || this.m_swapped != null;
    }

    String getAutoConfigField() {
        return this.m_autoConfigField;
    }

    Object getCallbackInstance() {
        return this.m_callbackInstance;
    }

    String getAdded() {
        return this.m_added;
    }

    String getChanged() {
        return this.m_changed;
    }

    String getRemoved() {
        return this.m_removed;
    }

    String getSwapped() {
        return this.m_swapped;
    }

    private void invokeMethodRefs(Cb cbType, Component comp, ServiceReference<S> ref, S service) {
        this.m_refs.computeIfPresent(cbType, (k, mrefs) -> {
            mrefs.forEach(mref -> mref.accept(null, comp, ref, service));
            return mrefs;
        });
    }

    private void invokeSwapMethodRefs(Component c, ServiceReference<S> oref, S osrv, ServiceReference<S> nref, S nsrv) {
        this.m_swapRefs.forEach(ref -> ref.accept(null, c, oref, osrv, nref, nsrv));
    }

    private void requiresNoCallbacks() {
        if (this.hasCallbacks()) {
            throw new IllegalStateException("can't mix method references and string callbacks.");
        }
    }

    private void requiresNoMethodRefs() {
        if (this.hasRefs()) {
            throw new IllegalStateException("can't mix method references and string callbacks.");
        }
    }

    static enum Cb {
        ADD,
        CHG,
        REM;

    }

    @FunctionalInterface
    static interface MethodRef<I, S> {
        public void accept(I var1, Component var2, ServiceReference<S> var3, S var4);
    }

    @FunctionalInterface
    static interface SwapMethodRef<I, S> {
        public void accept(I var1, Component var2, ServiceReference<S> var3, S var4, ServiceReference<S> var5, S var6);
    }
}

