/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.lambda.impl;

import java.util.Dictionary;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.lambda.ServiceDependencyBuilder;
import org.apache.felix.dm.lambda.impl.Helpers;
import org.apache.felix.dm.lambda.impl.ServiceCallbacksBuilderImpl;
import org.osgi.framework.ServiceReference;

public class ServiceDependencyBuilderImpl<S>
extends ServiceCallbacksBuilderImpl<S, ServiceDependencyBuilder<S>>
implements ServiceDependencyBuilder<S> {
    private final Class<S> m_serviceIface;
    private final Component m_component;
    private String m_filter;
    private ServiceReference<S> m_ref;
    private boolean m_required;
    private String m_debug;
    private boolean m_propagate;
    private Object m_propagateInstance;
    private String m_propagateMethod;
    private Object m_defaultImpl;
    private long m_timeout = -1L;
    private boolean m_requiredSet;

    public ServiceDependencyBuilderImpl(Component component, Class<S> service) {
        super(service);
        this.m_serviceIface = service;
        this.m_component = component;
    }

    @Override
    public ServiceDependencyBuilder<S> filter(String filter) {
        this.m_filter = filter;
        return this;
    }

    @Override
    public ServiceDependencyBuilder<S> ref(ServiceReference<S> ref) {
        this.m_ref = ref;
        return this;
    }

    @Override
    public ServiceDependencyBuilder<S> optional() {
        return this.required(false);
    }

    @Override
    public ServiceDependencyBuilder<S> required() {
        return this.required(true);
    }

    @Override
    public ServiceDependencyBuilder<S> required(boolean required) {
        this.m_required = required;
        this.m_requiredSet = true;
        return this;
    }

    @Override
    public ServiceDependencyBuilder<S> debug(String label) {
        this.m_debug = label;
        return this;
    }

    @Override
    public ServiceDependencyBuilder<S> propagate() {
        return this.propagate(true);
    }

    @Override
    public ServiceDependencyBuilder<S> propagate(boolean propagate) {
        this.m_propagate = propagate;
        return this;
    }

    @Override
    public ServiceDependencyBuilder<S> propagate(Object instance, String method) {
        this.m_propagateInstance = instance;
        this.m_propagateMethod = method;
        return this;
    }

    @Override
    public ServiceDependencyBuilder<S> propagate(final Function<ServiceReference<S>, Dictionary<String, Object>> propagate) {
        Object wrappedCallback = new Object(){

            Dictionary<String, Object> propagate(ServiceReference<S> ref) {
                return (Dictionary)propagate.apply(ref);
            }
        };
        this.propagate(wrappedCallback, "propagate");
        return this;
    }

    @Override
    public ServiceDependencyBuilder<S> propagate(final BiFunction<ServiceReference<S>, S, Dictionary<String, Object>> propagate) {
        Object wrappedCallback = new Object(){

            Dictionary<String, Object> propagate(ServiceReference<S> ref, S service) {
                return (Dictionary)propagate.apply(ref, service);
            }
        };
        this.propagate(wrappedCallback, "propagate");
        return this;
    }

    @Override
    public ServiceDependencyBuilder<S> defImpl(Object defaultImpl) {
        this.m_defaultImpl = defaultImpl;
        return this;
    }

    @Override
    public ServiceDependencyBuilder<S> timeout(long timeout) {
        this.m_timeout = timeout;
        this.required();
        return this;
    }

    @Override
    public ServiceDependency build() {
        ServiceDependency sd;
        DependencyManager dm = this.m_component.getDependencyManager();
        if (this.m_ref != null && this.m_filter != null) {
            throw new IllegalArgumentException("Can not set ref and filter at the same time");
        }
        if (this.m_serviceIface == null && (this.m_ref == null || this.m_filter == null)) {
            throw new IllegalArgumentException("service interface not specified, and no service reference or service filter specified.");
        }
        ServiceDependency serviceDependency = sd = this.m_timeout > -1L ? dm.createTemporalServiceDependency(this.m_timeout) : dm.createServiceDependency();
        if (this.m_ref != null) {
            sd.setService(this.m_serviceIface, this.m_ref);
        } else {
            sd.setService(this.m_serviceIface, this.m_filter);
        }
        if (!this.m_requiredSet) {
            this.m_required = Helpers.isDependencyRequiredByDefault(this.m_component);
        }
        sd.setRequired(this.m_required);
        sd.setDefaultImplementation(this.m_defaultImpl);
        if (this.m_debug != null) {
            sd.setDebug(this.m_debug);
        }
        if (this.m_propagate) {
            sd.setPropagate(true);
        } else if (this.m_propagateInstance != null) {
            if (this.m_propagateMethod == null) {
                throw new IllegalArgumentException("propagate instance can't be null");
            }
            sd.setPropagate(this.m_propagateInstance, this.m_propagateMethod);
        }
        if (this.hasCallbacks()) {
            sd.setCallbacks(this.m_callbackInstance, this.m_added, this.m_changed, this.m_removed, this.m_swapped);
        } else if (this.hasRefs()) {
            Object cb = this.createCallbackInstance();
            sd.setCallbacks(cb, "add", "change", "remove", this.m_swapRefs.size() > 0 ? "swap" : null);
        }
        if (this.m_autoConfigField != null) {
            sd.setAutoConfig(this.m_autoConfigField);
        } else {
            sd.setAutoConfig(this.m_autoConfig);
        }
        return sd;
    }
}

