/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.stream.Stream;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.Logger;
import org.apache.felix.dm.PropertyMetaData;
import org.apache.felix.dm.impl.AbstractDecorator;
import org.apache.felix.dm.impl.CallbackTypeDef;
import org.apache.felix.dm.impl.ComponentImpl;
import org.apache.felix.dm.impl.ConfigurationDependencyImpl;
import org.apache.felix.dm.impl.FilterComponent;
import org.apache.felix.dm.impl.InvocationUtil;
import org.apache.felix.dm.impl.metatype.MetaTypeProviderImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class FactoryConfigurationAdapterImpl
extends FilterComponent {
    protected final String m_factoryPid;
    protected final Logger m_logger;

    public FactoryConfigurationAdapterImpl(DependencyManager dm, String factoryPid, String update, boolean propagate, Object updateCallbackInstance, Class<?> configType) {
        super(dm.createComponent());
        this.m_factoryPid = factoryPid;
        this.m_logger = this.m_component.getLogger();
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", factoryPid);
        this.m_component.setInterface(ManagedServiceFactory.class.getName(), props).setImplementation(new AdapterImpl(update, propagate, updateCallbackInstance, configType)).setCallbacks("init", null, "stop", null);
    }

    public FactoryConfigurationAdapterImpl(DependencyManager dm, String factoryPid, String update, boolean propagate, Object updateCallbackInstance, BundleContext bctx, Logger logger, String heading, String description, String localization, PropertyMetaData[] properyMetaData) {
        super(dm.createComponent());
        this.m_factoryPid = factoryPid;
        this.m_logger = logger;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.pid", factoryPid);
        this.m_component.setInterface(ManagedServiceFactory.class.getName(), props).setImplementation(new MetaTypeAdapterImpl(update, propagate, updateCallbackInstance, bctx, logger, heading, description, localization, properyMetaData)).setCallbacks("init", null, "stop", null);
    }

    @Override
    public String getName() {
        return "Adapter for factory pid " + this.m_factoryPid;
    }

    public class AdapterImpl
    extends AbstractDecorator
    implements ManagedServiceFactory {
        protected final String m_update;
        protected final boolean m_propagate;
        protected final Object m_updateCallbackInstance;
        protected final Class<?> m_configType;

        public AdapterImpl(String updateMethod, boolean propagate, Object updateCallbackObject, Class<?> configType) {
            this.m_update = updateMethod;
            this.m_propagate = propagate;
            this.m_updateCallbackInstance = updateCallbackObject;
            this.m_configType = configType;
        }

        public String getName() {
            return FactoryConfigurationAdapterImpl.this.m_factoryPid;
        }

        @Override
        public Component createService(Object[] properties) throws Exception {
            Dictionary settings = (Dictionary)properties[0];
            Component newService = this.m_manager.createComponent();
            Dictionary<String, Object> serviceProperties = this.getServiceProperties(settings);
            newService.setInterface(FactoryConfigurationAdapterImpl.this.m_serviceInterfaces, serviceProperties);
            newService.setImplementation(FactoryConfigurationAdapterImpl.this.m_serviceImpl);
            newService.setComposition(FactoryConfigurationAdapterImpl.this.m_compositionInstance, FactoryConfigurationAdapterImpl.this.m_compositionMethod);
            newService.setCallbacks(FactoryConfigurationAdapterImpl.this.m_callbackObject, FactoryConfigurationAdapterImpl.this.m_init, FactoryConfigurationAdapterImpl.this.m_start, FactoryConfigurationAdapterImpl.this.m_stop, FactoryConfigurationAdapterImpl.this.m_destroy);
            this.configureAutoConfigState(newService, FactoryConfigurationAdapterImpl.this.m_component);
            FactoryConfigurationAdapterImpl.this.copyDependencies(FactoryConfigurationAdapterImpl.this.m_component.getDependencies(), newService);
            int i = 0;
            while (i < FactoryConfigurationAdapterImpl.this.m_stateListeners.size()) {
                newService.add((ComponentStateListener)FactoryConfigurationAdapterImpl.this.m_stateListeners.get(i));
                ++i;
            }
            ((ComponentImpl)newService).instantiateComponent();
            CallbackTypeDef callbackInfo = ConfigurationDependencyImpl.createCallbackType(FactoryConfigurationAdapterImpl.this.m_logger, newService, this.m_configType, settings);
            this.invokeUpdated(newService, callbackInfo);
            return newService;
        }

        @Override
        public void updateService(Object[] properties) throws Exception {
            Dictionary cmSettings = (Dictionary)properties[0];
            Component service = (Component)properties[1];
            CallbackTypeDef callbackInfo = ConfigurationDependencyImpl.createCallbackType(FactoryConfigurationAdapterImpl.this.m_logger, service, this.m_configType, cmSettings);
            this.invokeUpdated(service, callbackInfo);
            if (FactoryConfigurationAdapterImpl.this.m_serviceInterfaces != null && this.m_propagate) {
                Dictionary<String, Object> serviceProperties = this.getServiceProperties(cmSettings);
                service.setServiceProperties(serviceProperties);
            }
        }

        private void invokeUpdated(Component service, CallbackTypeDef callbackInfo) throws Exception {
            Object[] instances;
            boolean callbackFound = false;
            Object[] objectArray = instances = this.getUpdateCallbackInstances(service);
            int n = instances.length;
            int n2 = 0;
            while (n2 < n) {
                Object instance = objectArray[n2];
                try {
                    InvocationUtil.invokeCallbackMethod(instance, this.m_update, callbackInfo.m_sigs, callbackInfo.m_args);
                    callbackFound |= true;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                ++n2;
            }
            if (!callbackFound) {
                Object[] instanceClasses = (String[])Stream.of(instances).map(c -> c.getClass().getName()).toArray(String[]::new);
                FactoryConfigurationAdapterImpl.this.m_logger.log(1, "\"" + this.m_update + "\" configuration callback not found in any of the component classes: " + Arrays.toString(instanceClasses));
            }
        }

        private Object[] getUpdateCallbackInstances(Component comp) {
            if (this.m_updateCallbackInstance == null) {
                return comp.getInstances();
            }
            return new Object[]{this.m_updateCallbackInstance};
        }

        private Dictionary<String, Object> getServiceProperties(Dictionary<String, ?> settings) {
            Object val;
            String key;
            Enumeration<Object> keys;
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            if (FactoryConfigurationAdapterImpl.this.m_serviceProperties != null) {
                keys = FactoryConfigurationAdapterImpl.this.m_serviceProperties.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    val = FactoryConfigurationAdapterImpl.this.m_serviceProperties.get(key);
                    ((Dictionary)props).put(key, val);
                }
            }
            if (this.m_propagate) {
                keys = settings.keys();
                while (keys.hasMoreElements()) {
                    key = (String)keys.nextElement();
                    if (key.toString().startsWith(".")) continue;
                    val = settings.get(key);
                    ((Dictionary)props).put(key, val);
                }
            }
            return props;
        }
    }

    class MetaTypeAdapterImpl
    extends AdapterImpl
    implements MetaTypeProvider {
        private final MetaTypeProviderImpl m_metaType;

        public MetaTypeAdapterImpl(String updateMethod, boolean propagate, Object updateCallbackInstance, BundleContext bctx, Logger logger, String heading, String description, String localization, PropertyMetaData[] properyMetaData) {
            super(updateMethod, propagate, updateCallbackInstance, null);
            this.m_metaType = new MetaTypeProviderImpl(FactoryConfigurationAdapterImpl.this.m_factoryPid, bctx, logger, null, this);
            this.m_metaType.setName(heading);
            this.m_metaType.setDescription(description);
            if (localization != null) {
                this.m_metaType.setLocalization(localization);
            }
            int i = 0;
            while (i < properyMetaData.length) {
                this.m_metaType.add(properyMetaData[i]);
                ++i;
            }
        }

        public String[] getLocales() {
            return this.m_metaType.getLocales();
        }

        public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
            return this.m_metaType.getObjectClassDefinition(id, locale);
        }
    }
}

