/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.index;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.felix.dm.impl.ServiceUtil;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public abstract class AbstractFactoryFilterIndex {
    protected final Map<Long, SortedSet<ServiceReference>> m_sidToServiceReferencesMap = new HashMap<Long, SortedSet<ServiceReference>>();
    protected final Map<ServiceListener, String> m_listenerToFilterMap = new HashMap<ServiceListener, String>();

    public void addedService(ServiceReference reference, Object service) {
        this.add(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.modify(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.remove(reference);
    }

    public void swappedService(ServiceReference reference, Object service, ServiceReference newReference, Object newService) {
        this.addedService(newReference, newService);
        this.removedService(reference, service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ServiceReference reference) {
        Long sid = ServiceUtil.getServiceIdObject(reference);
        Map<Long, SortedSet<ServiceReference>> map = this.m_sidToServiceReferencesMap;
        synchronized (map) {
            SortedSet<ServiceReference> list = this.m_sidToServiceReferencesMap.get(sid);
            if (list == null) {
                list = new TreeSet<ServiceReference>();
                this.m_sidToServiceReferencesMap.put(sid, list);
            }
            list.add(reference);
        }
    }

    public void modify(ServiceReference reference) {
        this.remove(reference);
        this.add(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ServiceReference reference) {
        Long sid = ServiceUtil.getServiceIdObject(reference);
        Map<Long, SortedSet<ServiceReference>> map = this.m_sidToServiceReferencesMap;
        synchronized (map) {
            SortedSet<ServiceReference> list = this.m_sidToServiceReferencesMap.get(sid);
            if (list != null) {
                list.remove(reference);
            }
        }
    }

    protected boolean referenceMatchesObjectClass(ServiceReference ref, String objectClass) {
        boolean matches = false;
        Object value = ref.getProperty("objectClass");
        matches = Arrays.asList((String[])value).contains(objectClass);
        return matches;
    }

    protected static class FilterData {
        public long m_serviceId;
        public String m_objectClass;
        public int m_ranking;

        protected FilterData() {
        }

        public String toString() {
            return "FilterData [serviceId=" + this.m_serviceId + "]";
        }
    }
}

