/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.tracker;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCustomizerActionSet {
    final List<CustomizerAction> m_actions = new ArrayList<CustomizerAction>();

    public void addCustomizerAdded(Object item, Object related, Object object) {
        this.m_actions.add(new CustomizerAction(Type.ADDED, item, related, object));
    }

    public void addCustomizerModified(Object item, Object related, Object object) {
        this.m_actions.add(new CustomizerAction(Type.MODIFIED, item, related, object));
    }

    public void addCustomizerRemoved(Object item, Object related, Object object) {
        this.m_actions.add(new CustomizerAction(Type.REMOVED, item, related, object));
    }

    public void appendActionSet(AbstractCustomizerActionSet actionSet) {
        for (CustomizerAction action : actionSet.getActions()) {
            this.m_actions.add(action);
        }
    }

    abstract void execute();

    public List<CustomizerAction> getActions() {
        return this.m_actions;
    }

    public String toString() {
        return "AbstractCustomizerActionSet [m_actions=" + this.m_actions + "]";
    }

    static class CustomizerAction {
        private final Type m_type;
        private final Object m_item;
        private final Object m_related;
        private final Object m_object;

        public CustomizerAction(Type type, Object item, Object related, Object object) {
            this.m_type = type;
            this.m_item = item;
            this.m_related = related;
            this.m_object = object;
        }

        public Type getType() {
            return this.m_type;
        }

        public Object getItem() {
            return this.m_item;
        }

        public Object getRelated() {
            return this.m_related;
        }

        public Object getObject() {
            return this.m_object;
        }

        public String toString() {
            return "CustomizerAction [m_type=" + (Object)((Object)this.m_type) + ", m_item=" + this.m_item + ", m_related=" + this.m_related + ", m_object=" + this.m_object + "]";
        }
    }

    static enum Type {
        ADDED,
        MODIFIED,
        REMOVED;

    }
}

