/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.bnd;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.service.Plugin;
import aQute.service.reporter.Reporter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Set;
import org.apache.felix.dm.annotation.plugin.bnd.BndLogger;
import org.apache.felix.dm.annotation.plugin.bnd.DescriptorGenerator;
import org.apache.felix.dm.annotation.plugin.bnd.Logger;

public class AnnotationPlugin
implements AnalyzerPlugin,
Plugin {
    private static final String IMPORT_SERVICE = "Import-Service";
    private static final String EXPORT_SERVICE = "Export-Service";
    private static final String REQUIRE_CAPABILITY = "Require-Capability";
    private static final String LOGLEVEL = "log";
    private static final String BUILD_IMPEXT = "build-import-export-service";
    private static final String ADD_REQUIRE_CAPABILITY = "add-require-capability";
    private static final String DM_RUNTIME_CAPABILITY = "osgi.extender; filter:=\"(&(osgi.extender=org.apache.felix.dependencymanager.runtime)(version>=4.0.0))\"";
    private BndLogger m_logger;
    private Reporter m_reporter;
    private boolean m_buildImportExportService;
    private boolean m_addRequireCapability;
    private Map<String, String> m_properties;

    public void setReporter(Reporter reporter) {
        this.m_reporter = reporter;
    }

    public void setProperties(Map<String, String> map) {
        this.m_properties = map;
    }

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        this.m_logger = new BndLogger(this.m_reporter, analyzer.getBsn());
        try {
            try {
                this.init(analyzer);
                DescriptorGenerator generator = new DescriptorGenerator(analyzer, this.m_logger);
                if (generator.execute()) {
                    analyzer.setProperty("DependencyManager-Component", generator.getDescriptorPaths());
                    if (this.m_addRequireCapability) {
                        this.buildRequireCapability(analyzer);
                    }
                    if (this.m_buildImportExportService) {
                        if (analyzer.getProperty(IMPORT_SERVICE) == null) {
                            this.buildImportExportService(analyzer, IMPORT_SERVICE, generator.getImportService());
                        }
                        if (analyzer.getProperty(EXPORT_SERVICE) == null) {
                            this.buildImportExportService(analyzer, EXPORT_SERVICE, generator.getExportService());
                        }
                    }
                    Map<String, Resource> resources = generator.getDescriptors();
                    for (Map.Entry<String, Resource> entry : resources.entrySet()) {
                        analyzer.getJar().putResource(entry.getKey(), entry.getValue());
                    }
                    Resource metaType = generator.getMetaTypeResource();
                    if (metaType != null) {
                        analyzer.getJar().putResource("OSGI-INF/metatype/metatype.xml", metaType);
                    }
                }
            }
            catch (Throwable t) {
                this.m_logger.error(AnnotationPlugin.parse(t), new Object[0]);
                this.m_logger.close();
            }
        }
        finally {
            this.m_logger.close();
        }
        return false;
    }

    private void init(Analyzer analyzer) {
        this.m_logger.setLevel(this.parseOption(this.m_properties, LOGLEVEL, Logger.Level.Warn.toString()));
        this.m_buildImportExportService = this.parseOption(this.m_properties, BUILD_IMPEXT, false);
        this.m_addRequireCapability = this.parseOption(this.m_properties, ADD_REQUIRE_CAPABILITY, false);
        analyzer.setExceptions(true);
        this.m_logger.info("Initialized Bnd DependencyManager plugin: buildImportExport=%b", this.m_buildImportExportService);
    }

    private String parseOption(Map<String, String> opts, String name, String def) {
        String value = opts.get(name);
        return value == null ? def : value;
    }

    private boolean parseOption(Map<String, String> opts, String name, boolean def) {
        String value = opts.get(name);
        return value == null ? def : Boolean.valueOf(value);
    }

    private void buildImportExportService(Analyzer analyzer, String header, Set<String> services) {
        this.m_logger.info("building %s header with the following services: %s", header, services);
        if (services.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String service : services) {
                sb.append(service);
                sb.append(",");
            }
            sb.setLength(sb.length() - 1);
            analyzer.setProperty(header, sb.toString());
        }
    }

    private void buildRequireCapability(Analyzer analyzer) {
        String requireCapability = analyzer.getProperty(REQUIRE_CAPABILITY);
        if (requireCapability == null) {
            analyzer.setProperty(REQUIRE_CAPABILITY, DM_RUNTIME_CAPABILITY);
        } else {
            StringBuilder sb = new StringBuilder(requireCapability).append(",").append(DM_RUNTIME_CAPABILITY);
            analyzer.setProperty(REQUIRE_CAPABILITY, sb.toString());
        }
    }

    private static String parse(Throwable e) {
        StringWriter buffer = new StringWriter();
        PrintWriter pw = new PrintWriter(buffer);
        e.printStackTrace(pw);
        return buffer.toString();
    }
}

