/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.mvn;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Resource;
import java.io.File;
import java.util.Map;
import org.apache.felix.dm.annotation.plugin.bnd.DescriptorGenerator;
import org.apache.felix.dm.annotation.plugin.mvn.MvnLogger;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class AnnotationMojo
extends AbstractMojo {
    private MavenProject m_project;
    private String m_artifactExtension;
    private String m_log;

    public void execute() throws MojoExecutionException {
        Analyzer analyzer = null;
        Jar jar = null;
        try {
            File target = this.getBundleName();
            this.getLog().info((CharSequence)("Generating DM component descriptors for bundle " + target));
            analyzer = new Analyzer();
            analyzer.setJar(target);
            analyzer.analyze();
            DescriptorGenerator generator = new DescriptorGenerator(analyzer, new MvnLogger(this.getLog(), this.m_log));
            if (generator.execute()) {
                jar = analyzer.getJar();
                jar.getManifest().getMainAttributes().putValue("DependencyManager-Component", generator.getDescriptorPaths());
                Map<String, Resource> resources = generator.getDescriptors();
                for (Map.Entry<String, Resource> entry : resources.entrySet()) {
                    jar.putResource(entry.getKey(), entry.getValue());
                }
                Resource metaType = generator.getMetaTypeResource();
                if (metaType != null) {
                    jar.putResource("OSGI-INF/metatype/metatype.xml", metaType);
                }
                this.copy(jar, target);
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Throwable t) {
            this.getLog().error((CharSequence)"Exception while scanning annotation", t);
            throw new MojoExecutionException(t.getMessage(), t.getCause());
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
    }

    private File getBundleName() {
        Build build = this.m_project.getBuild();
        return new File(build.getDirectory() + File.separator + build.getFinalName() + "." + this.m_artifactExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(Jar jar, File target) throws MojoExecutionException, Exception {
        File tmp = new File(this.getBundleName() + ".tmp");
        try {
            if (tmp.exists() && !tmp.delete()) {
                throw new MojoExecutionException("Could not remove " + tmp);
            }
            jar.write(tmp);
            jar.close();
            if (target.exists() && !target.delete()) {
                throw new MojoExecutionException("Could not remove " + target);
            }
            if (!tmp.renameTo(target)) {
                throw new MojoExecutionException("Could not rename " + tmp + " to " + target);
            }
        }
        finally {
            jar.close();
            if (tmp.exists() && !tmp.delete()) {
                throw new MojoExecutionException("Could not remove " + tmp);
            }
        }
    }
}

