/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.bnd;

import aQute.lib.osgi.Annotation;
import aQute.lib.osgi.ClassDataCollector;
import aQute.lib.osgi.Verifier;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.dm.annotation.api.AdapterService;
import org.apache.felix.dm.annotation.api.AspectService;
import org.apache.felix.dm.annotation.api.BundleAdapterService;
import org.apache.felix.dm.annotation.api.BundleDependency;
import org.apache.felix.dm.annotation.api.Component;
import org.apache.felix.dm.annotation.api.Composition;
import org.apache.felix.dm.annotation.api.ConfigurationDependency;
import org.apache.felix.dm.annotation.api.Destroy;
import org.apache.felix.dm.annotation.api.FactoryConfigurationAdapterService;
import org.apache.felix.dm.annotation.api.Init;
import org.apache.felix.dm.annotation.api.LifecycleController;
import org.apache.felix.dm.annotation.api.ResourceAdapterService;
import org.apache.felix.dm.annotation.api.ResourceDependency;
import org.apache.felix.dm.annotation.api.ServiceDependency;
import org.apache.felix.dm.annotation.api.Start;
import org.apache.felix.dm.annotation.api.Stop;
import org.apache.felix.dm.annotation.plugin.bnd.EntryParam;
import org.apache.felix.dm.annotation.plugin.bnd.EntryType;
import org.apache.felix.dm.annotation.plugin.bnd.EntryWriter;
import org.apache.felix.dm.annotation.plugin.bnd.Logger;
import org.apache.felix.dm.annotation.plugin.bnd.MetaType;
import org.apache.felix.dm.annotation.plugin.bnd.Patterns;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationCollector
extends ClassDataCollector {
    private static final String A_INIT = "L" + Init.class.getName().replace('.', '/') + ";";
    private static final String A_START = "L" + Start.class.getName().replace('.', '/') + ";";
    private static final String A_STOP = "L" + Stop.class.getName().replace('.', '/') + ";";
    private static final String A_DESTROY = "L" + Destroy.class.getName().replace('.', '/') + ";";
    private static final String A_COMPOSITION = "L" + Composition.class.getName().replace('.', '/') + ";";
    private static final String A_LIFCLE_CTRL = "L" + LifecycleController.class.getName().replace('.', '/') + ";";
    private static final String A_COMPONENT = "L" + Component.class.getName().replace('.', '/') + ";";
    private static final String A_SERVICE_DEP = "L" + ServiceDependency.class.getName().replace('.', '/') + ";";
    private static final String A_CONFIGURATION_DEPENDENCY = "L" + ConfigurationDependency.class.getName().replace('.', '/') + ";";
    private static final String A_BUNDLE_DEPENDENCY = "L" + BundleDependency.class.getName().replace('.', '/') + ";";
    private static final String A_RESOURCE_DEPENDENCY = "L" + ResourceDependency.class.getName().replace('.', '/') + ";";
    private static final String A_ASPECT_SERVICE = "L" + AspectService.class.getName().replace('.', '/') + ";";
    private static final String A_ADAPTER_SERVICE = "L" + AdapterService.class.getName().replace('.', '/') + ";";
    private static final String A_BUNDLE_ADAPTER_SERVICE = "L" + BundleAdapterService.class.getName().replace('.', '/') + ";";
    private static final String A_RESOURCE_ADAPTER_SERVICE = "L" + ResourceAdapterService.class.getName().replace('.', '/') + ";";
    private static final String A_FACTORYCONFIG_ADAPTER_SERVICE = "L" + FactoryConfigurationAdapterService.class.getName().replace('.', '/') + ";";
    private Logger m_logger;
    private String m_className;
    private String[] m_interfaces;
    private boolean m_isField;
    private String m_field;
    private String m_method;
    private String m_descriptor;
    private Set<String> m_methods = new HashSet<String>();
    private Set<String> m_dependencyNames = new HashSet<String>();
    private List<EntryWriter> m_writers = new ArrayList<EntryWriter>();
    private MetaType m_metaType;
    private String m_startMethod;
    private String m_stopMethod;
    private String m_initMethod;
    private String m_destroyMethod;
    private String m_compositionMethod;
    private String m_starter;
    private String m_stopper;

    public AnnotationCollector(Logger reporter, MetaType metaType) {
        this.m_logger = reporter;
        this.m_metaType = metaType;
    }

    public void classBegin(int access, String name) {
        this.m_className = name.replace('/', '.');
        this.m_logger.debug("class name: %s", this.m_className);
    }

    public void implementsInterfaces(String[] interfaces) {
        this.m_interfaces = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            this.m_interfaces[i] = interfaces[i].replace('/', '.');
        }
        this.m_logger.debug("implements: %s", Arrays.toString(this.m_interfaces));
    }

    public void method(int access, String name, String descriptor) {
        this.m_logger.debug("Parsed method %s, descriptor=%s", name, descriptor);
        this.m_isField = false;
        this.m_method = name;
        this.m_descriptor = descriptor;
        this.m_methods.add(name + descriptor);
    }

    public void field(int access, String name, String descriptor) {
        this.m_logger.debug("Parsed field %s, descriptor=%s", name, descriptor);
        this.m_isField = true;
        this.m_field = name;
        this.m_descriptor = descriptor;
    }

    public void annotation(Annotation annotation) {
        this.m_logger.debug("Parsed annotation: %s", annotation);
        if (annotation.getName().equals(A_COMPONENT)) {
            this.parseComponentAnnotation(annotation);
        } else if (annotation.getName().equals(A_ASPECT_SERVICE)) {
            this.parseAspectService(annotation);
        } else if (annotation.getName().equals(A_ADAPTER_SERVICE)) {
            this.parseAdapterService(annotation);
        } else if (annotation.getName().equals(A_BUNDLE_ADAPTER_SERVICE)) {
            this.parseBundleAdapterService(annotation);
        } else if (annotation.getName().equals(A_RESOURCE_ADAPTER_SERVICE)) {
            this.parseResourceAdapterService(annotation);
        } else if (annotation.getName().equals(A_FACTORYCONFIG_ADAPTER_SERVICE)) {
            this.parseFactoryConfigurationAdapterService(annotation);
        } else if (annotation.getName().equals(A_INIT)) {
            this.m_initMethod = this.m_method;
        } else if (annotation.getName().equals(A_START)) {
            this.m_startMethod = this.m_method;
        } else if (annotation.getName().equals(A_STOP)) {
            this.m_stopMethod = this.m_method;
        } else if (annotation.getName().equals(A_DESTROY)) {
            this.m_destroyMethod = this.m_method;
        } else if (annotation.getName().equals(A_COMPOSITION)) {
            Patterns.parseMethod(this.m_method, this.m_descriptor, Patterns.COMPOSITION);
            this.m_compositionMethod = this.m_method;
        } else if (annotation.getName().equals(A_LIFCLE_CTRL)) {
            this.parseLifecycleAnnotation(annotation);
        } else if (annotation.getName().equals(A_SERVICE_DEP)) {
            this.parseServiceDependencyAnnotation(annotation);
        } else if (annotation.getName().equals(A_CONFIGURATION_DEPENDENCY)) {
            this.parseConfigurationDependencyAnnotation(annotation);
        } else if (annotation.getName().equals(A_BUNDLE_DEPENDENCY)) {
            this.parseBundleDependencyAnnotation(annotation);
        } else if (annotation.getName().equals(A_RESOURCE_DEPENDENCY)) {
            this.parseRersourceDependencyAnnotation(annotation);
        }
    }

    public boolean finish() {
        if (this.m_writers.size() == 0) {
            return false;
        }
        this.checkServiceDeclared(EntryType.Component, EntryType.AspectService, EntryType.AdapterService, EntryType.BundleAdapterService, EntryType.ResourceAdapterService, EntryType.FactoryConfigurationAdapterService);
        StringBuilder sb = new StringBuilder();
        sb.append("Parsed annotation for class ");
        sb.append(this.m_className);
        for (int i = this.m_writers.size() - 1; i >= 0; --i) {
            sb.append("\n\t").append(this.m_writers.get(i).toString());
        }
        this.m_logger.info(sb.toString(), new Object[0]);
        return true;
    }

    public void writeTo(PrintWriter pw) {
        for (int i = this.m_writers.size() - 1; i >= 0; --i) {
            pw.println(this.m_writers.get(i).toString());
        }
    }

    private void parseComponentAnnotation(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.Component);
        this.m_writers.add(writer);
        this.addCommonServiceParams(writer);
        writer.put(EntryParam.impl, this.m_className);
        this.parseProperties(annotation, EntryParam.properties, writer);
        writer.putClassArray(annotation, EntryParam.provides, this.m_interfaces);
        writer.putString(annotation, EntryParam.factorySet, null);
        writer.putString(annotation, EntryParam.factoryConfigure, null);
        writer.putString(annotation, EntryParam.factoryMethod, null);
    }

    private void addCommonServiceParams(EntryWriter writer) {
        if (this.m_initMethod != null) {
            writer.put(EntryParam.init, this.m_initMethod);
        }
        if (this.m_startMethod != null) {
            writer.put(EntryParam.start, this.m_startMethod);
        }
        if (this.m_stopMethod != null) {
            writer.put(EntryParam.stop, this.m_stopMethod);
        }
        if (this.m_destroyMethod != null) {
            writer.put(EntryParam.destroy, this.m_destroyMethod);
        }
        if (this.m_compositionMethod != null) {
            writer.put(EntryParam.composition, this.m_compositionMethod);
        }
        if (this.m_starter != null) {
            writer.put(EntryParam.starter, this.m_starter);
        }
        if (this.m_stopper != null) {
            writer.put(EntryParam.stopper, this.m_stopper);
            if (this.m_starter == null) {
                throw new IllegalArgumentException("Can't use a @LifecycleController annotation for stopping a service without declaring a @LifecycleController that starts the component in class " + this.m_className);
            }
        }
    }

    private void parseServiceDependencyAnnotation(Annotation annotation) {
        String filter;
        EntryWriter writer = new EntryWriter(EntryType.ServiceDependency);
        this.m_writers.add(writer);
        String service = (String)annotation.get(EntryParam.service.toString());
        service = service != null ? Patterns.parseClass(service, Patterns.CLASS, 1) : (this.m_isField ? Patterns.parseClass(this.m_descriptor, Patterns.CLASS, 1) : Patterns.parseClass(this.m_descriptor, Patterns.BIND_CLASS, 2));
        writer.put(EntryParam.service, service);
        if (this.m_isField) {
            writer.put(EntryParam.autoConfig, this.m_field);
        }
        if ((filter = (String)annotation.get(EntryParam.filter.toString())) != null) {
            Verifier.verifyFilter((String)filter, (int)0);
            writer.put(EntryParam.filter, filter);
        }
        writer.putClass(annotation, EntryParam.defaultImpl, null);
        writer.putString(annotation, EntryParam.added, !this.m_isField ? this.m_method : null);
        writer.putString(annotation, EntryParam.timeout, null);
        Long t = (Long)annotation.get(EntryParam.timeout.toString());
        if (t != null && t < -1L) {
            throw new IllegalArgumentException("Invalid timeout value " + t + " in ServiceDependency annotation from class " + this.m_className);
        }
        writer.putString(annotation, EntryParam.required, null);
        writer.putString(annotation, EntryParam.changed, null);
        writer.putString(annotation, EntryParam.removed, null);
        this.parseDependencyName(writer, annotation);
        writer.putString(annotation, EntryParam.propagate, null);
    }

    private void parseConfigurationDependencyAnnotation(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.ConfigurationDependency);
        this.m_writers.add(writer);
        writer.putString(annotation, EntryParam.pid, this.m_className);
        writer.put(EntryParam.updated, this.m_method);
        writer.putString(annotation, EntryParam.propagate, null);
        String pid = this.get(annotation, EntryParam.pid.toString(), this.m_className);
        this.parseMetaTypes(annotation, pid, false);
    }

    private void parseAspectService(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.AspectService);
        this.m_writers.add(writer);
        this.addCommonServiceParams(writer);
        String filter = (String)annotation.get(EntryParam.filter.toString());
        if (filter != null) {
            Verifier.verifyFilter((String)filter, (int)0);
            writer.put(EntryParam.filter, filter);
        }
        Integer ranking = (Integer)annotation.get(EntryParam.ranking.toString());
        writer.put(EntryParam.ranking, ranking.toString());
        writer.put(EntryParam.impl, this.m_className);
        this.parseProperties(annotation, EntryParam.properties, writer);
        this.parseAspectOrAdapterCallbackMethods(annotation, writer);
        Object service = annotation.get(EntryParam.service.toString());
        if (service == null) {
            if (this.m_interfaces == null) {
                throw new IllegalStateException("Invalid AspectService annotation: the service attribute has not been set and the class " + this.m_className + " does not implement any interfaces");
            }
            if (this.m_interfaces.length != 1) {
                throw new IllegalStateException("Invalid AspectService annotation: the service attribute has not been set and the class " + this.m_className + " implements more than one interface");
            }
            writer.put(EntryParam.service, this.m_interfaces[0]);
        } else {
            writer.putClass(annotation, EntryParam.service, null);
        }
        writer.putString(annotation, EntryParam.factoryMethod, null);
    }

    private void parseAspectOrAdapterCallbackMethods(Annotation annotation, EntryWriter writer) {
        String field = (String)annotation.get(EntryParam.field.toString());
        String added = (String)annotation.get(EntryParam.added.toString());
        String changed = (String)annotation.get(EntryParam.changed.toString());
        String removed = (String)annotation.get(EntryParam.removed.toString());
        if (field != null && (added != null || changed != null || removed != null)) {
            throw new IllegalStateException("Annotation " + annotation + "can't applied on " + this.m_className + " can't mix \"field\" attribute with \"added/changed/removed\" attributes");
        }
        if (field == null && added == null && (changed != null || removed != null)) {
            throw new IllegalStateException("Annotation " + annotation + " applied on " + this.m_className + " must define an \"added\" callback");
        }
        writer.putString(annotation, EntryParam.field, null);
        writer.putString(annotation, EntryParam.added, null);
        writer.putString(annotation, EntryParam.changed, null);
        writer.putString(annotation, EntryParam.removed, null);
    }

    private void parseAdapterService(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.AdapterService);
        this.m_writers.add(writer);
        this.addCommonServiceParams(writer);
        writer.put(EntryParam.impl, this.m_className);
        String adapteeFilter = (String)annotation.get(EntryParam.adapteeFilter.toString());
        if (adapteeFilter != null) {
            Verifier.verifyFilter((String)adapteeFilter, (int)0);
            writer.put(EntryParam.adapteeFilter, adapteeFilter);
        }
        writer.putClass(annotation, EntryParam.adapteeService, null);
        this.parseProperties(annotation, EntryParam.properties, writer);
        writer.putClassArray(annotation, EntryParam.provides, this.m_interfaces);
        writer.putString(annotation, EntryParam.factoryMethod, null);
        this.parseAspectOrAdapterCallbackMethods(annotation, writer);
    }

    private void parseBundleAdapterService(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.BundleAdapterService);
        this.m_writers.add(writer);
        this.addCommonServiceParams(writer);
        writer.put(EntryParam.impl, this.m_className);
        String filter = (String)annotation.get(EntryParam.filter.toString());
        if (filter != null) {
            Verifier.verifyFilter((String)filter, (int)0);
            writer.put(EntryParam.filter, filter);
        }
        writer.putString(annotation, EntryParam.stateMask, Integer.valueOf(38).toString());
        this.parseProperties(annotation, EntryParam.properties, writer);
        writer.putClassArray(annotation, EntryParam.provides, this.m_interfaces);
        writer.putString(annotation, EntryParam.propagate, Boolean.FALSE.toString());
        writer.putString(annotation, EntryParam.factoryMethod, null);
    }

    private void parseResourceAdapterService(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.ResourceAdapterService);
        this.m_writers.add(writer);
        this.addCommonServiceParams(writer);
        writer.put(EntryParam.impl, this.m_className);
        String filter = (String)annotation.get(EntryParam.filter.toString());
        if (filter != null) {
            Verifier.verifyFilter((String)filter, (int)0);
            writer.put(EntryParam.filter, filter);
        }
        this.parseProperties(annotation, EntryParam.properties, writer);
        writer.putClassArray(annotation, EntryParam.provides, this.m_interfaces);
        writer.putString(annotation, EntryParam.propagate, Boolean.FALSE.toString());
        writer.putString(annotation, EntryParam.changed, null);
    }

    private void parseFactoryConfigurationAdapterService(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.FactoryConfigurationAdapterService);
        this.m_writers.add(writer);
        this.addCommonServiceParams(writer);
        writer.put(EntryParam.impl, this.m_className);
        writer.putString(annotation, EntryParam.factoryPid, this.m_className);
        writer.putString(annotation, EntryParam.updated, "updated");
        writer.putString(annotation, EntryParam.propagate, Boolean.FALSE.toString());
        writer.putClassArray(annotation, EntryParam.provides, this.m_interfaces);
        this.parseProperties(annotation, EntryParam.properties, writer);
        String factoryPid = this.get(annotation, EntryParam.factoryPid.toString(), this.m_className);
        this.parseMetaTypes(annotation, factoryPid, true);
        writer.putString(annotation, EntryParam.factoryMethod, null);
    }

    private void parseBundleDependencyAnnotation(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.BundleDependency);
        this.m_writers.add(writer);
        String filter = (String)annotation.get(EntryParam.filter.toString());
        if (filter != null) {
            Verifier.verifyFilter((String)filter, (int)0);
            writer.put(EntryParam.filter, filter);
        }
        writer.putString(annotation, EntryParam.added, this.m_method);
        writer.putString(annotation, EntryParam.changed, null);
        writer.putString(annotation, EntryParam.removed, null);
        writer.putString(annotation, EntryParam.required, null);
        writer.putString(annotation, EntryParam.stateMask, null);
        writer.putString(annotation, EntryParam.propagate, null);
        this.parseDependencyName(writer, annotation);
    }

    private void parseRersourceDependencyAnnotation(Annotation annotation) {
        EntryWriter writer = new EntryWriter(EntryType.ResourceDependency);
        this.m_writers.add(writer);
        String filter = (String)annotation.get(EntryParam.filter.toString());
        if (filter != null) {
            Verifier.verifyFilter((String)filter, (int)0);
            writer.put(EntryParam.filter, filter);
        }
        if (this.m_isField) {
            writer.put(EntryParam.autoConfig, this.m_field);
        }
        writer.putString(annotation, EntryParam.added, !this.m_isField ? this.m_method : null);
        writer.putString(annotation, EntryParam.changed, null);
        writer.putString(annotation, EntryParam.removed, null);
        writer.putString(annotation, EntryParam.required, null);
        writer.putString(annotation, EntryParam.propagate, null);
        writer.putString(annotation, EntryParam.factoryMethod, null);
        this.parseDependencyName(writer, annotation);
    }

    private void parseDependencyName(EntryWriter writer, Annotation annotation) {
        String name = (String)annotation.get(EntryParam.name.toString());
        if (name != null) {
            if (!this.m_dependencyNames.add(name)) {
                throw new IllegalArgumentException("Duplicate dependency name " + name + " in Dependency " + annotation + " from class " + this.m_className);
            }
            writer.put(EntryParam.name, name);
        }
    }

    private void parseLifecycleAnnotation(Annotation annotation) {
        Patterns.parseField(this.m_field, this.m_descriptor, Patterns.Runnable);
        if ("true".equals(this.get(annotation, EntryParam.start.name(), "true"))) {
            if (this.m_starter != null) {
                throw new IllegalStateException("Lifecycle annotation already defined on field " + this.m_starter + " in class " + this.m_className);
            }
            this.m_starter = this.m_field;
        } else {
            if (this.m_stopper != null) {
                throw new IllegalStateException("Lifecycle annotation already defined on field " + this.m_stopper + " in class " + this.m_className);
            }
            this.m_stopper = this.m_field;
        }
    }

    private void parseMetaTypes(Annotation annotation, String pid, boolean factory) {
        if (annotation.get("metadata") != null) {
            String propertiesHeading = (String)annotation.get("heading");
            String propertiesDesc = (String)annotation.get("description");
            MetaType.OCD ocd = new MetaType.OCD(pid, propertiesHeading, propertiesDesc);
            for (Object p : (Object[])annotation.get("metadata")) {
                Annotation property = (Annotation)p;
                String heading = (String)property.get("heading");
                String id = (String)property.get("id");
                String type = (String)property.get("type");
                type = type != null ? Patterns.parseClass(type, Patterns.CLASS, 1) : null;
                Object[] defaults = (Object[])property.get("defaults");
                String description = (String)property.get("description");
                Integer cardinality = (Integer)property.get("cardinality");
                Boolean required = (Boolean)property.get("required");
                MetaType.AD ad = new MetaType.AD(id, type, defaults, heading, description, cardinality, required);
                Object[] optionLabels = (Object[])property.get("optionLabels");
                Object[] optionValues = (Object[])property.get("optionValues");
                if (optionLabels == null && optionValues != null || optionLabels != null && optionValues == null || optionLabels != null && optionValues != null && optionLabels.length != optionValues.length) {
                    throw new IllegalArgumentException("invalid option labels/values specified for property " + id + " in PropertyMetadata annotation from class " + this.m_className);
                }
                if (optionValues != null) {
                    for (int i = 0; i < optionValues.length; ++i) {
                        ad.add(new MetaType.Option(optionValues[i].toString(), optionLabels[i].toString()));
                    }
                }
                ocd.add(ad);
            }
            this.m_metaType.add(ocd);
            MetaType.Designate designate = new MetaType.Designate(pid, factory);
            this.m_metaType.add(designate);
            this.m_logger.info("Parsed MetaType Properties from class " + this.m_className, new Object[0]);
        }
    }

    private void parseProperties(Annotation annotation, EntryParam attribute, EntryWriter writer) {
        Object[] parameters = (Object[])annotation.get(attribute.toString());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (parameters != null) {
            for (Object p : parameters) {
                Annotation a = (Annotation)p;
                String name = (String)a.get("name");
                String value = (String)a.get("value");
                if (value != null) {
                    properties.put(name, value);
                    continue;
                }
                Object[] values = (Object[])a.get("values");
                if (values != null) {
                    properties.put(name, Arrays.asList(values).toArray(new String[values.length]));
                    continue;
                }
                throw new IllegalArgumentException("Invalid Property attribyte \"" + (Object)((Object)attribute) + " from annotation " + annotation + " in class " + this.m_className);
            }
            writer.putProperties(attribute, properties);
        }
    }

    private void checkServiceDeclared(EntryType ... types) {
        boolean ok = false;
        if (this.m_writers.size() > 0) {
            for (EntryType type : types) {
                if (this.m_writers.get(this.m_writers.size() - 1).getEntryType() != type) continue;
                ok = true;
                break;
            }
        }
        if (!ok) {
            throw new IllegalStateException(": the class must be annotated with either one of the following types: " + Arrays.toString((Object[])types));
        }
    }

    private <T> T get(Annotation annotation, String name, T defaultValue) {
        Object value = annotation.get(name);
        return (T)(value != null ? value : defaultValue);
    }
}

