/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.bnd;

import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.service.Plugin;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Resource;
import aQute.libg.reporter.Reporter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.dm.annotation.plugin.bnd.BndLogger;
import org.apache.felix.dm.annotation.plugin.bnd.DescriptorGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationPlugin
implements AnalyzerPlugin,
Plugin {
    private BndLogger m_logger;
    private Reporter m_reporter;

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Iterator e;
        analyzer.setExceptions(true);
        try {
            DescriptorGenerator generator = new DescriptorGenerator(analyzer, this.m_logger);
            if (generator.execute()) {
                analyzer.setProperty("DependencyManager-Component", generator.getDescriptorPaths());
                Map<String, Resource> resources = generator.getDescriptors();
                for (Map.Entry<String, Resource> entry : resources.entrySet()) {
                    analyzer.getJar().putResource(entry.getKey(), entry.getValue());
                }
                Resource metaType = generator.getMetaTypeResource();
                if (metaType != null) {
                    analyzer.getJar().putResource("OSGI-INF/metatype/metatype.xml", metaType);
                }
            }
        }
        catch (Throwable t) {
            this.m_logger.error(AnnotationPlugin.parse(t), new Object[0]);
        }
        this.m_logger.getLogs(analyzer);
        if (analyzer.getWarnings().size() > 0) {
            e = analyzer.getWarnings().iterator();
            while (e.hasNext()) {
                System.out.println((String)e.next());
            }
            analyzer.getWarnings().clear();
        }
        if (analyzer.getErrors().size() > 0) {
            e = analyzer.getErrors().iterator();
            while (e.hasNext()) {
                System.err.println((String)e.next());
            }
            analyzer.getErrors().clear();
            throw new Error("DM Annotation plugin failure");
        }
        return false;
    }

    public void setProperties(Map<String, String> map) {
        String logLevel = map.get("log");
        this.m_logger = new BndLogger(logLevel == null ? "error" : logLevel);
    }

    public void setReporter(Reporter reporter) {
        this.m_reporter = reporter;
    }

    private static String parse(Throwable e) {
        StringWriter buffer = new StringWriter();
        PrintWriter pw = new PrintWriter(buffer);
        e.printStackTrace(pw);
        return buffer.toString();
    }
}

