/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.bnd;

import aQute.lib.osgi.Annotation;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.felix.dm.annotation.plugin.bnd.EntryParam;
import org.apache.felix.dm.annotation.plugin.bnd.EntryType;
import org.apache.felix.dm.annotation.plugin.bnd.Patterns;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryWriter {
    private static final String TYPE = "type";
    private JSONObject m_json;
    private EntryType m_type;

    public EntryWriter(EntryType type) {
        this.m_type = type;
        this.m_json = new JSONObject();
        try {
            this.m_json.put(TYPE, (Object)type.toString());
        }
        catch (JSONException e) {
            throw new RuntimeException("could not initialize json object", e);
        }
    }

    EntryType getEntryType() {
        return this.m_type;
    }

    public String toString() {
        return this.m_json.toString();
    }

    public void put(EntryParam param, String value) {
        this.checkType(param.toString());
        try {
            this.m_json.put(param.toString(), (Object)value);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("could not add param " + (Object)((Object)param) + ":" + value, e);
        }
    }

    public void put(EntryParam param, String[] array) {
        this.checkType(param.toString());
        try {
            this.m_json.put(param.toString(), (Object)new JSONArray(Arrays.asList(array)));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("could not add param " + (Object)((Object)param) + ":" + Arrays.toString(array), e);
        }
    }

    public void putProperties(EntryParam param, Map<String, Object> properties) {
        this.checkType(param.toString());
        try {
            JSONObject props = new JSONObject();
            for (String key : properties.keySet()) {
                Object value = properties.get(key);
                if (value instanceof String) {
                    props.put(key, value);
                    continue;
                }
                if (value instanceof String[]) {
                    props.put(key, (Object)new JSONArray(Arrays.asList((String[])value)));
                    continue;
                }
                throw new IllegalArgumentException("invalid property value: " + value);
            }
            this.m_json.put(param.toString(), (Object)props);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("invalid properties for " + (Object)((Object)param) + ": " + properties, e);
        }
    }

    public void putString(Annotation annotation, EntryParam param, String def) {
        this.checkType(param.toString());
        Object value = annotation.get(param.toString());
        if (value == null && def != null) {
            value = def;
        }
        if (value != null) {
            this.put(param, value.toString());
        }
    }

    public void putStringArray(Annotation annotation, EntryParam param, String[] def) {
        this.checkType(param.toString());
        String[] value = annotation.get(param.toString());
        if (value == null && def != null) {
            value = def;
        }
        if (value != null) {
            for (Object v : (Object[])value) {
                try {
                    this.m_json.append(param.toString(), (Object)v.toString());
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException("Could not add param " + (Object)((Object)param) + ":" + value.toString(), e);
                }
            }
        }
    }

    public void putClass(Annotation annotation, EntryParam param, Object def) {
        this.checkType(param.toString());
        Pattern pattern = Patterns.CLASS;
        Object value = annotation.get(param.toString());
        if (value == null && def != null) {
            value = def;
            pattern = null;
        }
        if (value != null) {
            if (pattern != null) {
                value = Patterns.parseClass(value.toString(), pattern, 1);
            }
            this.put(param, value.toString());
        }
    }

    public void putClassArray(Annotation annotation, EntryParam param, Object def) {
        this.checkType(param.toString());
        Pattern pattern = Patterns.CLASS;
        Object value = annotation.get(param.toString());
        if (value == null && def != null) {
            value = def;
            pattern = null;
        }
        if (value != null) {
            if (!(value instanceof Object[])) {
                throw new IllegalArgumentException("annotation parameter " + (Object)((Object)param) + " has not a class array type");
            }
            for (Object v : (Object[])value) {
                if (pattern != null) {
                    v = Patterns.parseClass(v.toString(), pattern, 1);
                }
                try {
                    this.m_json.append(param.toString(), (Object)v.toString());
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException("Could not add param " + (Object)((Object)param) + ":" + value.toString(), e);
                }
            }
        }
    }

    private void checkType(String key) {
        if (TYPE.equals(key)) {
            throw new IllegalArgumentException("\"type\" parameter can't be overriden");
        }
    }
}

