/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.bnd;

import aQute.bnd.service.AnalyzerPlugin;
import aQute.bnd.service.Plugin;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Resource;
import aQute.libg.reporter.Reporter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.felix.dm.annotation.plugin.bnd.BndLogger;
import org.apache.felix.dm.annotation.plugin.bnd.DescriptorGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationPlugin
implements AnalyzerPlugin,
Plugin {
    private static final String IMPORT_SERVICE = "Import-Service";
    private static final String EXPORT_SERVICE = "Export-Service";
    private BndLogger m_logger;
    private Reporter m_reporter;
    private boolean m_buildImportExportService;

    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        Iterator e;
        analyzer.setExceptions(true);
        try {
            DescriptorGenerator generator = new DescriptorGenerator(analyzer, this.m_logger);
            if (generator.execute()) {
                analyzer.setProperty("DependencyManager-Component", generator.getDescriptorPaths());
                if (this.m_buildImportExportService) {
                    if (analyzer.getProperty(IMPORT_SERVICE) == null) {
                        this.buildImportExportService(analyzer, IMPORT_SERVICE, generator.getImportService());
                    }
                    if (analyzer.getProperty(EXPORT_SERVICE) == null) {
                        this.buildImportExportService(analyzer, EXPORT_SERVICE, generator.getExportService());
                    }
                }
                Map<String, Resource> resources = generator.getDescriptors();
                for (Map.Entry<String, Resource> entry : resources.entrySet()) {
                    analyzer.getJar().putResource(entry.getKey(), entry.getValue());
                }
                Resource metaType = generator.getMetaTypeResource();
                if (metaType != null) {
                    analyzer.getJar().putResource("OSGI-INF/metatype/metatype.xml", metaType);
                }
            }
        }
        catch (Throwable t) {
            this.m_logger.error(AnnotationPlugin.parse(t), new Object[0]);
        }
        this.m_logger.getLogs(analyzer);
        if (analyzer.getWarnings().size() > 0) {
            e = analyzer.getWarnings().iterator();
            while (e.hasNext()) {
                System.out.println((String)e.next());
            }
            analyzer.getWarnings().clear();
        }
        if (analyzer.getErrors().size() > 0) {
            e = analyzer.getErrors().iterator();
            while (e.hasNext()) {
                System.err.println((String)e.next());
            }
            analyzer.getErrors().clear();
            throw new Error("DM Annotation plugin failure");
        }
        return false;
    }

    private void buildImportExportService(Analyzer analyzer, String header, Set<String> services) {
        this.m_logger.info("building %s header with the following services: %s", header, services);
        if (services.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String service : services) {
                sb.append(service);
                sb.append(",");
            }
            sb.setLength(sb.length() - 1);
            analyzer.setProperty(header, sb.toString());
        }
    }

    public void setProperties(Map<String, String> map) {
        String logLevel = map.get("log");
        this.m_logger = new BndLogger(logLevel == null ? "error" : logLevel);
        String generateImportExportService = map.get("build-import-export-service");
        if (generateImportExportService == null) {
            generateImportExportService = "true";
        }
        this.m_buildImportExportService = Boolean.parseBoolean(generateImportExportService);
    }

    public void setReporter(Reporter reporter) {
        this.m_reporter = reporter;
    }

    private static String parse(Throwable e) {
        StringWriter buffer = new StringWriter();
        PrintWriter pw = new PrintWriter(buffer);
        e.printStackTrace(pw);
        return buffer.toString();
    }
}

