/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.bnd;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetaType {
    private List<OCD> m_ocdList = new ArrayList<OCD>();
    private List<Designate> m_designateList = new ArrayList<Designate>();
    private static final String LOCALIZATION = "OSGI-INF/metatype/metatype";

    public void add(OCD ocd) {
        this.m_ocdList.add(ocd);
    }

    public void add(Designate designate) {
        this.m_designateList.add(designate);
    }

    public int getSize() {
        return this.m_ocdList.size();
    }

    public void writeTo(PrintWriter pw) {
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        pw.println("<metatype:MetaData xmlns:metatype=\"http://www.osgi.org/xmlns/metatype/v1.0.0\" localization=\"OSGI-INF/metatype/metatype\">");
        for (OCD ocd : this.m_ocdList) {
            ocd.writeTo(pw);
        }
        for (Designate designate : this.m_designateList) {
            designate.writeTo(pw);
        }
        pw.println("</metatype:MetaData>");
    }

    private static void writeAttribute(String name, Object value, PrintWriter pw) {
        if (value != null) {
            pw.print(" " + name + "=" + "\"" + value.toString() + "\"");
        }
    }

    public static class OBject {
        String m_ocdref;

        OBject(String ocdref) {
            this.m_ocdref = ocdref;
        }

        public void writeTo(PrintWriter pw) {
            pw.print("      <Object");
            MetaType.writeAttribute("ocdref", this.m_ocdref, pw);
            pw.println("/>");
        }
    }

    public static class Designate {
        String m_pid;
        boolean m_factory;
        OBject m_object;

        public Designate(String pid, boolean factory) {
            this.m_pid = pid;
            this.m_factory = factory;
            this.m_object = new OBject(pid);
        }

        public void writeTo(PrintWriter pw) {
            pw.print("   <Designate");
            MetaType.writeAttribute("pid", this.m_pid, pw);
            if (this.m_factory) {
                MetaType.writeAttribute("factoryPid", this.m_pid, pw);
            }
            pw.println(">");
            this.m_object.writeTo(pw);
            pw.println("   </Designate>");
        }
    }

    public static class Option {
        String m_value;
        String m_label;

        Option(String value, String label) {
            this.m_value = value;
            this.m_label = label;
        }

        public void writeTo(PrintWriter pw) {
            pw.print("         <Option");
            MetaType.writeAttribute("value", this.m_value, pw);
            MetaType.writeAttribute("label", this.m_label, pw);
            pw.println("/>");
        }
    }

    public static class AD {
        String m_id;
        String m_type;
        String m_defaults;
        String m_name;
        String m_description;
        Integer m_cardinality;
        Boolean m_required;
        List<Option> m_options = new ArrayList<Option>();
        private static final Map<String, String> _allowedTypes = new HashMap<String, String>(){
            {
                this.put(String.class.getName(), "String");
                this.put(Long.class.getName(), "Long");
                this.put(Integer.class.getName(), "Integer");
                this.put(Character.class.getName(), "Char");
                this.put(Byte.class.getName(), "Byte");
                this.put(Double.class.getName(), "Double");
                this.put(Float.class.getName(), "Float");
                this.put(Boolean.class.getName(), "Boolean");
            }
        };

        public AD(String id, String type, Object[] defaults, String name, String desc, Integer cardinality, Boolean required) {
            this.m_id = id;
            this.m_type = type == null ? "String" : this.getType(type);
            this.m_name = name;
            this.m_description = desc;
            this.m_cardinality = cardinality;
            this.m_required = required;
            if (defaults != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < defaults.length; ++i) {
                    sb.append(defaults[i].toString());
                    if (i >= defaults.length - 1) continue;
                    sb.append(",");
                }
                this.m_defaults = sb.toString();
                if (cardinality != null) {
                    int max;
                    int n = max = cardinality == 0 ? 1 : Math.abs(cardinality);
                    if (defaults.length > max) {
                        throw new IllegalArgumentException("number of default values (" + defaults.length + ") is inconsistent with cardinality (" + cardinality + ")");
                    }
                }
            }
        }

        public void writeTo(PrintWriter pw) {
            pw.print("      <AD");
            MetaType.writeAttribute("id", this.m_id, pw);
            MetaType.writeAttribute("type", this.m_type, pw);
            MetaType.writeAttribute("default", this.m_defaults, pw);
            MetaType.writeAttribute("name", this.m_name, pw);
            MetaType.writeAttribute("description", this.m_description, pw);
            MetaType.writeAttribute("cardinality", this.m_cardinality, pw);
            if (this.m_options.size() == 0) {
                pw.println("/>");
            } else {
                pw.println(">");
                for (Option option : this.m_options) {
                    option.writeTo(pw);
                }
                pw.println("      </AD>");
            }
        }

        private String getType(String t) {
            String result = _allowedTypes.get(t);
            if (result == null) {
                throw new IllegalArgumentException("Invalid Property type: " + this.m_type);
            }
            return result;
        }

        public void add(Option option) {
            this.m_options.add(option);
        }
    }

    public static class OCD {
        String m_id;
        String m_name;
        String m_description;
        List<AD> m_attributes = new ArrayList<AD>();

        OCD(String pid, String name, String desc) {
            this.m_id = pid;
            this.m_name = name;
            this.m_description = desc;
        }

        public void add(AD ad) {
            this.m_attributes.add(ad);
        }

        public void writeTo(PrintWriter pw) {
            pw.print("   <OCD");
            MetaType.writeAttribute("id", this.m_id, pw);
            MetaType.writeAttribute("name", this.m_name, pw);
            MetaType.writeAttribute("description", this.m_description, pw);
            if (this.m_attributes.size() == 0) {
                pw.println("/>");
            } else {
                pw.println(">");
                for (AD ad : this.m_attributes) {
                    ad.writeTo(pw);
                }
                pw.println("   </OCD>");
            }
        }
    }
}

