/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.mvn;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.apache.felix.dm.annotation.plugin.bnd.DescriptorGenerator;
import org.apache.felix.dm.annotation.plugin.mvn.MvnLogger;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMojo
extends AbstractMojo {
    private MavenProject m_project;
    private String m_artifactExtension;
    private String m_log;
    private boolean m_buildImportExportService;
    private File m_projectBaseDir;
    private String m_generatedOutputDir;
    private static final String IMPORT_SERVICE = "Import-Service";
    private static final String EXPORT_SERVICE = "Export-Service";

    public void execute() throws MojoExecutionException {
        Analyzer analyzer = null;
        Jar jar = null;
        try {
            File target = this.getBundleName();
            this.getLog().info((CharSequence)("Generating DM component descriptors for bundle " + target));
            analyzer = new Analyzer();
            analyzer.setJar(target);
            analyzer.analyze();
            DescriptorGenerator generator = new DescriptorGenerator(analyzer, new MvnLogger(this.getLog(), this.m_log));
            if (generator.execute()) {
                jar = analyzer.getJar();
                jar.getManifest().getMainAttributes().putValue("DependencyManager-Component", generator.getDescriptorPaths());
                Map<String, Resource> resources = generator.getDescriptors();
                for (Map.Entry<String, Resource> entry : resources.entrySet()) {
                    this.addResource(entry.getKey(), entry.getValue().openInputStream());
                    jar.putResource(entry.getKey(), entry.getValue());
                }
                Resource metaType = generator.getMetaTypeResource();
                if (metaType != null) {
                    this.addResource("OSGI-INF/metatype/metatype.xml", metaType.openInputStream());
                    jar.putResource("OSGI-INF/metatype/metatype.xml", metaType);
                }
                if (this.m_buildImportExportService) {
                    if (jar.getManifest().getMainAttributes().getValue(IMPORT_SERVICE) == null) {
                        this.buildImportExportService(jar, IMPORT_SERVICE, generator.getImportService());
                    }
                    if (jar.getManifest().getMainAttributes().getValue(EXPORT_SERVICE) == null) {
                        this.buildImportExportService(jar, EXPORT_SERVICE, generator.getExportService());
                    }
                }
                this.copy(jar, target);
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Throwable t) {
            this.getLog().error((CharSequence)"Exception while scanning annotation", t);
            throw new MojoExecutionException(t.getMessage(), t.getCause());
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
    }

    private void addResource(String key, InputStream in) throws IOException {
        if (this.m_generatedOutputDir != null) {
            int b;
            File descriptorFile = new File(this.m_projectBaseDir + File.separator + this.m_generatedOutputDir, key);
            descriptorFile.getParentFile().mkdirs();
            BufferedInputStream bin = new BufferedInputStream(in);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(descriptorFile));
            while ((b = bin.read()) != -1) {
                out.write(b);
            }
            out.close();
            bin.close();
        }
    }

    private void buildImportExportService(Jar jar, String header, Set<String> services) throws Exception {
        this.getLog().info((CharSequence)("building " + header + " header with the following services: " + services));
        if (services.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String service : services) {
                sb.append(service);
                sb.append(",");
            }
            sb.setLength(sb.length() - 1);
            jar.getManifest().getMainAttributes().putValue(header, sb.toString());
        }
    }

    private File getBundleName() {
        Build build = this.m_project.getBuild();
        return new File(build.getDirectory() + File.separator + build.getFinalName() + "." + this.m_artifactExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(Jar jar, File target) throws MojoExecutionException, Exception {
        File tmp = new File(this.getBundleName() + ".tmp");
        try {
            if (tmp.exists() && !tmp.delete()) {
                throw new MojoExecutionException("Could not remove " + tmp);
            }
            jar.write(tmp);
            jar.close();
            if (target.exists() && !target.delete()) {
                throw new MojoExecutionException("Could not remove " + target);
            }
            if (!tmp.renameTo(target)) {
                throw new MojoExecutionException("Could not rename " + tmp + " to " + target);
            }
        }
        finally {
            jar.close();
            if (tmp.exists() && !tmp.delete()) {
                throw new MojoExecutionException("Could not remove " + tmp);
            }
        }
    }
}

