/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dependencymanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.dependencymanager.ConfigurationDependency;
import org.apache.felix.dependencymanager.Service;
import org.apache.felix.dependencymanager.ServiceDependency;
import org.apache.felix.dependencymanager.impl.ConfigurationDependencyImpl;
import org.apache.felix.dependencymanager.impl.ServiceDependencyImpl;
import org.apache.felix.dependencymanager.impl.ServiceImpl;
import org.apache.felix.dm.Component;
import org.osgi.framework.BundleContext;

public class DependencyManager {
    private org.apache.felix.dm.DependencyManager m_delegate;

    public DependencyManager(BundleContext context) {
        this.m_delegate = new org.apache.felix.dm.DependencyManager(context);
    }

    public void add(Service service) {
        ServiceImpl serviceImpl = (ServiceImpl)service;
        this.m_delegate.add(serviceImpl.getDelegate());
    }

    public void remove(Service service) {
        ServiceImpl impl = (ServiceImpl)service;
        this.m_delegate.remove(impl.getDelegate());
    }

    public Service createService() {
        return new ServiceImpl(this);
    }

    public ServiceDependency createServiceDependency() {
        return new ServiceDependencyImpl(this);
    }

    public ConfigurationDependency createConfigurationDependency() {
        return new ConfigurationDependencyImpl(this);
    }

    public List getServices() {
        ArrayList<ServiceImpl> list = new ArrayList<ServiceImpl>();
        List components = this.m_delegate.getComponents();
        Iterator it = components.iterator();
        while (it.hasNext()) {
            Component c = (Component)it.next();
            list.add(new ServiceImpl(c));
        }
        return Collections.unmodifiableList(list);
    }

    public Object getDelegate() {
        return this.m_delegate;
    }
}

