/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dependencymanager.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.dependencymanager.Dependency;
import org.apache.felix.dependencymanager.DependencyManager;
import org.apache.felix.dependencymanager.Service;
import org.apache.felix.dependencymanager.ServiceStateListener;
import org.apache.felix.dependencymanager.impl.ConfigurationDependencyImpl;
import org.apache.felix.dependencymanager.impl.ServiceDependencyImpl;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.osgi.framework.ServiceRegistration;

public class ServiceImpl
implements Service {
    private Component m_delegate;
    private Map m_stateListeners = new HashMap();
    private ArrayList m_dependencies = new ArrayList();

    public ServiceImpl(DependencyManager dm) {
        org.apache.felix.dm.DependencyManager dmDelegate = (org.apache.felix.dm.DependencyManager)dm.getDelegate();
        this.m_delegate = dmDelegate.createComponent();
    }

    public ServiceImpl(Component c) {
        this.m_delegate = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service add(Dependency dependency) {
        if (dependency instanceof ServiceDependencyImpl) {
            this.m_delegate.add((org.apache.felix.dm.Dependency)((ServiceDependencyImpl)dependency).getDelegate());
        } else if (dependency instanceof ConfigurationDependencyImpl) {
            this.m_delegate.add((org.apache.felix.dm.Dependency)((ConfigurationDependencyImpl)dependency).getDelegate());
        } else {
            throw new IllegalArgumentException("dependency type not supported: " + dependency);
        }
        ServiceImpl serviceImpl = this;
        synchronized (serviceImpl) {
            this.m_dependencies.add(dependency);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service remove(Dependency dependency) {
        ServiceImpl serviceImpl = this;
        synchronized (serviceImpl) {
            this.m_dependencies.remove(dependency);
        }
        if (dependency instanceof ServiceDependencyImpl) {
            this.m_delegate.remove((org.apache.felix.dm.Dependency)((ServiceDependencyImpl)dependency).getDelegate());
        } else if (dependency instanceof ConfigurationDependencyImpl) {
            this.m_delegate.remove((org.apache.felix.dm.Dependency)((ConfigurationDependencyImpl)dependency).getDelegate());
        } else {
            throw new IllegalArgumentException("dependency type not supported: " + dependency);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateListener(final ServiceStateListener listener) {
        ComponentStateListener wrappedListener = new ComponentStateListener(){

            public void started(Component service) {
                listener.started(ServiceImpl.this);
            }

            public void starting(Component service) {
                listener.starting(ServiceImpl.this);
            }

            public void stopped(Component service) {
                listener.stopped(ServiceImpl.this);
            }

            public void stopping(Component service) {
                listener.stopping(ServiceImpl.this);
            }
        };
        ServiceImpl serviceImpl = this;
        synchronized (serviceImpl) {
            this.m_stateListeners.put(listener, wrappedListener);
        }
        this.m_delegate.addStateListener(wrappedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListener(ServiceStateListener listener) {
        ComponentStateListener wrappedListener = null;
        Map map = this.m_stateListeners;
        synchronized (map) {
            wrappedListener = (ComponentStateListener)this.m_stateListeners.remove(listener);
        }
        if (wrappedListener != null) {
            this.m_delegate.removeStateListener(wrappedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListeners() {
        Map map = this.m_stateListeners;
        synchronized (map) {
            Iterator it = this.m_stateListeners.values().iterator();
            while (it.hasNext()) {
                ComponentStateListener wrappedListener = (ComponentStateListener)it.next();
                this.m_delegate.removeStateListener(wrappedListener);
            }
            this.m_stateListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getDependencies() {
        ArrayList arrayList = this.m_dependencies;
        synchronized (arrayList) {
            return (List)this.m_dependencies.clone();
        }
    }

    public Object getService() {
        return this.m_delegate.getService();
    }

    public Dictionary getServiceProperties() {
        return this.m_delegate.getServiceProperties();
    }

    public ServiceRegistration getServiceRegistration() {
        return this.m_delegate.getServiceRegistration();
    }

    public Service setCallbacks(String init, String start, String stop, String destroy) {
        this.m_delegate.setCallbacks(init, start, stop, destroy);
        return this;
    }

    public Service setComposition(Object instance, String getMethod) {
        this.m_delegate.setComposition(instance, getMethod);
        return this;
    }

    public Service setComposition(String getMethod) {
        this.m_delegate.setComposition(getMethod);
        return this;
    }

    public Service setFactory(Object factory, String createMethod) {
        this.m_delegate.setFactory(factory, createMethod);
        return this;
    }

    public Service setFactory(String createMethod) {
        this.m_delegate.setFactory(createMethod);
        return this;
    }

    public Service setImplementation(Object implementation) {
        this.m_delegate.setImplementation(implementation);
        return this;
    }

    public Service setInterface(String serviceName, Dictionary properties) {
        this.m_delegate.setInterface(serviceName, properties);
        return this;
    }

    public Service setInterface(String[] serviceNames, Dictionary properties) {
        this.m_delegate.setInterface(serviceNames, properties);
        return this;
    }

    public void setServiceProperties(Dictionary serviceProperties) {
        this.m_delegate.setServiceProperties(serviceProperties);
    }

    public void start() {
        this.m_delegate.start();
    }

    public void stop() {
        this.m_delegate.stop();
    }

    public Component getDelegate() {
        return this.m_delegate;
    }

    public String toString() {
        return this.m_delegate.toString();
    }
}

