/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.util.Dictionary;
import java.util.List;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.AbstractBuilder;
import org.apache.felix.dm.runtime.Log;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.apache.felix.dm.runtime.ServiceLifecycleHandler;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectServiceBuilder
extends AbstractBuilder {
    private static final String TYPE = "AspectService";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void build(MetaData srvMeta, List<MetaData> depsMeta, Bundle b, DependencyManager dm) throws Exception {
        Log.instance().info("AspectServiceBuilder: building aspect service: %s with dependencies %s", srvMeta, depsMeta);
        Class serviceInterface = b.loadClass(srvMeta.getString(Params.service));
        String serviceFilter = srvMeta.getString(Params.filter, null);
        Dictionary<String, Object> aspectProperties = srvMeta.getDictionary(Params.properties, null);
        int ranking = srvMeta.getInt(Params.ranking, 1);
        String implClassName = srvMeta.getString(Params.impl);
        Class implClass = b.loadClass(implClassName);
        String field = srvMeta.getString(Params.field, null);
        String added = srvMeta.getString(Params.added, null);
        String changed = srvMeta.getString(Params.changed, null);
        String removed = srvMeta.getString(Params.removed, null);
        if (field != null && (added != null || changed != null || removed != null)) {
            throw new IllegalArgumentException("autoconfig field " + field + " cant be defined with both added/changed/removed calllbacks");
        }
        if (field == null && added == null && (changed != null || removed != null)) {
            throw new IllegalArgumentException("missing added callback");
        }
        Component service = field != null ? dm.createAspectService(serviceInterface, serviceFilter, ranking, field).setServiceProperties(aspectProperties) : (added != null ? dm.createAspectService(serviceInterface, serviceFilter, ranking, added, changed, removed).setServiceProperties(aspectProperties) : dm.createAspectService(serviceInterface, serviceFilter, ranking).setServiceProperties(aspectProperties));
        String factoryMethod = srvMeta.getString(Params.factoryMethod, null);
        if (factoryMethod == null) {
            service.setImplementation((Object)implClass);
        } else {
            service.setFactory((Object)implClass, factoryMethod);
        }
        service.setComposition(srvMeta.getString(Params.composition, null));
        ServiceLifecycleHandler lfcleHandler = new ServiceLifecycleHandler(service, b, dm, srvMeta, depsMeta);
        service.setCallbacks((Object)lfcleHandler, "init", "start", "stop", "destroy");
        AspectServiceBuilder.addUnamedDependencies(b, dm, service, srvMeta, depsMeta);
        dm.add(service);
    }
}

