/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.util.List;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.DependencyBuilder;
import org.apache.felix.dm.runtime.Log;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuilder {
    abstract String getType();

    abstract void build(MetaData var1, List<MetaData> var2, Bundle var3, DependencyManager var4) throws Exception;

    protected void setCommonServiceParams(Component service, MetaData serviceMetaData) throws Exception {
        String init = serviceMetaData.getString(Params.init, null);
        String start = serviceMetaData.getString(Params.start, null);
        String stop = serviceMetaData.getString(Params.stop, null);
        String destroy = serviceMetaData.getString(Params.destroy, null);
        service.setCallbacks(init, start, stop, destroy);
        String composition = serviceMetaData.getString(Params.composition, null);
        if (composition != null) {
            service.setComposition(composition);
        }
    }

    protected static void addUnamedDependencies(Bundle b, DependencyManager dm, Component s, MetaData srvMeta, List<MetaData> depsMeta) throws Exception {
        for (MetaData dependency : depsMeta) {
            String name = dependency.getString(Params.name, null);
            if (name != null) continue;
            DependencyBuilder depBuilder = new DependencyBuilder(dependency);
            Log.instance().info("ServiceLifecycleHandler.init: adding dependency %s into service %s", dependency, srvMeta);
            Dependency d = depBuilder.build(b, dm, false);
            s.add(d);
        }
    }
}

