/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.util.Dictionary;
import java.util.List;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.AbstractBuilder;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.apache.felix.dm.runtime.ServiceLifecycleHandler;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleAdapterServiceBuilder
extends AbstractBuilder {
    private static final String TYPE = "BundleAdapterService";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void build(MetaData srvMeta, List<MetaData> depsMeta, Bundle b, DependencyManager dm) throws Exception {
        int stateMask = srvMeta.getInt(Params.stateMask, 38);
        String filter = srvMeta.getString(Params.filter, null);
        Class adapterImplClass = b.loadClass(srvMeta.getString(Params.impl));
        String[] provides = srvMeta.getStrings(Params.provides, null);
        Dictionary<String, Object> properties = srvMeta.getDictionary(Params.properties, null);
        boolean propagate = "true".equals(srvMeta.getString(Params.propagate, "false"));
        Component srv = dm.createBundleAdapterService(stateMask, filter, propagate);
        srv.setInterface(provides, properties);
        String factoryMethod = srvMeta.getString(Params.factoryMethod, null);
        if (factoryMethod == null) {
            srv.setImplementation((Object)adapterImplClass);
        } else {
            srv.setFactory((Object)adapterImplClass, factoryMethod);
        }
        srv.setComposition(srvMeta.getString(Params.composition, null));
        ServiceLifecycleHandler lfcleHandler = new ServiceLifecycleHandler(srv, b, dm, srvMeta, depsMeta);
        srv.setCallbacks((Object)lfcleHandler, "init", "start", "stop", "destroy");
        BundleAdapterServiceBuilder.addUnamedDependencies(b, dm, srv, srvMeta, depsMeta);
        dm.add(srv);
    }
}

