/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.lang.reflect.Method;
import java.util.AbstractSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.DependencyBuilder;
import org.apache.felix.dm.runtime.InvocationUtil;
import org.apache.felix.dm.runtime.Log;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.apache.felix.dm.runtime.SerialExecutor;
import org.apache.felix.dm.runtime.ServiceLifecycleHandler;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactorySet
extends AbstractSet<Dictionary> {
    private Object m_impl;
    private final String[] m_provide;
    private final Dictionary m_serviceProperties;
    private final String m_configure;
    private final ConcurrentHashMap<ServiceKey, Object> m_services = new ConcurrentHashMap();
    private MetaData m_srvMeta;
    private List<MetaData> m_depsMeta;
    private DependencyManager m_dm;
    private SerialExecutor m_serialExecutor = new SerialExecutor();
    private volatile boolean m_active;
    private Bundle m_bundle;
    private static final Object SERVICE_CREATING = new Object();

    public FactorySet(Bundle b, MetaData srvMeta, List<MetaData> depsMeta) {
        this.m_serviceProperties = srvMeta.getDictionary(Params.properties, null);
        this.m_provide = srvMeta.getStrings(Params.provides, null);
        this.m_configure = srvMeta.getString(Params.factoryConfigure, null);
        this.m_bundle = b;
        this.m_srvMeta = srvMeta;
        this.m_depsMeta = depsMeta;
    }

    public void start() {
        this.m_active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.clear();
        }
        finally {
            this.m_active = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(final Dictionary configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration parameter can't be null");
        }
        this.checkServiceAvailable();
        ServiceKey serviceKey = new ServiceKey(configuration);
        boolean creating = false;
        FactorySet factorySet = this;
        synchronized (factorySet) {
            if (!this.m_services.containsKey(serviceKey)) {
                this.m_services.put(serviceKey, SERVICE_CREATING);
                creating = true;
            }
            this.m_serialExecutor.enqueue(new Runnable(){

                public void run() {
                    FactorySet.this.doAdd(configuration);
                }
            });
        }
        this.m_serialExecutor.execute();
        return creating;
    }

    @Override
    public boolean remove(final Object configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration parameter can't be null");
        }
        if (!(configuration instanceof Dictionary)) {
            throw new IllegalArgumentException("configuration must be an instance of a Dictionary");
        }
        this.checkServiceAvailable();
        boolean found = this.m_services.containsKey(new ServiceKey((Dictionary)configuration));
        if (found) {
            this.m_serialExecutor.enqueue(new Runnable(){

                public void run() {
                    FactorySet.this.doRemove((Dictionary)configuration);
                }
            });
            this.m_serialExecutor.execute();
        }
        return found;
    }

    @Override
    public void clear() {
        if (!this.m_active) {
            return;
        }
        this.m_serialExecutor.enqueue(new Runnable(){

            public void run() {
                FactorySet.this.doClear();
            }
        });
        this.m_serialExecutor.execute();
    }

    @Override
    public Iterator<Dictionary> iterator() {
        throw new UnsupportedOperationException("iterator method is not supported by DependencyManager Set's service factories");
    }

    @Override
    public String toString() {
        return FactorySet.class.getName() + "(" + this.m_services.size() + " active instances)";
    }

    @Override
    public int size() {
        if (!this.m_active) {
            return 0;
        }
        return this.m_services.size();
    }

    private void checkServiceAvailable() {
        if (!this.m_active) {
            throw new IllegalStateException("Service not available");
        }
    }

    private void doAdd(Dictionary configuration) {
        ServiceKey serviceKey = new ServiceKey(configuration);
        Object service = this.m_services.get(serviceKey);
        if (service == null || service == SERVICE_CREATING) {
            try {
                Component s = this.m_dm.createComponent();
                Class implClass = this.m_bundle.loadClass(this.m_srvMeta.getString(Params.impl));
                String factoryMethod = this.m_srvMeta.getString(Params.factoryMethod, null);
                if (factoryMethod == null) {
                    this.m_impl = implClass.newInstance();
                } else {
                    Method m = implClass.getDeclaredMethod(factoryMethod, new Class[0]);
                    m.setAccessible(true);
                    this.m_impl = m.invoke(null, new Object[0]);
                }
                if (this.m_configure != null) {
                    this.invokeConfigure(this.m_impl, this.m_configure, configuration);
                }
                s.setImplementation(this.m_impl);
                if (this.m_provide != null) {
                    Dictionary serviceProperties = this.mergeSettings(this.m_serviceProperties, configuration);
                    s.setInterface(this.m_provide, serviceProperties);
                }
                s.setComposition(this.m_srvMeta.getString(Params.composition, null));
                ServiceLifecycleHandler lfcleHandler = new ServiceLifecycleHandler(s, this.m_bundle, this.m_dm, this.m_srvMeta, this.m_depsMeta);
                s.setCallbacks((Object)lfcleHandler, "init", "start", "stop", "destroy");
                for (MetaData dependency : this.m_depsMeta) {
                    String name = dependency.getString(Params.name, null);
                    if (name != null) continue;
                    DependencyBuilder depBuilder = new DependencyBuilder(dependency);
                    Log.instance().info("ServiceLifecycleHandler.init: adding dependency %s into service %s", dependency, this.m_srvMeta);
                    Dependency d = depBuilder.build(this.m_bundle, this.m_dm, false);
                    s.add(d);
                }
                Log.instance().info("ServiceFactory: created service %s", this.m_srvMeta);
                this.m_dm.add(s);
                this.m_services.put(serviceKey, s);
            }
            catch (Throwable t) {
                this.m_services.remove(serviceKey);
                Log.instance().error("ServiceFactory: could not instantiate service %s", t, this.m_srvMeta);
            }
        } else {
            if (this.m_configure != null) {
                Log.instance().info("ServiceFactory: updating service %s", this.m_impl);
                this.invokeConfigure(this.m_impl, this.m_configure, configuration);
            }
            if (this.m_provide != null) {
                Dictionary settings = this.mergeSettings(this.m_serviceProperties, configuration);
                ((Component)service).setServiceProperties(settings);
            }
        }
    }

    private void doRemove(Dictionary configuraton) {
        Log.instance().info("ServiceFactory: removing service %s", this.m_srvMeta);
        ServiceKey serviceKey = new ServiceKey(configuraton);
        Object service = this.m_services.remove(serviceKey);
        if (service != null && service != SERVICE_CREATING) {
            this.m_dm.remove((Component)service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClear() {
        try {
            for (Object service : this.m_services.values()) {
                if (!(service instanceof Component)) continue;
                this.m_dm.remove((Component)service);
            }
        }
        finally {
            this.m_services.clear();
        }
    }

    private Dictionary mergeSettings(Dictionary serviceProperties, Dictionary factoryConfiguration) {
        Object val;
        Object key;
        Enumeration keys;
        Hashtable props = new Hashtable();
        if (serviceProperties != null) {
            keys = serviceProperties.keys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                val = serviceProperties.get(key);
                ((Dictionary)props).put(key, val);
            }
        }
        keys = factoryConfiguration.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            if (key.toString().startsWith(".")) continue;
            val = factoryConfiguration.get(key);
            ((Dictionary)props).put(key, val);
        }
        return props;
    }

    private void invokeConfigure(Object impl, String configure, Dictionary config) {
        try {
            InvocationUtil.invokeCallbackMethod(impl, configure, new Class[][]{{Dictionary.class}}, new Object[][]{{config}});
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException("Could not invoke method " + configure + " on object " + impl, t);
        }
    }

    private static class ServiceKey {
        private Dictionary m_dictionary;

        public ServiceKey(Dictionary dictionary) {
            this.m_dictionary = dictionary;
        }

        Dictionary getDictionary() {
            return this.m_dictionary;
        }

        public boolean equals(Object that) {
            return that instanceof ServiceKey ? ((ServiceKey)that).getDictionary() == this.m_dictionary : false;
        }

        public int hashCode() {
            return System.identityHashCode(this.m_dictionary);
        }

        public String toString() {
            return Dictionary.class.getName() + "@" + System.identityHashCode(this.m_dictionary);
        }
    }
}

