/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvocationUtil {
    public static Object invokeCallbackMethod(Object instance, String methodName, Class<?>[][] signatures, Object[][] parameters) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (Class<?> currentClazz = instance.getClass(); currentClazz != null; currentClazz = currentClazz.getSuperclass()) {
            try {
                return InvocationUtil.invokeMethod(instance, currentClazz, methodName, signatures, parameters, false);
            }
            catch (NoSuchMethodException nsme) {
                continue;
            }
        }
        throw new NoSuchMethodException(methodName);
    }

    public static Object invokeMethod(Object object, Class<?> clazz, String name, Class<?>[][] signatures, Object[][] parameters, boolean isSuper) throws NoSuchMethodException, InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        if (object == null) {
            throw new IllegalArgumentException("Instance cannot be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (Proxy.isProxyClass(clazz)) {
            object = Proxy.getInvocationHandler(object);
            clazz = object.getClass();
        }
        for (int i = 0; i < signatures.length; ++i) {
            Class<?>[] signature = signatures[i];
            try {
                final Method m = clazz.getDeclaredMethod(name, signature);
                if (isSuper && Modifier.isPrivate(m.getModifiers())) continue;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        m.setAccessible(true);
                        return null;
                    }
                });
                return m.invoke(object, parameters[i]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        throw new NoSuchMethodException(name);
    }
}

