/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.AbstractBuilder;
import org.apache.felix.dm.runtime.FactorySet;
import org.apache.felix.dm.runtime.Log;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.apache.felix.dm.runtime.ServiceLifecycleHandler;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBuilder
extends AbstractBuilder {
    private static final String TYPE = "Component";
    private static final String DM_FACTORY_NAME = "dm.factory.name";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void build(MetaData srvMeta, List<MetaData> depsMeta, Bundle b, DependencyManager dm) throws Exception {
        Component service = dm.createComponent();
        String factory = srvMeta.getString(Params.factorySet, null);
        if (factory == null) {
            Log.instance().info("ComponentBuilder: building service %s with dependencies %s", srvMeta, depsMeta);
            String impl = srvMeta.getString(Params.impl);
            String composition = srvMeta.getString(Params.composition, null);
            String factoryMethod = srvMeta.getString(Params.factoryMethod, null);
            if (factoryMethod == null) {
                service.setImplementation((Object)b.loadClass(impl));
            } else {
                service.setFactory((Object)b.loadClass(impl), factoryMethod);
            }
            service.setComposition(composition);
            ComponentBuilder.addUnamedDependencies(b, dm, service, srvMeta, depsMeta);
            ServiceLifecycleHandler lfcleHandler = new ServiceLifecycleHandler(service, b, dm, srvMeta, depsMeta);
            service.setCallbacks((Object)lfcleHandler, "init", "start", "stop", "destroy");
            Dictionary<String, Object> properties = srvMeta.getDictionary(Params.properties, null);
            String[] services = srvMeta.getStrings(Params.provides, null);
            service.setInterface(services, properties);
        } else {
            Log.instance().info("ComponentBuilder: providing factory set for service %s with dependencies %s", srvMeta, depsMeta);
            FactorySet factorySet = new FactorySet(b, srvMeta, depsMeta);
            service.setImplementation((Object)factorySet);
            service.setCallbacks(null, "start", "stop", null);
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put(DM_FACTORY_NAME, factory);
            service.setInterface(Set.class.getName(), props);
        }
        dm.add(service);
    }
}

