/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONMetaData
implements MetaData,
Cloneable {
    private HashMap<String, Object> m_metadata = new HashMap();

    public JSONMetaData(JSONObject jso) throws JSONException {
        Iterator it = jso.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = jso.get(key);
            if (value instanceof String) {
                this.m_metadata.put(key, value);
                continue;
            }
            if (value instanceof JSONArray) {
                String[] array = this.decodeStringArray((JSONArray)value);
                this.m_metadata.put(key, array);
                continue;
            }
            if (!(value instanceof JSONObject)) continue;
            Hashtable<String, Object> h = new Hashtable<String, Object>();
            JSONObject obj = (JSONObject)value;
            Iterator it2 = obj.keys();
            while (it2.hasNext()) {
                String key2 = (String)it2.next();
                Object value2 = obj.get(key2);
                if (value2 instanceof String) {
                    h.put(key2, value2);
                    continue;
                }
                if (value2 instanceof JSONArray) {
                    String[] array = this.decodeStringArray((JSONArray)value2);
                    h.put(key2, array);
                    continue;
                }
                throw new IllegalArgumentException("Could not decode JSON metadata: key " + key + "contains an invalid dictionary key: " + key + " (the value is neither a String nor a String[]).");
            }
            this.m_metadata.put(key, h);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        JSONMetaData clone = (JSONMetaData)super.clone();
        clone.m_metadata = (HashMap)this.m_metadata.clone();
        return clone;
    }

    @Override
    public String getString(Params key) {
        String value = (String)this.m_metadata.get(key.toString());
        if (value == null) {
            throw new IllegalArgumentException("Parameter " + (Object)((Object)key) + " not found");
        }
        return value;
    }

    @Override
    public String getString(Params key, String def) {
        try {
            return this.getString(key);
        }
        catch (IllegalArgumentException e) {
            return def;
        }
    }

    @Override
    public int getInt(Params key) {
        String value = this.getString(key, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("parameter " + (Object)((Object)key) + " is not an int value: " + value);
            }
        }
        throw new IllegalArgumentException("missing " + (Object)((Object)key) + " parameter from annotation");
    }

    @Override
    public int getInt(Params key, int def) {
        String value = this.getString(key, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("parameter " + (Object)((Object)key) + " is not an int value: " + value);
            }
        }
        return def;
    }

    @Override
    public long getLong(Params key) {
        String value = this.getString(key, null);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("parameter " + (Object)((Object)key) + " is not a long value: " + value);
            }
        }
        throw new IllegalArgumentException("missing " + (Object)((Object)key) + " parameter from annotation");
    }

    @Override
    public long getLong(Params key, long def) {
        String value = this.getString(key, null);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("parameter " + (Object)((Object)key) + " is not a long value: " + value);
            }
        }
        return def;
    }

    @Override
    public String[] getStrings(Params key) {
        Object array = this.m_metadata.get(key.toString());
        if (array == null) {
            throw new IllegalArgumentException("Parameter " + (Object)((Object)key) + " not found");
        }
        if (!(array instanceof String[])) {
            throw new IllegalArgumentException("Parameter " + (Object)((Object)key) + " is not a String[] (" + array.getClass() + ")");
        }
        return (String[])array;
    }

    @Override
    public String[] getStrings(Params key, String[] def) {
        try {
            return this.getStrings(key);
        }
        catch (IllegalArgumentException t) {
            return def;
        }
    }

    @Override
    public Dictionary<String, Object> getDictionary(Params key, Dictionary<String, Object> def) {
        Object dictionary = this.m_metadata.get(key.toString());
        if (dictionary == null) {
            return def;
        }
        if (!(dictionary instanceof Dictionary)) {
            throw new IllegalArgumentException("Parameter " + (Object)((Object)key) + " is not a Dictionary (" + dictionary.getClass() + ")");
        }
        return (Dictionary)dictionary;
    }

    public String toString() {
        return this.m_metadata.toString();
    }

    @Override
    public void setDictionary(Params key, Dictionary<String, Object> dictionary) {
        this.m_metadata.put(key.toString(), dictionary);
    }

    @Override
    public void setString(Params key, String value) {
        this.m_metadata.put(key.toString(), value);
    }

    @Override
    public void setStrings(Params key, String[] values) {
        this.m_metadata.put(key.toString(), values);
    }

    private String[] decodeStringArray(JSONArray array) throws JSONException {
        String[] arr = new String[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.get(i);
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("JSON array is not an array of Strings: " + array);
            }
            arr[i] = value.toString();
        }
        return arr;
    }
}

