/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.DependencyBuilder;
import org.apache.felix.dm.runtime.InvocationUtil;
import org.apache.felix.dm.runtime.Log;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.apache.felix.dm.runtime.ToggleServiceDependency;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLifecycleHandler {
    private String m_init;
    private String m_start;
    private String m_stop;
    private String m_destroy;
    private MetaData m_srvMeta;
    private List<MetaData> m_depsMeta;
    private List<Dependency> m_namedDeps = new ArrayList<Dependency>();
    private Bundle m_bundle;
    private ToggleServiceDependency m_toggle;
    private static final Object SYNC = new Object();

    public ServiceLifecycleHandler(Component srv, Bundle srvBundle, DependencyManager dm, MetaData srvMeta, List<MetaData> depMeta) {
        this.m_srvMeta = srvMeta;
        this.m_init = srvMeta.getString(Params.init, null);
        this.m_start = srvMeta.getString(Params.start, null);
        this.m_stop = srvMeta.getString(Params.stop, null);
        this.m_destroy = srvMeta.getString(Params.destroy, null);
        this.m_bundle = srvBundle;
        this.m_depsMeta = depMeta;
    }

    public void init(Component service) throws Exception {
        Object[] composites;
        Object serviceInstance = service.getService();
        DependencyManager dm = service.getDependencyManager();
        String starter = this.m_srvMeta.getString(Params.starter, null);
        String stopper = this.m_srvMeta.getString(Params.stopper, null);
        if (starter != null) {
            Log.instance().debug("Setting up a lifecycle controller for service %s", serviceInstance);
            String componentName = serviceInstance.getClass().getName();
            this.m_toggle = new ToggleServiceDependency();
            AtomicBoolean startFlag = new AtomicBoolean(false);
            service.add((Dependency)this.m_toggle);
            this.setField(serviceInstance, starter, Runnable.class, new ComponentStarter(componentName, this.m_toggle, startFlag));
            if (stopper != null) {
                this.setField(serviceInstance, stopper, Runnable.class, new ComponentStopper(componentName, this.m_toggle, startFlag));
            }
        }
        HashMap customization = new HashMap();
        for (Object composite : composites = service.getCompositionInstances()) {
            Object o = this.invokeMethod(composite, this.m_init, dm, service);
            if (o == null || !Map.class.isAssignableFrom(o.getClass())) continue;
            customization.putAll((Map)o);
        }
        Log.instance().debug("ServiceLifecycleHandler.init: invoked init method from service %s , returned map: %s", serviceInstance, customization);
        for (MetaData dependency : this.m_depsMeta) {
            String name = dependency.getString(Params.name, null);
            if (name == null) continue;
            String filter = (String)customization.get(name + ".filter");
            String required = (String)customization.get(name + ".required");
            if (filter != null || required != null) {
                dependency = (MetaData)dependency.clone();
                if (filter != null) {
                    dependency.setString(Params.filter, filter);
                }
                if (required != null) {
                    dependency.setString(Params.required, required);
                }
            }
            DependencyBuilder depBuilder = new DependencyBuilder(dependency);
            Log.instance().info("ServiceLifecycleHandler.init: adding dependency %s into service %s", dependency, this.m_srvMeta);
            Dependency d = depBuilder.build(this.m_bundle, dm, true);
            this.m_namedDeps.add(d);
        }
        if (this.m_namedDeps.size() > 0) {
            Log.instance().info("ServiceLifecycleHandler.init: adding extra/named dependencies %s", this.m_namedDeps);
            service.add(this.m_namedDeps);
        }
    }

    public void start(Component service) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] composites;
        DependencyManager dm = service.getDependencyManager();
        HashMap extraProperties = new HashMap();
        for (Object composite : composites = service.getCompositionInstances()) {
            Object o = this.invokeMethod(composite, this.m_start, dm, service);
            if (o == null || !Map.class.isAssignableFrom(o.getClass())) continue;
            extraProperties.putAll((Map)o);
        }
        if (extraProperties.size() > 0) {
            Dictionary existingProperties = service.getServiceProperties();
            if (existingProperties != null) {
                Hashtable props = new Hashtable();
                Enumeration e = existingProperties.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    props.put(key, existingProperties.get(key));
                }
                props.putAll(extraProperties);
                service.setServiceProperties(props);
            } else {
                service.setServiceProperties(new Hashtable(extraProperties));
            }
        }
        for (Dependency d : this.m_namedDeps) {
            try {
                InvocationUtil.invokeCallbackMethod(d, "setInstanceBound", new Class[][]{{Boolean.TYPE}, new Class[0]}, new Object[][]{{Boolean.FALSE}, new Object[0]});
            }
            catch (NoSuchMethodException e) {
                Log.instance().error("Lifecycle handler could not reset instanceBound of dependency: %s", e, d);
            }
        }
    }

    public void stop(Component service) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.callbackComposites(service, this.m_stop);
    }

    public void destroy(Component service) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.m_namedDeps.clear();
        if (this.m_toggle != null) {
            service.remove((Dependency)this.m_toggle);
            this.m_toggle = null;
        }
        this.callbackComposites(service, this.m_destroy);
    }

    private void callbackComposites(Component service, String callback) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] composites;
        for (Object composite : composites = service.getCompositionInstances()) {
            this.invokeMethod(composite, callback, service.getDependencyManager(), service);
        }
    }

    private Object invokeMethod(Object serviceInstance, String method, DependencyManager dm, Component service) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (method != null) {
            try {
                return InvocationUtil.invokeCallbackMethod(serviceInstance, method, new Class[][]{{Component.class}, new Class[0]}, new Object[][]{{service}, new Object[0]});
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setField(Object instance, String fieldName, Class<?> fieldClass, Object fieldValue) {
        Object serviceInstance = instance;
        Class<?> serviceClazz = serviceInstance.getClass();
        if (Proxy.isProxyClass(serviceClazz)) {
            serviceInstance = Proxy.getInvocationHandler(serviceInstance);
            serviceClazz = serviceInstance.getClass();
        }
        while (serviceClazz != null) {
            Field[] fields = serviceClazz.getDeclaredFields();
            for (int j = 0; j < fields.length; ++j) {
                Field field = fields[j];
                Class<?> type = field.getType();
                if (!field.getName().equals(fieldName) || !type.isAssignableFrom(fieldClass)) continue;
                try {
                    field.setAccessible(true);
                    Object object = SYNC;
                    synchronized (object) {
                        field.set(serviceInstance, fieldValue);
                        continue;
                    }
                }
                catch (Throwable e) {
                    throw new RuntimeException("Could not set field " + field, e);
                }
            }
            serviceClazz = serviceClazz.getSuperclass();
        }
    }

    private static class ComponentStopper
    implements Runnable {
        private final Object m_componentName;
        private final ToggleServiceDependency m_toggle;
        private final AtomicBoolean m_startFlag;

        public ComponentStopper(String componentName, ToggleServiceDependency toggle, AtomicBoolean startFlag) {
            this.m_componentName = componentName;
            this.m_toggle = toggle;
            this.m_startFlag = startFlag;
        }

        public void run() {
            if (this.m_startFlag.compareAndSet(true, false)) {
                Log.instance().debug("Lifecycle controller is deactivating the component %s", this.m_componentName);
                this.m_toggle.setAvailable(false);
            }
        }
    }

    private static class ComponentStarter
    implements Runnable {
        private final String m_componentName;
        private final ToggleServiceDependency m_toggle;
        private final AtomicBoolean m_startFlag;

        public ComponentStarter(String name, ToggleServiceDependency toggle, AtomicBoolean startFlag) {
            this.m_componentName = name;
            this.m_toggle = toggle;
            this.m_startFlag = startFlag;
        }

        public void run() {
            if (this.m_startFlag.compareAndSet(false, true)) {
                Log.instance().debug("Lifecycle controller is activating the component %s", this.m_componentName);
                this.m_toggle.setAvailable(true);
            }
        }
    }
}

