/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.AdapterServiceBuilder;
import org.apache.felix.dm.runtime.AspectServiceBuilder;
import org.apache.felix.dm.runtime.BundleAdapterServiceBuilder;
import org.apache.felix.dm.runtime.ComponentBuilder;
import org.apache.felix.dm.runtime.DescriptorParser;
import org.apache.felix.dm.runtime.FactoryConfigurationAdapterServiceBuilder;
import org.apache.felix.dm.runtime.Log;
import org.apache.felix.dm.runtime.ResourceAdapterServiceBuilder;
import org.osgi.framework.Bundle;

public class DependencyManagerRuntime {
    private ConcurrentHashMap<Bundle, DependencyManager> m_managers = new ConcurrentHashMap();
    private DescriptorParser m_parser = new DescriptorParser();

    public DependencyManagerRuntime() {
        this.m_parser.addBuilder(new ComponentBuilder());
        this.m_parser.addBuilder(new AspectServiceBuilder());
        this.m_parser.addBuilder(new AdapterServiceBuilder());
        this.m_parser.addBuilder(new BundleAdapterServiceBuilder());
        this.m_parser.addBuilder(new FactoryConfigurationAdapterServiceBuilder());
        this.m_parser.addBuilder(new ResourceAdapterServiceBuilder());
    }

    protected Object[] getComposition() {
        return new Object[]{this, Log.instance()};
    }

    protected void start() {
        Log.instance().info("Starting Dependency Manager annotation runtime", new Object[0]);
    }

    protected void stop() {
        Log.instance().info("Runtime: stopping services", new Object[0]);
        for (DependencyManager dm : this.m_managers.values()) {
            ArrayList services = new ArrayList(dm.getComponents());
            for (Component service : services) {
                dm.remove(service);
            }
        }
        this.m_managers.clear();
    }

    protected void bundleStarted(Bundle b) {
        String descriptorPaths = (String)b.getHeaders().get("DependencyManager-Component");
        if (descriptorPaths == null) {
            return;
        }
        for (String descriptorPath : descriptorPaths.split(",")) {
            URL descriptorURL = b.getEntry(descriptorPath);
            if (descriptorURL == null) {
                Log.instance().error("Runtime: DependencyManager component descriptor not found: %s", descriptorPath);
                continue;
            }
            this.loadDescriptor(b, descriptorURL);
        }
    }

    protected void bundleStopped(Bundle b) {
        Log.instance().info("Runtime: Removing services from stopping bundle: %s", b.getSymbolicName());
        DependencyManager dm = this.m_managers.remove(b);
        if (dm != null) {
            ArrayList services = new ArrayList(dm.getComponents());
            for (Component service : services) {
                Log.instance().info("Runtime: Removing service: %s", service);
                dm.remove(service);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDescriptor(Bundle b, URL descriptorURL) {
        Log.instance().debug("Runtime: ++++ Parsing descriptor %s from bundle %s", descriptorURL, b.getSymbolicName());
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(descriptorURL.openStream()));
            DependencyManager dm = this.m_managers.get(b);
            if (dm == null) {
                dm = new DependencyManager(b.getBundleContext());
                this.m_managers.put(b, dm);
            }
            this.m_parser.parse(in, b, dm);
            this.m_managers.put(b, dm);
        }
        catch (Throwable t) {
            Log.instance().error("Runtime: Error while parsing descriptor %s from bundle %s", t, descriptorURL, b.getSymbolicName());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
    }
}

