/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.runtime;

import java.util.Dictionary;
import java.util.List;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.runtime.AbstractBuilder;
import org.apache.felix.dm.runtime.MetaData;
import org.apache.felix.dm.runtime.Params;
import org.apache.felix.dm.runtime.ServiceLifecycleHandler;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryConfigurationAdapterServiceBuilder
extends AbstractBuilder {
    private static final String TYPE = "FactoryConfigurationAdapterService";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void build(MetaData srvMeta, List<MetaData> depsMeta, Bundle b, DependencyManager dm) throws Exception {
        Class implClass = b.loadClass(srvMeta.getString(Params.impl));
        String factoryPid = srvMeta.getString(Params.factoryPid);
        String updated = srvMeta.getString(Params.updated);
        String[] provides = srvMeta.getStrings(Params.provides, null);
        Dictionary<String, Object> properties = srvMeta.getDictionary(Params.properties, null);
        boolean propagate = "true".equals(srvMeta.getString(Params.propagate, "false"));
        Component c = dm.createFactoryConfigurationAdapterService(factoryPid, updated, propagate);
        c.setInterface(provides, properties);
        String factoryMethod = srvMeta.getString(Params.factoryMethod, null);
        if (factoryMethod == null) {
            c.setImplementation((Object)implClass);
        } else {
            c.setFactory((Object)implClass, factoryMethod);
        }
        this.setCommonServiceParams(c, srvMeta);
        c.setComposition(srvMeta.getString(Params.composition, null));
        ServiceLifecycleHandler lfcleHandler = new ServiceLifecycleHandler(c, b, dm, srvMeta, depsMeta);
        c.setCallbacks((Object)lfcleHandler, "init", "start", "stop", "destroy");
        FactoryConfigurationAdapterServiceBuilder.addUnamedDependencies(b, dm, c, srvMeta, depsMeta);
        dm.add(c);
    }
}

