/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dependencymanager.shell;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.felix.dependencymanager.ServiceComponent;
import org.apache.felix.dependencymanager.ServiceComponentDependency;
import org.apache.felix.dependencymanager.shell.BundleIdSorter;
import org.apache.felix.shell.Command;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class DMCommand
implements Command {
    private static final BundleIdSorter SORTER = new BundleIdSorter();
    private final BundleContext m_context;
    static /* synthetic */ Class class$org$apache$felix$dependencymanager$ServiceComponent;

    public DMCommand(BundleContext context) {
        this.m_context = context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(String line, PrintStream out, PrintStream err) {
        boolean nodeps = false;
        boolean notavail = false;
        boolean compact = false;
        ArrayList<Long> ids = new ArrayList<Long>();
        StringTokenizer st = new StringTokenizer(line);
        if (st.hasMoreTokens()) {
            st.nextToken();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("nodeps".equals(token)) {
                    nodeps = true;
                    continue;
                }
                if ("notavail".equals(token)) {
                    notavail = true;
                    continue;
                }
                if ("compact".equals(token)) {
                    compact = true;
                    continue;
                }
                try {
                    ids.add(Long.valueOf(token));
                }
                catch (NumberFormatException e) {
                    err.println("Argument " + token + " is not a valid number.");
                    return;
                }
            }
            try {
                ServiceReference[] references = this.m_context.getServiceReferences((class$org$apache$felix$dependencymanager$ServiceComponent == null ? (class$org$apache$felix$dependencymanager$ServiceComponent = DMCommand.class$("org.apache.felix.dependencymanager.ServiceComponent")) : class$org$apache$felix$dependencymanager$ServiceComponent).getName(), null);
                if (references == null) return;
                Arrays.sort(references, SORTER);
                long lastBundleId = -1L;
                for (int i = 0; i < references.length; ++i) {
                    ServiceReference ref = references[i];
                    ServiceComponent sc = (ServiceComponent)this.m_context.getService(ref);
                    if (sc == null) continue;
                    String name = sc.getName();
                    int state = sc.getState();
                    Bundle bundle = ref.getBundle();
                    long bundleId = bundle.getBundleId();
                    if ((ids.size() == 0 || ids.contains(bundleId)) && (!notavail || notavail && sc.getState() == 0)) {
                        ServiceComponentDependency[] dependencies;
                        if (lastBundleId != bundleId) {
                            lastBundleId = bundleId;
                            if (compact) {
                                out.println("[" + bundleId + "] " + this.compactName(bundle.getSymbolicName()));
                            } else {
                                out.println("[" + bundleId + "] " + bundle.getSymbolicName());
                            }
                        }
                        if (compact) {
                            out.print(" " + this.compactName(name) + " " + this.compactState(ServiceComponent.STATE_NAMES[state]));
                        } else {
                            out.println("  " + name + " " + ServiceComponent.STATE_NAMES[state]);
                        }
                        if (!nodeps && (dependencies = sc.getComponentDependencies()) != null && dependencies.length > 0) {
                            if (compact) {
                                out.print('(');
                            }
                            for (int j = 0; j < dependencies.length; ++j) {
                                ServiceComponentDependency dep = dependencies[j];
                                String depName = dep.getName();
                                String depType = dep.getType();
                                int depState = dep.getState();
                                if (compact) {
                                    if (j > 0) {
                                        out.print(' ');
                                    }
                                    out.print(this.compactName(depName) + " " + this.compactState(depType) + " " + this.compactState(ServiceComponentDependency.STATE_NAMES[depState]));
                                    continue;
                                }
                                out.println("    " + depName + " " + depType + " " + ServiceComponentDependency.STATE_NAMES[depState]);
                            }
                            if (compact) {
                                out.print(')');
                            }
                        }
                        if (compact) {
                            out.println();
                        }
                    }
                    this.m_context.ungetService(ref);
                }
                return;
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace(err);
                return;
            }
        } else {
            err.println("Invalid command line: " + line);
        }
    }

    private String compactState(String input) {
        StringBuffer output = new StringBuffer();
        StringTokenizer st = new StringTokenizer(input);
        while (st.hasMoreTokens()) {
            output.append(st.nextToken().toUpperCase().charAt(0));
        }
        return output.toString();
    }

    private String compactName(String input) {
        StringBuffer output = new StringBuffer();
        int lastIndex = 0;
        block4: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '.': {
                    output.append(input.charAt(lastIndex));
                    output.append('.');
                    lastIndex = i + 1;
                    continue block4;
                }
                case ' ': 
                case ',': {
                    if (lastIndex < i) {
                        output.append(input.substring(lastIndex, i));
                    }
                    output.append(c);
                    lastIndex = i + 1;
                }
            }
        }
        if (lastIndex < input.length()) {
            output.append(input.substring(lastIndex));
        }
        return output.toString();
    }

    public String getName() {
        return "dm";
    }

    public String getShortDescription() {
        return "list dependency manager component diagnostics.";
    }

    public String getUsage() {
        return "dm [nodeps] [notavail] [compact] [<bundleid> ...]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

