/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.shell;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.DependencyManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DMCommand {
    private final BundleContext m_context;
    private static final DependencyManagerSorter SORTER = new DependencyManagerSorter();

    public DMCommand(BundleContext context) {
        this.m_context = context;
    }

    public void execute(String line, PrintStream out, PrintStream err) {
        boolean nodeps = false;
        boolean notavail = false;
        boolean compact = false;
        boolean stats = false;
        ArrayList<Long> ids = new ArrayList<Long>();
        StringTokenizer st = new StringTokenizer(line);
        if (st.hasMoreTokens()) {
            st.nextToken();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("nodeps".equals(token)) {
                    nodeps = true;
                    continue;
                }
                if ("notavail".equals(token)) {
                    notavail = true;
                    continue;
                }
                if ("compact".equals(token)) {
                    compact = true;
                    continue;
                }
                if ("stats".equals(token)) {
                    stats = true;
                    continue;
                }
                try {
                    ids.add(Long.valueOf(token));
                }
                catch (NumberFormatException e) {
                    err.println("Argument " + token + " is not a valid number.");
                    return;
                }
            }
            List managers = DependencyManager.getDependencyManagers();
            Collections.sort(managers, SORTER);
            Iterator iterator = managers.iterator();
            long numberOfComponents = 0L;
            long numberOfDependencies = 0L;
            long lastBundleId = -1L;
            while (iterator.hasNext()) {
                DependencyManager manager = (DependencyManager)iterator.next();
                List components = manager.getComponents();
                Iterator componentIterator = components.iterator();
                while (componentIterator.hasNext()) {
                    Component component = (Component)componentIterator.next();
                    ComponentDeclaration sc = (ComponentDeclaration)component;
                    String name = sc.getName();
                    int state = sc.getState();
                    Bundle bundle = sc.getBundleContext().getBundle();
                    long bundleId = bundle.getBundleId();
                    if (ids.size() != 0 && !ids.contains(bundleId) || notavail && (!notavail || sc.getState() != 0)) continue;
                    ++numberOfComponents;
                    if (lastBundleId != bundleId) {
                        lastBundleId = bundleId;
                        if (compact) {
                            out.println("[" + bundleId + "] " + this.compactName(bundle.getSymbolicName()));
                        } else {
                            out.println("[" + bundleId + "] " + bundle.getSymbolicName());
                        }
                    }
                    if (compact) {
                        out.print(" " + this.compactName(name) + " " + this.compactState(ComponentDeclaration.STATE_NAMES[state]));
                    } else {
                        out.println("  " + name + " " + ComponentDeclaration.STATE_NAMES[state]);
                    }
                    if (!nodeps) {
                        ComponentDependencyDeclaration[] dependencies = sc.getComponentDependencies();
                        numberOfDependencies += (long)dependencies.length;
                        if (dependencies != null && dependencies.length > 0) {
                            if (compact) {
                                out.print('(');
                            }
                            for (int j = 0; j < dependencies.length; ++j) {
                                ComponentDependencyDeclaration dep = dependencies[j];
                                String depName = dep.getName();
                                String depType = dep.getType();
                                int depState = dep.getState();
                                if (compact) {
                                    if (j > 0) {
                                        out.print(' ');
                                    }
                                    out.print(this.compactName(depName) + " " + this.compactState(depType) + " " + this.compactState(ComponentDependencyDeclaration.STATE_NAMES[depState]));
                                    continue;
                                }
                                out.println("    " + depName + " " + depType + " " + ComponentDependencyDeclaration.STATE_NAMES[depState]);
                            }
                            if (compact) {
                                out.print(')');
                            }
                        }
                    }
                    if (!compact) continue;
                    out.println();
                }
            }
            if (stats) {
                out.println("Statistics:");
                out.println(" - Dependency managers: " + managers.size());
                out.println(" - Components: " + numberOfComponents);
                if (!nodeps) {
                    out.println(" - Dependencies: " + numberOfDependencies);
                }
            }
        } else {
            err.println("Invalid command line: " + line);
        }
    }

    private String compactState(String input) {
        StringBuffer output = new StringBuffer();
        StringTokenizer st = new StringTokenizer(input);
        while (st.hasMoreTokens()) {
            output.append(st.nextToken().toUpperCase().charAt(0));
        }
        return output.toString();
    }

    private String compactName(String input) {
        StringBuffer output = new StringBuffer();
        int lastIndex = 0;
        block4: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '.': {
                    output.append(input.charAt(lastIndex));
                    output.append('.');
                    lastIndex = i + 1;
                    continue block4;
                }
                case ' ': 
                case ',': {
                    if (lastIndex < i) {
                        output.append(input.substring(lastIndex, i));
                    }
                    output.append(c);
                    lastIndex = i + 1;
                }
            }
        }
        if (lastIndex < input.length()) {
            output.append(input.substring(lastIndex));
        }
        return output.toString();
    }

    public String getName() {
        return "dm";
    }

    public String getShortDescription() {
        return "list dependency manager component diagnostics.";
    }

    public String getUsage() {
        return "dm [nodeps] [notavail] [compact] [stats] [<bundleid> ...]";
    }

    public static class DependencyManagerSorter
    implements Comparator {
        public int compare(Object o1, Object o2) {
            long id2;
            DependencyManager dm1 = (DependencyManager)o1;
            DependencyManager dm2 = (DependencyManager)o2;
            long id1 = dm1.getBundleContext().getBundle().getBundleId();
            return id1 > (id2 = dm2.getBundleContext().getBundle().getBundleId()) ? 1 : -1;
        }
    }
}

