/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype.internal;

import org.apache.felix.metatype.internal.Activator;
import org.apache.felix.metatype.internal.MetaTypeInformationImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.metatype.MetaTypeProvider;

public class ServiceMetaTypeInformation
extends MetaTypeInformationImpl
implements ServiceListener {
    private static final String FILTER = "(|(objectClass=org.osgi.service.cm.ManagedService)(objectClass=org.osgi.service.cm.ManagedServiceFactory))";
    private final BundleContext bundleContext;

    public ServiceMetaTypeInformation(BundleContext bundleContext, Bundle bundle) {
        super(bundle);
        Filter filter;
        this.bundleContext = bundleContext;
        try {
            bundleContext.addServiceListener((ServiceListener)this, FILTER);
        }
        catch (InvalidSyntaxException ise) {
            Activator.log(1, "ServiceMetaTypeInformation: Cannot register for service events", ise);
        }
        try {
            filter = bundleContext.createFilter(FILTER);
        }
        catch (InvalidSyntaxException ise) {
            Activator.log(1, "ServiceMetaTypeInformation: Cannot create filter '(|(objectClass=org.osgi.service.cm.ManagedService)(objectClass=org.osgi.service.cm.ManagedServiceFactory))'", ise);
            return;
        }
        ServiceReference[] sr = bundle.getRegisteredServices();
        if (sr != null) {
            for (int i = 0; i < sr.length; ++i) {
                if (!filter.match(sr[i])) continue;
                this.addService(sr[i]);
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (!this.getBundle().equals(event.getServiceReference().getBundle())) {
            return;
        }
        if (event.getType() == 1) {
            this.addService(event.getServiceReference());
        } else if (event.getType() == 4) {
            this.removeService(event.getServiceReference());
        }
    }

    protected void addService(ServiceReference serviceRef) {
        Object srv = this.bundleContext.getService(serviceRef);
        boolean ungetService = true;
        if (srv instanceof MetaTypeProvider) {
            MetaTypeProvider mtp = (MetaTypeProvider)srv;
            String factoryPid = (String)serviceRef.getProperty("service.factoryPid");
            if (factoryPid != null) {
                this.addFactoryPids(new String[]{factoryPid});
                this.addMetaTypeProvider(factoryPid, mtp);
                ungetService = false;
            } else {
                String pid = (String)serviceRef.getProperty("service.pid");
                if (pid != null) {
                    this.addPids(new String[]{pid});
                    this.addMetaTypeProvider(pid, mtp);
                    ungetService = false;
                }
            }
        }
        if (ungetService) {
            this.bundleContext.ungetService(serviceRef);
        }
    }

    protected void removeService(ServiceReference serviceRef) {
        boolean ungetService = false;
        String factoryPid = (String)serviceRef.getProperty("service.factoryPid");
        if (factoryPid != null) {
            ungetService = this.removeMetaTypeProvider(factoryPid) != null;
            this.removeFactoryPid(factoryPid);
        } else {
            String pid = (String)serviceRef.getProperty("service.pid");
            if (pid != null) {
                ungetService = this.removeMetaTypeProvider(pid) != null;
                this.removePid(pid);
            }
        }
        if (ungetService) {
            this.bundleContext.ungetService(serviceRef);
        }
    }
}

