/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deployment.rp.autoconf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistencyManager {
    private final File m_root;

    public PersistencyManager(File root) {
        this.m_root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String name, List configs) throws IOException {
        if (configs.isEmpty()) {
            return;
        }
        File targetDir = this.m_root;
        if ((name = name.replace('/', File.separatorChar)).startsWith(File.separator)) {
            name = name.substring(1);
        }
        int lastSeparator = name.lastIndexOf(File.separator);
        File target = null;
        if (lastSeparator != -1) {
            targetDir = new File(targetDir, name.substring(0, lastSeparator));
            targetDir.mkdirs();
        }
        target = new File(targetDir, name.substring(lastSeparator + 1));
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new FileOutputStream(target));
            out.writeObject(configs);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void delete(String name) throws IOException {
        File target = new File(this.m_root, name = name.replace('/', File.separatorChar));
        if (!target.delete()) {
            throw new IOException("Unable to delete file: " + target.getAbsolutePath());
        }
        while (target.getParentFile().list().length == 0 && !target.getParentFile().getAbsolutePath().equals(this.m_root.getAbsolutePath())) {
            target = target.getParentFile();
            target.delete();
        }
    }

    public List load(String name) throws IOException {
        name = name.replace('/', File.separatorChar);
        List resources = new ArrayList();
        File resourcesFile = new File(this.m_root, name);
        if (resourcesFile.exists()) {
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new FileInputStream(resourcesFile));
                resources = (List)in.readObject();
            }
            catch (FileNotFoundException fnfe) {
                throw new IOException("Resource does not exist: " + name);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IOException("Unable to recreate persisted object from file: " + name);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return resources;
    }

    public Map loadAll() throws IOException {
        return new HashMap();
    }
}

