/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deployment.rp.autoconf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.felix.deployment.rp.autoconf.AutoConfResource;
import org.apache.felix.deployment.rp.autoconf.ConfigurationAdminTask;
import org.apache.felix.deployment.rp.autoconf.DeleteResourceTask;
import org.apache.felix.deployment.rp.autoconf.DropResourceTask;
import org.apache.felix.deployment.rp.autoconf.InstallOrUpdateResourceTask;
import org.apache.felix.deployment.rp.autoconf.ObjectClassDefinitionImpl;
import org.apache.felix.deployment.rp.autoconf.PersistencyManager;
import org.apache.felix.deployment.rp.autoconf.PostCommitTask;
import org.apache.felix.deployment.rp.autoconf.StoreResourceTask;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.metatype.Attribute;
import org.apache.felix.metatype.Designate;
import org.apache.felix.metatype.MetaData;
import org.apache.felix.metatype.MetaDataReader;
import org.apache.felix.metatype.OCD;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.deploymentadmin.spi.DeploymentSession;
import org.osgi.service.deploymentadmin.spi.ResourceProcessor;
import org.osgi.service.deploymentadmin.spi.ResourceProcessorException;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.LogService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

public class AutoConfResourceProcessor
implements ResourceProcessor,
EventHandler {
    private static final String LOCATION_PREFIX = "osgi-dp:";
    public static final String CONFIGURATION_ADMIN_FILTER_ATTRIBUTE = "filter";
    private volatile LogService m_log;
    private volatile ConfigurationAdmin m_configAdmin;
    private volatile MetaTypeService m_metaService;
    private volatile BundleContext m_bc;
    private volatile DependencyManager m_dm;
    private Component m_component;
    private final Object LOCK = new Object();
    private DeploymentSession m_session = null;
    private final Map m_toBeInstalled = new HashMap();
    private final Map m_toBeDeleted = new HashMap();
    private PersistencyManager m_persistencyManager;
    private List m_configurationAdminTasks = new ArrayList();
    private List m_postCommitTasks = new ArrayList();
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationAdmin;
    static /* synthetic */ Class class$org$apache$felix$dm$Component;
    static /* synthetic */ Class class$org$osgi$service$event$EventHandler;

    public void start() throws IOException {
        File root = this.m_bc.getDataFile("");
        if (root == null) {
            throw new IOException("No file system support");
        }
        this.m_persistencyManager = new PersistencyManager(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(DeploymentSession session) {
        this.m_log.log(4, "beginning session " + session);
        Object object = this.LOCK;
        synchronized (object) {
            if (this.m_session != null) {
                throw new IllegalArgumentException("Trying to begin new deployment session while already in one.");
            }
            if (session == null) {
                throw new IllegalArgumentException("Trying to begin new deployment session with a null session.");
            }
            if (this.m_toBeInstalled.size() > 0 || this.m_toBeDeleted.size() > 0 || this.m_configurationAdminTasks.size() > 0 || this.m_postCommitTasks.size() > 0 || this.m_component != null) {
                throw new IllegalStateException("State not reset correctly at start of session.");
            }
            this.m_session = session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String name, InputStream stream) throws ResourceProcessorException {
        Map designates;
        this.m_log.log(4, "processing " + name);
        Object object = this.LOCK;
        synchronized (object) {
            if (this.m_session == null) {
                throw new ResourceProcessorException(463, "Can not process resource without a Deployment Session");
            }
        }
        MetaDataReader reader = new MetaDataReader();
        MetaData data = null;
        try {
            data = reader.parse(stream);
        }
        catch (IOException e) {
            throw new ResourceProcessorException(463, "Unable to process resource.", e);
        }
        if (data == null) {
            throw new ResourceProcessorException(463, "Supplied configuration is not conform the metatype xml specification.");
        }
        String filter = null;
        Map optionalAttributes = data.getOptionalAttributes();
        if (optionalAttributes != null) {
            filter = (String)optionalAttributes.get(CONFIGURATION_ADMIN_FILTER_ATTRIBUTE);
        }
        if (!this.m_toBeInstalled.containsKey(name)) {
            this.m_toBeInstalled.put(name, new ArrayList());
        }
        if ((designates = data.getDesignates()) == null) {
            this.m_log.log(3, "No designates found in the resource, so there's nothing to process.");
            return;
        }
        Map localOcds = data.getObjectClassDefinitions();
        if (localOcds == null) {
            localOcds = Collections.EMPTY_MAP;
        }
        Iterator i = designates.keySet().iterator();
        while (i.hasNext()) {
            Designate designate = (Designate)designates.get(i.next());
            if (designate.getObject() == null) {
                throw new ResourceProcessorException(463, "Designate Object child missing or invalid");
            }
            if (designate.getObject().getAttributes() == null || designate.getObject().getAttributes().size() == 0) {
                throw new ResourceProcessorException(463, "Object Attributes child missing or invalid");
            }
            String ocdRef = designate.getObject().getOcdRef();
            if (ocdRef == null || "".equals(ocdRef)) {
                throw new ResourceProcessorException(463, "Object ocdRef attribute missing or invalid");
            }
            ObjectClassDefinition ocd = null;
            OCD localOcd = (OCD)localOcds.get(ocdRef);
            ObjectClassDefinition objectClassDefinition = ocd = localOcd != null ? new ObjectClassDefinitionImpl(localOcd) : this.getMetaTypeOCD(data, designate);
            if (ocd == null) {
                throw new ResourceProcessorException(463, "No Object Class Definition found with id=" + ocdRef);
            }
            Dictionary dict = this.getProperties(designate, ocd);
            if (dict == null) continue;
            List resources = (List)this.m_toBeInstalled.get(name);
            resources.add(new AutoConfResource(name, designate.getPid(), designate.getFactoryPid(), designate.getBundleLocation(), designate.isMerge(), dict, filter));
        }
        this.m_log.log(4, "processing " + name + " done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropped(String name) throws ResourceProcessorException {
        this.m_log.log(4, "dropped " + name);
        Object object = this.LOCK;
        synchronized (object) {
            if (this.m_session == null) {
                throw new ResourceProcessorException(463, "Can not process resource without a Deployment Session");
            }
        }
        try {
            List resources = this.m_persistencyManager.load(name);
            if (!this.m_toBeDeleted.containsKey(name)) {
                this.m_toBeDeleted.put(name, new ArrayList());
            }
            ((List)this.m_toBeDeleted.get(name)).addAll(resources);
        }
        catch (IOException ioe) {
            throw new ResourceProcessorException(463, "Unable to drop resource: " + name, ioe);
        }
        this.m_log.log(4, "dropped " + name + " done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropAllResources() throws ResourceProcessorException {
        this.m_log.log(4, "drop all resources");
        Object object = this.LOCK;
        synchronized (object) {
            if (this.m_session == null) {
                throw new ResourceProcessorException(463, "Can not drop all resources without a Deployment Session");
            }
        }
        File basedir = this.m_bc.getDataFile("");
        if (basedir != null && basedir.isDirectory()) {
            String[] files = basedir.list();
            for (int i = 0; i < files.length; ++i) {
                this.dropped(files[i]);
            }
        } else {
            throw new ResourceProcessorException(463, "Unable to drop resources, data area is not accessible");
        }
        this.m_log.log(4, "drop all resources done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws ResourceProcessorException {
        this.m_log.log(4, "prepare");
        Object object = this.LOCK;
        synchronized (object) {
            if (this.m_session == null) {
                throw new ResourceProcessorException(463, "Can not process resource without a Deployment Session");
            }
        }
        try {
            String name;
            this.m_log.log(4, "prepare delete");
            Iterator i = this.m_toBeDeleted.keySet().iterator();
            while (i.hasNext()) {
                name = (String)i.next();
                List resources = (List)this.m_toBeDeleted.get(name);
                Iterator j = resources.iterator();
                while (j.hasNext()) {
                    AutoConfResource resource = (AutoConfResource)j.next();
                    this.m_configurationAdminTasks.add(new DropResourceTask(resource));
                }
                this.m_postCommitTasks.add(new DeleteResourceTask(name));
            }
            this.m_log.log(4, "prepare install/update");
            Iterator j = this.m_toBeInstalled.keySet().iterator();
            while (j.hasNext()) {
                name = (String)j.next();
                List existingResources = null;
                try {
                    existingResources = this.m_persistencyManager.load(name);
                }
                catch (IOException ioe) {
                    throw new ResourceProcessorException(1, "Unable to read existing resources for resource " + name, ioe);
                }
                List resources = (List)this.m_toBeInstalled.get(name);
                Iterator iterator = resources.iterator();
                while (iterator.hasNext()) {
                    AutoConfResource resource = (AutoConfResource)iterator.next();
                    this.m_configurationAdminTasks.add(new InstallOrUpdateResourceTask(resource));
                }
                Iterator i2 = existingResources.iterator();
                while (i2.hasNext()) {
                    AutoConfResource existingResource = (AutoConfResource)i2.next();
                    Configuration configuration = null;
                    configuration = existingResource.isFactoryConfig() ? this.m_configAdmin.getConfiguration(existingResource.getGeneratedPid(), existingResource.getBundleLocation()) : this.m_configAdmin.getConfiguration(existingResource.getPid(), existingResource.getBundleLocation());
                    configuration.delete();
                }
                this.m_postCommitTasks.add(new StoreResourceTask(name, resources));
            }
        }
        catch (IOException ioe) {
            this.m_toBeInstalled.clear();
            throw new ResourceProcessorException(1, "Unable to prepare for commit for resource", ioe);
        }
        this.m_log.log(4, "prepare done");
    }

    public synchronized void commit() {
        this.m_log.log(4, "commit");
        Properties properties = new Properties();
        ((Dictionary)properties).put("event.topics", "org/osgi/service/deployment/COMPLETE");
        this.m_component = this.m_dm.createComponent().setInterface((class$org$osgi$service$event$EventHandler == null ? (class$org$osgi$service$event$EventHandler = AutoConfResourceProcessor.class$("org.osgi.service.event.EventHandler")) : class$org$osgi$service$event$EventHandler).getName(), (Dictionary)properties).setImplementation((Object)this).setCallbacks(null, null, null, null).setAutoConfig(class$org$apache$felix$dm$Component == null ? (class$org$apache$felix$dm$Component = AutoConfResourceProcessor.class$("org.apache.felix.dm.Component")) : class$org$apache$felix$dm$Component, false).add((Dependency)this.m_dm.createServiceDependency().setService(class$org$osgi$service$cm$ConfigurationAdmin == null ? (class$org$osgi$service$cm$ConfigurationAdmin = AutoConfResourceProcessor.class$("org.osgi.service.cm.ConfigurationAdmin")) : class$org$osgi$service$cm$ConfigurationAdmin).setCallbacks("addConfigurationAdmin", null).setRequired(false));
        this.m_dm.add(this.m_component);
        this.m_log.log(4, "commit done");
    }

    public void addConfigurationAdmin(ServiceReference ref, ConfigurationAdmin ca) {
        this.m_log.log(4, "found configuration admin " + ref);
        Iterator iterator = this.m_configurationAdminTasks.iterator();
        while (iterator.hasNext()) {
            ConfigurationAdminTask task = (ConfigurationAdminTask)iterator.next();
            try {
                Filter filter = null;
                String filterString = task.getFilter();
                if (filterString != null) {
                    try {
                        filter = this.m_bc.createFilter(filterString);
                    }
                    catch (InvalidSyntaxException e) {
                        this.m_log.log(1, "Could not parse filter, ignoring it: " + filterString, (Throwable)e);
                    }
                }
                if (filter != null && (filter == null || !filter.match(ref))) continue;
                task.run(this.m_persistencyManager, ca);
            }
            catch (Exception e) {
                this.m_log.log(1, "Exception during configuration to " + ca + ". Trying to continue.", (Throwable)e);
            }
        }
        this.m_log.log(4, "found configuration admin " + ref + " done");
    }

    public void postcommit() {
        this.m_log.log(4, "post commit");
        Iterator iterator = this.m_postCommitTasks.iterator();
        while (iterator.hasNext()) {
            PostCommitTask task = (PostCommitTask)iterator.next();
            try {
                task.run(this.m_persistencyManager);
            }
            catch (Exception e) {
                this.m_log.log(1, "Exception during post commit wrap-up. Trying to continue.", (Throwable)e);
            }
        }
        this.endSession();
        this.m_log.log(4, "post commit done");
    }

    private void endSession() {
        if (this.m_component != null) {
            this.m_dm.remove(this.m_component);
            this.m_component = null;
        }
        this.m_toBeInstalled.clear();
        this.m_toBeDeleted.clear();
        this.m_postCommitTasks.clear();
        this.m_configurationAdminTasks.clear();
        this.m_session = null;
    }

    public void rollback() {
        this.m_log.log(4, "rollback");
        Set keys = this.m_toBeInstalled.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            List configs = (List)this.m_toBeInstalled.get(i.next());
            Iterator j = configs.iterator();
            if (!j.hasNext()) continue;
            AutoConfResource resource = (AutoConfResource)j.next();
            String name = resource.getName();
            try {
                this.dropped(name);
            }
            catch (ResourceProcessorException e) {
                this.m_log.log(1, "Unable to roll back resource '" + name + "', reason: " + e.getMessage() + ", caused by: " + e.getCause().getMessage());
            }
        }
        this.endSession();
        this.m_log.log(4, "rollback done");
    }

    public void cancel() {
        this.m_log.log(4, "cancel");
        this.rollback();
    }

    private Dictionary getProperties(Designate designate, ObjectClassDefinition ocd) throws ResourceProcessorException {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        AttributeDefinition[] attributeDefs = ocd.getAttributeDefinitions(-1);
        List attributes = designate.getObject().getAttributes();
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            String adRef = attribute.getAdRef();
            boolean found = false;
            for (int j = 0; j < attributeDefs.length; ++j) {
                AttributeDefinition ad = attributeDefs[j];
                if (!adRef.equals(ad.getID())) continue;
                Object value = this.getValue(attribute, ad);
                if (value == null) {
                    if (designate.isOptional()) {
                        properties = null;
                        break;
                    }
                    throw new ResourceProcessorException(463, "Could not match attribute to it's definition: adref=" + adRef);
                }
                ((Dictionary)properties).put(adRef, value);
                found = true;
                break;
            }
            if (found) continue;
            if (designate.isOptional()) {
                properties = null;
                break;
            }
            throw new ResourceProcessorException(463, "Could not find attribute definition: adref=" + adRef);
        }
        return properties;
    }

    private ObjectClassDefinition getMetaTypeOCD(MetaData data, Designate designate) throws ResourceProcessorException {
        MetaTypeInformation mti;
        ObjectClassDefinition ocd = null;
        String ocdRef = designate.getObject().getOcdRef();
        Bundle bundle = this.getBundle(designate.getBundleLocation(), this.isFactoryConfig(designate));
        if (bundle != null && (mti = this.m_metaService.getMetaTypeInformation(bundle)) != null) {
            String pid;
            pid = this.isFactoryConfig(designate) ? (pid = designate.getFactoryPid()) : designate.getPid();
            try {
                ObjectClassDefinition tempOcd = mti.getObjectClassDefinition(pid, null);
                if (ocdRef.equals(tempOcd.getID())) {
                    ocd = tempOcd;
                }
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        return ocd;
    }

    private boolean isFactoryConfig(Designate designate) {
        String factoryPid = designate.getFactoryPid();
        return factoryPid != null && !"".equals(factoryPid);
    }

    private Bundle getBundle(String bundleLocation, boolean isFactory) throws ResourceProcessorException {
        Bundle bundle;
        block2: {
            block1: {
                bundle = null;
                if (isFactory) break block1;
                if (!bundleLocation.startsWith(LOCATION_PREFIX)) break block2;
                bundle = this.m_session.getSourceDeploymentPackage().getBundle(bundleLocation.substring(LOCATION_PREFIX.length()));
                break block2;
            }
            Bundle[] bundles = this.m_bc.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                String location = bundles[i].getLocation();
                if (!bundleLocation.equals(location)) continue;
                bundle = bundles[i];
                break;
            }
        }
        return bundle;
    }

    private Object getValue(Attribute attribute, AttributeDefinition ad) {
        if (attribute == null || ad == null || !attribute.getAdRef().equals(ad.getID())) {
            return null;
        }
        String[] content = attribute.getContent();
        int type = ad.getType();
        Boolean[] typedContent = null;
        try {
            block13: for (int i = 0; i < content.length; ++i) {
                String value = content[i];
                switch (type) {
                    case 11: {
                        typedContent = typedContent == null ? new Boolean[content.length] : typedContent;
                        typedContent[i] = Boolean.valueOf(value);
                        continue block13;
                    }
                    case 6: {
                        typedContent = typedContent == null ? new Byte[content.length] : typedContent;
                        typedContent[i] = Byte.valueOf(value);
                        continue block13;
                    }
                    case 5: {
                        typedContent = typedContent == null ? new Character[content.length] : typedContent;
                        char[] charArray = value.toCharArray();
                        if (charArray.length == 1) {
                            typedContent[i] = new Character(charArray[0]);
                            continue block13;
                        }
                        return null;
                    }
                    case 7: {
                        typedContent = typedContent == null ? new Double[content.length] : typedContent;
                        typedContent[i] = Double.valueOf(value);
                        continue block13;
                    }
                    case 8: {
                        typedContent = typedContent == null ? new Float[content.length] : typedContent;
                        typedContent[i] = Float.valueOf(value);
                        continue block13;
                    }
                    case 3: {
                        typedContent = typedContent == null ? new Integer[content.length] : typedContent;
                        typedContent[i] = Integer.valueOf(value);
                        continue block13;
                    }
                    case 2: {
                        typedContent = typedContent == null ? new Long[content.length] : typedContent;
                        typedContent[i] = Long.valueOf(value);
                        continue block13;
                    }
                    case 4: {
                        typedContent = typedContent == null ? new Short[content.length] : typedContent;
                        typedContent[i] = Short.valueOf(value);
                        continue block13;
                    }
                    case 1: {
                        typedContent = typedContent == null ? new String[content.length] : typedContent;
                        typedContent[i] = value;
                        continue block13;
                    }
                    default: {
                        return null;
                    }
                }
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        int cardinality = ad.getCardinality();
        Object result = null;
        if (cardinality == 0) {
            result = typedContent.length == 1 ? typedContent[0] : null;
        } else if (cardinality == Integer.MIN_VALUE) {
            result = new Vector<Boolean>(Arrays.asList(typedContent));
        } else if (cardinality == Integer.MAX_VALUE) {
            result = typedContent;
        } else if (cardinality < 0) {
            result = typedContent.length <= Math.abs(cardinality) ? new Vector<Boolean>(Arrays.asList(typedContent)) : null;
        } else if (cardinality > 0) {
            result = typedContent.length <= cardinality ? typedContent : null;
        }
        return result;
    }

    public void handleEvent(Event event) {
        this.postcommit();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

