/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Manifest;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.DeploymentPackageManifest;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.apache.felix.deploymentadmin.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentException;
import org.osgi.service.deploymentadmin.DeploymentPackage;

public abstract class AbstractDeploymentPackage
implements DeploymentPackage {
    private final BundleContext m_bundleContext;
    private final DeploymentPackageManifest m_manifest;
    private final Map m_nameToBundleInfo = new HashMap();
    private final Map m_pathToEntry = new HashMap();
    private final BundleInfoImpl[] m_bundleInfos;
    private final ResourceInfoImpl[] m_resourceInfos;
    private final String[] m_resourcePaths;
    private final boolean m_isFixPackage;
    protected static final AbstractDeploymentPackage emptyPackage = new AbstractDeploymentPackage(){

        public String getHeader(String header) {
            if ("DeploymentPackage-SymbolicName".equals(header)) {
                return "";
            }
            if ("DeploymentPackage-Version".equals(header)) {
                return Version.emptyVersion.toString();
            }
            return null;
        }

        public Bundle getBundle(String symbolicName) {
            return null;
        }

        public BundleInfo[] getBundleInfos() {
            return new BundleInfoImpl[0];
        }

        public BundleInfoImpl[] getBundleInfoImpls() {
            return new BundleInfoImpl[0];
        }

        public String getName() {
            return "";
        }

        public String getResourceHeader(String resource, String header) {
            return null;
        }

        public ServiceReference getResourceProcessor(String resource) {
            return null;
        }

        public String[] getResources() {
            return new String[0];
        }

        public Version getVersion() {
            return Version.emptyVersion;
        }

        public boolean isStale() {
            return true;
        }

        public void uninstall() throws DeploymentException {
            throw new IllegalStateException("Can not uninstall stale DeploymentPackage");
        }

        public boolean uninstallForced() throws DeploymentException {
            throw new IllegalStateException("Can not uninstall stale DeploymentPackage");
        }

        public InputStream getBundleStream(String symbolicName) throws IOException {
            return null;
        }

        public BundleInfoImpl[] getOrderedBundleInfos() {
            return new BundleInfoImpl[0];
        }

        public ResourceInfoImpl[] getOrderedResourceInfos() {
            return new ResourceInfoImpl[0];
        }

        public InputStream getCurrentEntryStream() {
            throw new UnsupportedOperationException();
        }

        public AbstractInfo getNextEntry() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String getDisplayName() {
            return "";
        }

        public URL getIcon() {
            return null;
        }
    };
    static /* synthetic */ Class class$org$osgi$service$deploymentadmin$spi$ResourceProcessor;

    private AbstractDeploymentPackage() {
        this.m_bundleContext = null;
        this.m_manifest = null;
        this.m_bundleInfos = null;
        this.m_resourceInfos = null;
        this.m_resourcePaths = null;
        this.m_isFixPackage = false;
    }

    public AbstractDeploymentPackage(Manifest manifest, BundleContext bundleContext) throws DeploymentException {
        int i;
        this.m_manifest = new DeploymentPackageManifest(manifest);
        this.m_isFixPackage = this.m_manifest.getFixPackage() != null;
        this.m_bundleContext = bundleContext;
        this.m_bundleInfos = this.m_manifest.getBundleInfos().toArray(new BundleInfoImpl[0]);
        for (i = 0; i < this.m_bundleInfos.length; ++i) {
            this.m_nameToBundleInfo.put(this.m_bundleInfos[i].getSymbolicName(), this.m_bundleInfos[i]);
            this.m_pathToEntry.put(this.m_bundleInfos[i].getPath(), this.m_bundleInfos[i]);
        }
        this.m_resourceInfos = this.m_manifest.getResourceInfos().toArray(new ResourceInfoImpl[0]);
        for (i = 0; i < this.m_resourceInfos.length; ++i) {
            this.m_pathToEntry.put(this.m_resourceInfos[i].getPath(), this.m_resourceInfos[i]);
        }
        this.m_resourcePaths = this.m_pathToEntry.keySet().toArray(new String[this.m_pathToEntry.size()]);
    }

    public Bundle getBundle(String symbolicName) {
        if (this.isStale()) {
            throw new IllegalStateException("Can not get bundle from stale deployment package.");
        }
        if (this.m_nameToBundleInfo.containsKey(symbolicName)) {
            Bundle[] bundles = this.m_bundleContext.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                if (!bundles[i].getSymbolicName().equals(symbolicName)) continue;
                return bundles[i];
            }
        }
        return null;
    }

    public BundleInfo[] getBundleInfos() {
        return (BundleInfo[])this.m_bundleInfos.clone();
    }

    public BundleInfoImpl[] getBundleInfoImpls() {
        return (BundleInfoImpl[])this.m_bundleInfos.clone();
    }

    public ResourceInfoImpl[] getResourceInfos() {
        return (ResourceInfoImpl[])this.m_resourceInfos.clone();
    }

    public boolean isFixPackage() {
        return this.m_isFixPackage;
    }

    public String getHeader(String header) {
        return this.m_manifest.getHeader(header);
    }

    public String getName() {
        return this.m_manifest.getSymbolicName();
    }

    public String getDisplayName() {
        return this.getHeader("DeploymentPackage-Name");
    }

    public URL getIcon() {
        String icon = this.getHeader("DeploymentPackage-Icon");
        if (icon == null) {
            return null;
        }
        try {
            return new URL(icon);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getResourceHeader(String resource, String header) {
        AbstractInfo info = (AbstractInfo)this.m_pathToEntry.get(resource);
        if (info != null) {
            return info.getHeader(header);
        }
        return null;
    }

    public ServiceReference getResourceProcessor(String resource) {
        String processor;
        if (this.isStale()) {
            throw new IllegalStateException("Can not get bundle from stale deployment package.");
        }
        AbstractInfo info = (AbstractInfo)this.m_pathToEntry.get(resource);
        if (info instanceof ResourceInfoImpl && (processor = ((ResourceInfoImpl)info).getResourceProcessor()) != null) {
            try {
                ServiceReference[] services = this.m_bundleContext.getServiceReferences((class$org$osgi$service$deploymentadmin$spi$ResourceProcessor == null ? (class$org$osgi$service$deploymentadmin$spi$ResourceProcessor = AbstractDeploymentPackage.class$("org.osgi.service.deploymentadmin.spi.ResourceProcessor")) : class$org$osgi$service$deploymentadmin$spi$ResourceProcessor).getName(), "(service.pid=" + processor + ")");
                if (services != null && services.length > 0) {
                    return services[0];
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                return null;
            }
        }
        return null;
    }

    public String[] getResources() {
        return (String[])this.m_resourcePaths.clone();
    }

    public Version getVersion() {
        return this.m_manifest.getVersion();
    }

    public VersionRange getVersionRange() {
        return this.m_manifest.getFixPackage();
    }

    public boolean isStale() {
        return false;
    }

    public void uninstall() throws DeploymentException {
        throw new IllegalStateException("Not implemented");
    }

    public boolean uninstallForced() throws DeploymentException {
        throw new IllegalStateException("Not implemented");
    }

    public abstract BundleInfoImpl[] getOrderedBundleInfos();

    public abstract ResourceInfoImpl[] getOrderedResourceInfos();

    public ResourceInfoImpl getResourceInfoByPath(String path) {
        AbstractInfo info = (AbstractInfo)this.m_pathToEntry.get(path);
        if (info instanceof ResourceInfoImpl) {
            return (ResourceInfoImpl)info;
        }
        return null;
    }

    protected AbstractInfo getAbstractInfoByPath(String path) {
        return (AbstractInfo)this.m_pathToEntry.get(path);
    }

    public BundleInfoImpl getBundleInfoByPath(String path) {
        AbstractInfo info = (AbstractInfo)this.m_pathToEntry.get(path);
        if (info instanceof BundleInfoImpl) {
            return (BundleInfoImpl)info;
        }
        return null;
    }

    public BundleInfoImpl getBundleInfoByName(String symbolicName) {
        return (BundleInfoImpl)this.m_nameToBundleInfo.get(symbolicName);
    }

    public abstract InputStream getBundleStream(String var1) throws IOException;

    public abstract AbstractInfo getNextEntry() throws IOException;

    public abstract InputStream getCurrentEntryStream();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

